/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import java.text.ParseException;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.importation.LiensImport;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.thesaurus.policies.PolicyProvider;
import net.fichotheque.tools.croisement.LienBuffer;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.LiensImportBuilder;
import net.fichotheque.tools.parsers.croisement.LienBufferParser;
import net.fichotheque.tools.parsers.croisement.PoidsMotcleToken;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.StringUtils;

public class LiensParser {
    private final LiensImportBuilder liensImportBuilder;
    private final Lang workingLang;
    private final Subset defaultSubset;
    private final Fichotheque fichotheque;
    private final PolicyProvider policyProvider;
    private final ThesaurusLangChecker thesaurusLangChecker;

    public LiensParser(Subset mainSubset, LiensImportBuilder liensImportBuilder, Lang workingLang, PolicyProvider policyProvider, ThesaurusLangChecker thesaurusLangChecker) {
        this.liensImportBuilder = liensImportBuilder;
        this.workingLang = workingLang;
        this.fichotheque = mainSubset.getFichotheque();
        this.defaultSubset = mainSubset instanceof Corpus ? mainSubset : null;
        this.policyProvider = policyProvider;
        this.thesaurusLangChecker = thesaurusLangChecker;
    }

    public void checkReplaceIncludeKey(IncludeKey includeKey) {
        this.liensImportBuilder.addRemovedIncludeKey(includeKey);
    }

    public void checkReplaceLiage() {
        this.liensImportBuilder.setLiageRemoved();
    }

    public void add(IncludeKey includeKey, String value, boolean replace, boolean idalpha) {
        SubsetKey subsetKey = includeKey.getSubsetKey();
        Subset otherSubset = this.fichotheque.getSubset(subsetKey);
        if (otherSubset != null) {
            if (idalpha && subsetKey.isThesaurusSubset() && ((Thesaurus)otherSubset).isIdalphaType()) {
                this.parseIdalpha((Thesaurus)otherSubset, includeKey, value, replace);
            } else if (this.defaultSubset != null && subsetKey.isThesaurusSubset()) {
                Thesaurus thesaurus = (Thesaurus)otherSubset;
                Lang thesaurusLang = ThesaurusUtils.checkDisponibility(this.thesaurusLangChecker, thesaurus, this.workingLang);
                DynamicEditPolicy dynamicEditPolicy = this.getDynamicEditPolicy(thesaurus);
                this.parseMotcle(thesaurus, includeKey, value, thesaurusLang, dynamicEditPolicy, replace);
            } else {
                this.parseId(otherSubset, includeKey, value, replace);
            }
        }
    }

    public void add(IncludeKey includeKey, List<String> values, boolean replace, boolean idalpha) {
        block7: {
            SubsetKey subsetKey = includeKey.getSubsetKey();
            Subset otherSubset = this.fichotheque.getSubset(subsetKey);
            if (otherSubset == null) break block7;
            if (idalpha && subsetKey.isThesaurusSubset() && ((Thesaurus)otherSubset).isIdalphaType()) {
                for (String value : values) {
                    this.parseIdalpha((Thesaurus)otherSubset, includeKey, value, replace);
                }
            } else if (this.defaultSubset != null && subsetKey.isThesaurusSubset()) {
                Thesaurus thesaurus = (Thesaurus)otherSubset;
                Lang thesaurusLang = ThesaurusUtils.checkDisponibility(this.thesaurusLangChecker, thesaurus, this.workingLang);
                DynamicEditPolicy dynamicEditPolicy = this.getDynamicEditPolicy(thesaurus);
                for (String value : values) {
                    this.parseMotcle(thesaurus, includeKey, value, thesaurusLang, dynamicEditPolicy, replace);
                }
            } else {
                for (String value : values) {
                    this.parseId(otherSubset, includeKey, value, replace);
                }
            }
        }
    }

    public void addLiage(String value, boolean replace) {
        String[] tokens;
        for (String token : tokens = StringUtils.getTechnicalTokens(value, false)) {
            try {
                LienBuffer lienBuffer = LienBufferParser.parse(this.fichotheque, token, (short)1, this.defaultSubset, "");
                LiensImport.LienImport lienImport = ImportationUtils.toLiageLienImport(lienBuffer.getSubsetItem(), lienBuffer.getPoids());
                if (replace) {
                    this.liensImportBuilder.addReplaceLienImport(lienImport);
                    continue;
                }
                this.liensImportBuilder.addAppendLienImport(lienImport);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public void addLiage(List<String> values, boolean replace) {
        for (String value : values) {
            this.addLiage(value, replace);
        }
    }

    private void parseId(Subset otherSubset, IncludeKey includeKey, String value, boolean replace) {
        String[] tokens;
        int poidsFilter = includeKey.getPoidsFilter();
        String mode = includeKey.getMode();
        for (String token : tokens = StringUtils.getTechnicalTokens(value, false)) {
            try {
                LienBuffer lienBuffer = LienBufferParser.parseId(otherSubset, token, mode, poidsFilter);
                LiensImport.LienImport lienImport = ImportationUtils.toLienImport(includeKey, lienBuffer.getSubsetItem(), lienBuffer.getPoids());
                if (replace) {
                    this.liensImportBuilder.addReplaceLienImport(lienImport);
                    continue;
                }
                this.liensImportBuilder.addAppendLienImport(lienImport);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void parseIdalpha(Thesaurus thesaurus, IncludeKey includeKey, String value, boolean replace) {
        String[] tokens;
        int poidsFilter = includeKey.getPoidsFilter();
        String mode = includeKey.getMode();
        for (String token : tokens = StringUtils.getTechnicalTokens(value, false)) {
            try {
                LienBuffer lienBuffer = LienBufferParser.parseIdalpha(thesaurus, token, mode, poidsFilter);
                LiensImport.LienImport lienImport = ImportationUtils.toLienImport(includeKey, lienBuffer.getSubsetItem(), lienBuffer.getPoids());
                if (replace) {
                    this.liensImportBuilder.addReplaceLienImport(lienImport);
                    continue;
                }
                this.liensImportBuilder.addAppendLienImport(lienImport);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void parseMotcle(Thesaurus thesaurus, IncludeKey includeKey, String value, Lang thesaurusLang, DynamicEditPolicy dynamicEditPolicy, boolean replace) {
        String[] tokens;
        boolean withIdalpha = thesaurus.isIdalphaType();
        int poidsFilter = includeKey.getPoidsFilter();
        String mode = includeKey.getMode();
        for (String token : tokens = StringUtils.getTechnicalTokens(value, ';', false)) {
            Label label;
            PoidsMotcleToken motcleToken = PoidsMotcleToken.parse(token, withIdalpha, poidsFilter);
            if (motcleToken == null) continue;
            int poids = motcleToken.getPoids();
            CleanedString labelText = motcleToken.getText();
            Motcle motcle = PoidsMotcleToken.getMotcle(motcleToken, thesaurus, thesaurusLang);
            if (motcle != null) {
                LiensImport.LienImport lienImport = ImportationUtils.toLienImport(includeKey, motcle, poids);
                if (replace) {
                    this.liensImportBuilder.addReplaceLienImport(lienImport);
                    continue;
                }
                this.liensImportBuilder.addAppendLienImport(lienImport);
                continue;
            }
            if (dynamicEditPolicy == null || withIdalpha || motcleToken.isIdBundle()) continue;
            if (dynamicEditPolicy instanceof DynamicEditPolicy.Allow) {
                Label label2 = this.toLabel(thesaurusLang, labelText);
                if (label2 == null) continue;
                LiensImport.LienImport lienImport = ImportationUtils.toLienImport(includeKey, thesaurus, label2, poids);
                if (replace) {
                    this.liensImportBuilder.addReplaceLienImport(lienImport);
                    continue;
                }
                this.liensImportBuilder.addAppendLienImport(lienImport);
                continue;
            }
            if (dynamicEditPolicy instanceof DynamicEditPolicy.Transfer) {
                Thesaurus transferThesaurus = ThesaurusUtils.getTransferThesaurus(this.fichotheque, dynamicEditPolicy);
                Motcle transferMotcle = this.getMotcle(transferThesaurus, thesaurusLang, labelText);
                IncludeKey includeKey2 = IncludeKey.newInstance(transferThesaurus.getSubsetKey(), mode, poidsFilter);
                if (transferMotcle == null) {
                    Label label3 = this.toLabel(thesaurusLang, labelText);
                    this.liensImportBuilder.addAppendLienImport(ImportationUtils.toLienImport(includeKey2, transferThesaurus, label3, poids));
                    continue;
                }
                this.liensImportBuilder.addAppendLienImport(ImportationUtils.toLienImport(includeKey2, transferMotcle, poids));
                continue;
            }
            if (!(dynamicEditPolicy instanceof DynamicEditPolicy.Check)) continue;
            Thesaurus[] checkThesaurusArray = ThesaurusUtils.getCheckThesaurusArray(this.fichotheque, dynamicEditPolicy);
            boolean done = false;
            for (Thesaurus checkThesaurus : checkThesaurusArray) {
                Motcle verifMotcle = this.getMotcle(checkThesaurus, thesaurusLang, labelText);
                if (motcle == null) continue;
                IncludeKey verifIncludeKey = IncludeKey.newInstance(checkThesaurus.getSubsetKey(), mode, poidsFilter);
                this.liensImportBuilder.addAppendLienImport(ImportationUtils.toLienImport(verifIncludeKey, verifMotcle, poids));
                done = true;
                break;
            }
            if (done || (label = this.toLabel(thesaurusLang, labelText)) == null) continue;
            LiensImport.LienImport lienImport = ImportationUtils.toLienImport(includeKey, thesaurus, label, poids);
            if (replace) {
                this.liensImportBuilder.addReplaceLienImport(lienImport);
                continue;
            }
            this.liensImportBuilder.addAppendLienImport(lienImport);
        }
    }

    private Label toLabel(Lang thesaurusLang, CleanedString labelString) {
        if (labelString != null) {
            return LabelUtils.toLabel(thesaurusLang, labelString);
        }
        return null;
    }

    private Motcle getMotcle(Thesaurus thesaurus, Lang thesaurusLang, CleanedString labelString) {
        if (labelString == null) {
            return null;
        }
        Lang lang = ThesaurusUtils.checkDisponibility(this.thesaurusLangChecker, thesaurus, thesaurusLang);
        return thesaurus.seekMotcleByLabel(labelString.toString(), lang);
    }

    private DynamicEditPolicy getDynamicEditPolicy(Thesaurus thesaurus) {
        DynamicEditPolicy dynamicEditPolicy = null;
        if (this.policyProvider != null && (dynamicEditPolicy = this.policyProvider.getDynamicEditPolicy(thesaurus)) instanceof DynamicEditPolicy.None) {
            dynamicEditPolicy = null;
        }
        return dynamicEditPolicy;
    }
}

