/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.LiensImportBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class LiensImportDOMReader {
    private final Fichotheque fichotheque;
    private final LiensImportBuilder liensImportBuilder;
    private final String type;

    public LiensImportDOMReader(Fichotheque fichotheque, LiensImportBuilder liensImportBuilder, String type) {
        this.fichotheque = fichotheque;
        this.liensImportBuilder = liensImportBuilder;
        this.type = type;
    }

    public LiensImportDOMReader read(Element element) {
        switch (this.type) {
            case "replace": {
                DOMUtils.readChildren(element, new LienConsumer(true));
                break;
            }
            case "append": {
                DOMUtils.readChildren(element, new LienConsumer(false));
                break;
            }
            case "remove": {
                DOMUtils.readChildren(element, new IncludeKeyConsumer());
            }
        }
        return this;
    }

    public static LiensImportDOMReader init(Fichotheque fichotheque, LiensImportBuilder liensImportBuilder, String type) {
        return new LiensImportDOMReader(fichotheque, liensImportBuilder, type);
    }

    static /* synthetic */ Fichotheque access$300(LiensImportDOMReader x0) {
        return x0.fichotheque;
    }

    private class LienConsumer
    implements Consumer<Element> {
        private final boolean replace;

        private LienConsumer(boolean replace) {
            this.replace = replace;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void accept(Element element) {
            var3_3 = tagName = element.getTagName();
            var4_4 = -1;
            switch (var3_3.hashCode()) {
                case 3321574: {
                    if (!var3_3.equals("lien")) break;
                    var4_4 = 0;
                }
            }
            switch (var4_4) {
                case 0: {
                    lienImport = null;
                    originIncludeKey = null;
                    subset = null;
                    includeKeyString = element.getAttribute("include-key");
                    if (includeKeyString.isEmpty()) {
                        includeKeyString = element.getAttribute("origin");
                    }
                    if (!includeKeyString.isEmpty()) {
                        try {
                            originIncludeKey = IncludeKey.parse(includeKeyString);
                            subset = LiensImportDOMReader.access$300(LiensImportDOMReader.this).getSubset(originIncludeKey.getSubsetKey());
                        }
                        catch (ParseException pe) {
                            return;
                        }
                    }
                    try {
                        subsetKey = SubsetKey.parse(element.getAttribute("subset"));
                        subset = LiensImportDOMReader.access$300(LiensImportDOMReader.this).getSubset(subsetKey);
                        if (!subsetKey.isCorpusSubset()) {
                            originIncludeKey = IncludeKey.newInstance(subsetKey);
                        }
                    }
                    catch (ParseException pe) {
                        return;
                    }
                    if (subset == null) {
                        return;
                    }
                    poids = 1;
                    try {
                        poids = Integer.parseInt(element.getAttribute("poids"));
                        if (poids < 1) {
                            poids = 1;
                        }
                    }
                    catch (NumberFormatException var10_13) {
                        // empty catch block
                    }
                    idString = element.getAttribute("id");
                    if (idString.length() <= 0) ** GOTO lbl53
                    try {
                        id = Integer.parseInt(idString);
                        subsetItem = subset.getSubsetItemById(id);
                        if (subsetItem == null) ** GOTO lbl67
                        if (originIncludeKey == null) ** GOTO lbl49
                        lienImport = ImportationUtils.toLienImport(originIncludeKey, subsetItem, poids);
                        ** GOTO lbl67
lbl49:
                        // 1 sources

                        lienImport = ImportationUtils.toLiageLienImport(subsetItem, poids);
                    }
                    catch (NumberFormatException id) {}
                    ** GOTO lbl67
lbl53:
                    // 1 sources

                    if (subset instanceof Thesaurus) {
                        thesaurus = (Thesaurus)subset;
                        idalpha = element.getAttribute("idalpha");
                        if (!idalpha.isEmpty()) {
                            lienImport = ImportationUtils.toLienImport(originIncludeKey, thesaurus, idalpha, poids);
                        } else {
                            try {
                                lang = Lang.parse(element.getAttribute("lang"));
                                labelString = CleanedString.newInstance(element.getAttribute("label"));
                                if (labelString != null) {
                                    lienImport = ImportationUtils.toLienImport(originIncludeKey, thesaurus, LabelUtils.toLabel(lang, labelString), poids);
                                }
                            }
                            catch (ParseException var13_21) {
                                // empty catch block
                            }
                        }
                    }
lbl67:
                    // 9 sources

                    if (lienImport == null) break;
                    if (this.replace) {
                        LiensImportDOMReader.access$200(LiensImportDOMReader.this).addReplaceLienImport(lienImport);
                        break;
                    }
                    LiensImportDOMReader.access$200(LiensImportDOMReader.this).addAppendLienImport(lienImport);
                }
            }
        }
    }

    private class IncludeKeyConsumer
    implements Consumer<Element> {
        private IncludeKeyConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "include-key": {
                    String value = DOMUtils.readSimpleElement(element);
                    if (value.equals("liage")) {
                        LiensImportDOMReader.this.liensImportBuilder.setLiageRemoved();
                        break;
                    }
                    try {
                        IncludeKey includeKey = IncludeKey.parse(value);
                        LiensImportDOMReader.this.liensImportBuilder.addRemovedIncludeKey(includeKey);
                        break;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

