/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.corpus;

import java.util.List;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.importation.CorpusImport;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.RemoveCorpusImportBuilder;

public abstract class CorpusImportBuilder {
    private final Corpus corpus;
    private final String type;

    protected CorpusImportBuilder(Corpus corpus, String type) {
        this.corpus = corpus;
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Corpus getCorpus() {
        return this.corpus;
    }

    public static CorpusImportBuilder init(Corpus corpus, String type) {
        switch (type = CorpusImport.checkType(type)) {
            case "edit": {
                return new EditCorpusImportBuilder(corpus);
            }
            case "remove": {
                return new RemoveCorpusImportBuilder(corpus);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public CorpusImport toCorpusImport() {
        return new InternalCorpusImport(this.corpus, this.type, this.getFicheImportList());
    }

    protected abstract List<CorpusImport.FicheImport> getFicheImportList();

    private static class InternalCorpusImport
    implements CorpusImport {
        private final Corpus corpus;
        private final String type;
        private final List<CorpusImport.FicheImport> ficheImportList;

        private InternalCorpusImport(Corpus corpus, String type, List<CorpusImport.FicheImport> ficheImportList) {
            this.corpus = corpus;
            this.type = type;
            this.ficheImportList = ficheImportList;
        }

        @Override
        public Corpus getCorpus() {
            return this.corpus;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public List<CorpusImport.FicheImport> getFicheImportList() {
            return this.ficheImportList;
        }
    }
}

