/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import net.fichotheque.importation.ParseResult;

public class ParseResultBuilder {
    private final String type;
    private final List<ParseResult.InitError> initErrorList = new ArrayList<ParseResult.InitError>();
    private final List<ParseResult.InitWarning> initWarningList = new ArrayList<ParseResult.InitWarning>();
    private final List<ParseResult.ParseError> parseErrorList = new ArrayList<ParseResult.ParseError>();
    private final List<ParseResult.BdfError> bdfErrorList = new ArrayList<ParseResult.BdfError>();
    private final Map<String, ParseResult.ResultItem> resultItemMap = new LinkedHashMap<String, ParseResult.ResultItem>();
    private String path = "";

    public ParseResultBuilder(String type) {
        this.type = type;
    }

    public ParseResultBuilder addInitError(String key, String value) {
        this.initErrorList.add(new InternalInitError(key, value));
        return this;
    }

    public ParseResultBuilder addInitWarning(String key, String value) {
        this.initWarningList.add(new InternalInitWarning(key, value));
        return this;
    }

    public ParseResultBuilder addParseError(String parseError, int lineNumber) {
        this.parseErrorList.add(new InternalParseError(parseError, lineNumber));
        return this;
    }

    public ParseResultBuilder addBdfError(String key, String text, int lineNumber) {
        this.bdfErrorList.add(new InternalBdfError(key, text, lineNumber));
        return this;
    }

    public boolean checkDoublon(String idString, int lineNumber) {
        ParseResult.ResultItem currentResultItem = this.resultItemMap.get(idString);
        if (currentResultItem != null) {
            this.addBdfError("DOUBLON", String.valueOf(currentResultItem.getLineNumber()), lineNumber);
            return true;
        }
        return false;
    }

    public ParseResultBuilder addResult(String idString, Object key, Object value, int lineNumber) {
        InternalResultItem resultItem = new InternalResultItem(key, value, lineNumber);
        this.resultItemMap.put(idString, resultItem);
        return this;
    }

    public ParseResultBuilder setPath(String path) {
        this.path = path;
        return this;
    }

    public ParseResult toParseResult() {
        InitErrorList finalInitErrorList = new InitErrorList(this.initErrorList.toArray(new ParseResult.InitError[this.initErrorList.size()]));
        InitWarningList finalInitWarningList = new InitWarningList(this.initWarningList.toArray(new ParseResult.InitWarning[this.initWarningList.size()]));
        ParseErrorList finalParseErrorList = new ParseErrorList(this.parseErrorList.toArray(new ParseResult.ParseError[this.parseErrorList.size()]));
        BdfErrorList finalBdfErrorList = new BdfErrorList(this.bdfErrorList.toArray(new ParseResult.BdfError[this.bdfErrorList.size()]));
        ResultItemList resultItemList = new ResultItemList(this.resultItemMap.values().toArray(new ParseResult.ResultItem[this.resultItemMap.size()]));
        return new InternalParseResult(this.type, finalInitErrorList, finalInitWarningList, finalParseErrorList, finalBdfErrorList, resultItemList, this.path);
    }

    public static ParseResultBuilder init(String type) {
        return new ParseResultBuilder(type);
    }

    private static class InternalInitError
    implements ParseResult.InitError {
        private final String key;
        private final String text;

        private InternalInitError(String key, String text) {
            this.key = key;
            this.text = text;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    private static class InternalInitWarning
    implements ParseResult.InitWarning {
        private final String key;
        private final String text;

        private InternalInitWarning(String key, String text) {
            this.key = key;
            this.text = text;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    private static class InternalParseError
    implements ParseResult.ParseError {
        private final String rawText;
        private final int lineNumber;

        private InternalParseError(String rawText, int lineNumber) {
            this.rawText = rawText;
            this.lineNumber = lineNumber;
        }

        @Override
        public String getRawText() {
            return this.rawText;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    private static class InternalBdfError
    implements ParseResult.BdfError {
        private final String key;
        private final String text;
        private final int lineNumber;

        private InternalBdfError(String key, String text, int lineNumber) {
            this.key = key;
            this.text = text;
            this.lineNumber = lineNumber;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    private static class InternalResultItem
    implements ParseResult.ResultItem {
        private final Object keyObject;
        private final Object valueObject;
        private final int lineNumber;

        private InternalResultItem(Object keyObject, Object valueObject, int lineNumber) {
            this.keyObject = keyObject;
            this.valueObject = valueObject;
            this.lineNumber = lineNumber;
        }

        @Override
        public Object getKeyObject() {
            return this.keyObject;
        }

        @Override
        public Object getValueObject() {
            return this.valueObject;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    private static class InitErrorList
    extends AbstractList<ParseResult.InitError>
    implements RandomAccess {
        private final ParseResult.InitError[] array;

        private InitErrorList(ParseResult.InitError[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ParseResult.InitError get(int index) {
            return this.array[index];
        }
    }

    private static class InitWarningList
    extends AbstractList<ParseResult.InitWarning>
    implements RandomAccess {
        private final ParseResult.InitWarning[] array;

        private InitWarningList(ParseResult.InitWarning[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ParseResult.InitWarning get(int index) {
            return this.array[index];
        }
    }

    private static class ParseErrorList
    extends AbstractList<ParseResult.ParseError>
    implements RandomAccess {
        private final ParseResult.ParseError[] array;

        private ParseErrorList(ParseResult.ParseError[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ParseResult.ParseError get(int index) {
            return this.array[index];
        }
    }

    private static class BdfErrorList
    extends AbstractList<ParseResult.BdfError>
    implements RandomAccess {
        private final ParseResult.BdfError[] array;

        private BdfErrorList(ParseResult.BdfError[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ParseResult.BdfError get(int index) {
            return this.array[index];
        }
    }

    private static class ResultItemList
    extends AbstractList<ParseResult.ResultItem>
    implements RandomAccess {
        private final ParseResult.ResultItem[] array;

        private ResultItemList(ParseResult.ResultItem[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ParseResult.ResultItem get(int index) {
            return this.array[index];
        }
    }

    private static class InternalParseResult
    implements ParseResult {
        private final String type;
        private final List<ParseResult.InitError> initErrorList;
        private final List<ParseResult.InitWarning> initWarningList;
        private final List<ParseResult.ParseError> parseErrorList;
        private final List<ParseResult.BdfError> bdfErrorList;
        private final List<ParseResult.ResultItem> resultItemList;
        private final String path;

        private InternalParseResult(String type, List<ParseResult.InitError> initErrorList, List<ParseResult.InitWarning> initWarningList, List<ParseResult.ParseError> parseErrorList, List<ParseResult.BdfError> bdfErrorList, List<ParseResult.ResultItem> resultItemList, String path) {
            this.type = type;
            this.initErrorList = initErrorList;
            this.initWarningList = initWarningList;
            this.parseErrorList = parseErrorList;
            this.bdfErrorList = bdfErrorList;
            this.resultItemList = resultItemList;
            this.path = path;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public List<ParseResult.InitError> getInitErrorList() {
            return this.initErrorList;
        }

        @Override
        public List<ParseResult.InitWarning> getInitWarningList() {
            return this.initWarningList;
        }

        @Override
        public List<ParseResult.ParseError> getParseErrorList() {
            return this.parseErrorList;
        }

        @Override
        public List<ParseResult.BdfError> getBdfErrorList() {
            return this.bdfErrorList;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public List<ParseResult.ResultItem> getResultItemList() {
            return this.resultItemList;
        }
    }
}

