/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers.subfield;

import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.tools.format.tokenizers.subfield.GeopointProprieteTokenizer;
import net.fichotheque.tools.format.tokenizers.subfield.ImageProprieteTokenizer;
import net.fichotheque.tools.format.tokenizers.subfield.MontantInformationTokenizer;
import net.fichotheque.tools.format.tokenizers.subfield.MontantProprieteTokenizer;
import net.fichotheque.tools.format.tokenizers.subfield.PersonneProprieteTokenizer;
import net.mapeadores.util.exceptions.SwitchException;

public class SubfieldTokenizerFactory {
    private SubfieldTokenizerFactory() {
    }

    public static Tokenizer newInstance(CorpusField corpusField, SubfieldKey subfieldKey, SubfieldFormatter subfieldFormatter, Fichotheque fichotheque) {
        short subfieldType = subfieldKey.getSubtype();
        switch (subfieldType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new PersonneProprieteTokenizer(subfieldKey, subfieldFormatter, fichotheque);
            }
            case 31: 
            case 32: 
            case 33: {
                return new ImageProprieteTokenizer(subfieldKey, subfieldFormatter);
            }
            case 11: 
            case 12: {
                return new MontantProprieteTokenizer(subfieldKey, subfieldFormatter);
            }
            case 21: 
            case 22: {
                return new GeopointProprieteTokenizer(subfieldKey, subfieldFormatter);
            }
            case 99: 
            case 111: {
                return new MontantInformationTokenizer(corpusField, subfieldKey, subfieldFormatter);
            }
        }
        throw new SwitchException("subfieldType = " + subfieldType);
    }
}

