/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers.subfield;

import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Personne;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.FormatterUtils;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.models.PersonCore;

class PersonneProprieteTokenizer
implements Tokenizer {
    private final Fichotheque fichotheque;
    private final SubfieldKey subfieldKey;
    private final SubfieldFormatter subfieldFormatter;

    PersonneProprieteTokenizer(SubfieldKey subfieldKey, SubfieldFormatter subfieldFormatter, Fichotheque fichotheque) {
        this.subfieldKey = subfieldKey;
        this.fichotheque = fichotheque;
        this.subfieldFormatter = subfieldFormatter;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        FicheItem ficheItem = (FicheItem)((FichePointeur)formatSource.getSubsetItemPointeur()).getValue(this.subfieldKey);
        if (ficheItem == null) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        if (!(ficheItem instanceof Personne)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        PersonCore personCore = SphereUtils.toPersonCore(this.fichotheque, (Personne)ficheItem);
        String subfieldString = this.getSubfieldString(personCore, this.subfieldKey.getSubtype());
        if (subfieldString != null) {
            SubfieldValue subfieldValue = FormatterUtils.toSubfieldValue(subfieldString);
            String value = this.subfieldFormatter.formatSubfield(subfieldValue, formatSource);
            return FormatterUtils.toTokens(value);
        }
        return FormatterUtils.EMPTY_TOKENS;
    }

    private String getSubfieldString(PersonCore personCore, short subfieldType) {
        switch (subfieldType) {
            case 1: {
                return personCore.getSurname();
            }
            case 2: {
                return personCore.getForename();
            }
            case 4: {
                return personCore.getNonlatin();
            }
            case 3: {
                boolean surnameFirst = personCore.isSurnameFirst();
                return surnameFirst ? "1" : "0";
            }
        }
        throw new SwitchException("subfieldType = " + subfieldType);
    }
}

