/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers.subfield;

import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Image;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.SwitchException;

public class ImageProprieteTokenizer
implements Tokenizer {
    private final SubfieldKey subfieldKey;
    private final SubfieldFormatter subfieldFormatter;

    ImageProprieteTokenizer(SubfieldKey subfieldKey, SubfieldFormatter subfieldFormatter) {
        this.subfieldKey = subfieldKey;
        this.subfieldFormatter = subfieldFormatter;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        FicheItem ficheItem = (FicheItem)((FichePointeur)formatSource.getSubsetItemPointeur()).getValue(this.subfieldKey);
        if (ficheItem == null) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        short subfieldType = this.subfieldKey.getSubtype();
        if (!(ficheItem instanceof Image)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        Image image = (Image)ficheItem;
        String subfieldString = this.getSubfieldString(image, subfieldType);
        if (subfieldString != null) {
            SubfieldValue subfieldValue = FormatterUtils.toSubfieldValue(subfieldString);
            String value = this.subfieldFormatter.formatSubfield(subfieldValue, formatSource);
            return FormatterUtils.toTokens(value);
        }
        return FormatterUtils.EMPTY_TOKENS;
    }

    private String getSubfieldString(Image image, short subfieldType) {
        switch (subfieldType) {
            case 31: {
                return image.getSrc();
            }
            case 32: {
                return image.getAlt();
            }
            case 33: {
                return image.getTitle();
            }
        }
        throw new SwitchException("subfieldType = " + subfieldType);
    }
}

