/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.FicheMetaFormatter;
import net.fichotheque.pointeurs.SubsetItemPointeur;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.FormatterUtils;

public class ParentageTokenizer
implements Tokenizer {
    private final FicheMetaFormatter ficheMetaFormatter;
    private final boolean globalSelect;

    public ParentageTokenizer(FicheMetaFormatter ficheMetaFormatter, boolean globalSelect) {
        this.ficheMetaFormatter = ficheMetaFormatter;
        this.globalSelect = globalSelect;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        List<FicheMeta> list = this.getList(formatSource);
        if (list == null || list.isEmpty()) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        return new InternalTokens(this.ficheMetaFormatter, list, formatSource);
    }

    private List<FicheMeta> getList(FormatSource formatSource) {
        SubsetItemPointeur subsetItemPointeur;
        SubsetItem currentSubsetItem;
        Predicate<SubsetItem> predicate = null;
        if (this.globalSelect) {
            predicate = formatSource.getGlobalPredicate();
        }
        if ((currentSubsetItem = (subsetItemPointeur = formatSource.getSubsetItemPointeur()).getCurrentSubsetItem()) == null) {
            return null;
        }
        Subset subset = subsetItemPointeur.getSubset();
        List<Corpus> parentageCorpusList = subset instanceof Thesaurus ? subset.getSatelliteCorpusList() : FichothequeUtils.getParentageCorpusList((Corpus)subset);
        if (parentageCorpusList.isEmpty()) {
            return null;
        }
        int id = currentSubsetItem.getId();
        ArrayList<FicheMeta> resultList = new ArrayList<FicheMeta>();
        for (Corpus corpus : parentageCorpusList) {
            FicheMeta ficheMeta;
            if (!formatSource.getSubsetAccessPredicate().test(corpus) || (ficheMeta = corpus.getFicheMetaById(id)) == null || predicate != null && !predicate.test(ficheMeta)) continue;
            resultList.add(ficheMeta);
        }
        return resultList;
    }

    private static class InternalTokens
    extends AbstractList<String>
    implements Tokens {
        private final FicheMetaFormatter ficheMetaFormatter;
        private final List<FicheMeta> ficheMetaList;
        private final FormatSource formatSource;

        private InternalTokens(FicheMetaFormatter ficheMetaFormatter, List<FicheMeta> ficheMetaList, FormatSource formatSource) {
            this.ficheMetaList = ficheMetaList;
            this.ficheMetaFormatter = ficheMetaFormatter;
            this.formatSource = formatSource;
        }

        @Override
        public int size() {
            return this.ficheMetaList.size();
        }

        @Override
        public String get(int i) {
            FicheMeta ficheMeta = this.ficheMetaList.get(i);
            return this.ficheMetaFormatter.formatFicheMeta(ficheMeta, 0, this.formatSource);
        }
    }
}

