/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.IllustrationFormatter;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.FormatterUtils;

public class IllustrationTokenizer
implements Tokenizer {
    private final Album album;
    private final IllustrationFormatter illustrationFormatter;
    private final String mode;
    private final int poidsFilter;
    private final boolean globalSelect;

    public IllustrationTokenizer(Album album, IllustrationFormatter illustrationFormatter, String mode, int poidsFilter, boolean globalSelect) {
        this.album = album;
        this.illustrationFormatter = illustrationFormatter;
        this.mode = mode;
        this.poidsFilter = poidsFilter;
        this.globalSelect = globalSelect;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        Croisements croisements;
        ArrayList<Liaison> liaisons;
        if (!formatSource.getSubsetAccessPredicate().test(this.album)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        Predicate<SubsetItem> predicate = null;
        if (this.globalSelect) {
            predicate = formatSource.getGlobalPredicate();
        }
        if ((liaisons = new ArrayList<Liaison>(CroisementUtils.filter(croisements = formatSource.getSubsetItemPointeur().getCroisements(this.album), this.mode, this.poidsFilter))).isEmpty()) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        return new InternalTokens(liaisons, this.illustrationFormatter, formatSource);
    }

    private static class InternalTokens
    extends AbstractList<String>
    implements Tokens {
        private final List<Liaison> liaisonList;
        private final IllustrationFormatter illustrationFormatter;
        private final FormatSource formatSource;

        private InternalTokens(List<Liaison> liaisonList, IllustrationFormatter illustrationFormatter, FormatSource formatSource) {
            this.liaisonList = liaisonList;
            this.illustrationFormatter = illustrationFormatter;
            this.formatSource = formatSource;
        }

        @Override
        public int size() {
            return this.liaisonList.size();
        }

        @Override
        public String get(int i) {
            Liaison liaison = this.liaisonList.get(i);
            return this.illustrationFormatter.formatIllustration((Illustration)liaison.getSubsetItem(), liaison.getLien().getPoids(), this.formatSource);
        }
    }
}

