/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers;

import java.util.ArrayList;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.FicheItemFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.FormatterUtils;

public abstract class FicheItemTokenizer
implements Tokenizer {
    public static final short NONE_FILTER = 0;
    public static final short NOITEM_FILTER = 1;
    public static final short ONLYITEM_FILTER = 2;
    protected final CorpusField corpusField;
    protected final FicheItemFormatter ficheItemFormatter;
    private final short itemFilter;

    private FicheItemTokenizer(CorpusField corpusField, FicheItemFormatter ficheItemFormatter, short itemFilter) {
        this.corpusField = corpusField;
        this.ficheItemFormatter = ficheItemFormatter;
        this.itemFilter = itemFilter;
    }

    public boolean isSameType(int ficheItemType) {
        return this.corpusField.getFicheItemType() == ficheItemType;
    }

    public FicheItemFormatter getFicheItemFormatter() {
        return this.ficheItemFormatter;
    }

    boolean testFicheItem(FicheItem ficheItem) {
        if (ficheItem == null) {
            return false;
        }
        switch (this.itemFilter) {
            case 1: {
                if (!(ficheItem instanceof Item) || this.corpusField.getFicheItemType() == 1) break;
                return false;
            }
            case 2: {
                if (ficheItem instanceof Item) break;
                return false;
            }
        }
        return true;
    }

    public static FicheItemTokenizer newInstance(CorpusField corpusField, FicheItemFormatter ficheItemFormat, short itemFilter) {
        if (FicheItemTokenizer.isProprieteTokenizer(corpusField)) {
            return new ProprieteTokenizer(corpusField, ficheItemFormat, itemFilter);
        }
        return new InformationTokenizer(corpusField, ficheItemFormat, itemFilter);
    }

    private static boolean isProprieteTokenizer(CorpusField corpusField) {
        if (corpusField.isPropriete()) {
            return true;
        }
        switch (corpusField.getFieldString()) {
            case "lang": 
            case "soustitre": {
                return true;
            }
        }
        return false;
    }

    private static class ProprieteTokenizer
    extends FicheItemTokenizer {
        private ProprieteTokenizer(CorpusField corpusField, FicheItemFormatter ficheItemFormat, short itemFilter) {
            super(corpusField, ficheItemFormat, itemFilter);
        }

        @Override
        public Tokens tokenize(FormatSource formatSource) {
            FicheItem ficheItem = (FicheItem)((FichePointeur)formatSource.getSubsetItemPointeur()).getValue(this.corpusField);
            if (this.testFicheItem(ficheItem)) {
                return FormatterUtils.toTokens(this.ficheItemFormatter.formatFicheItem(ficheItem, formatSource));
            }
            return FormatterUtils.EMPTY_TOKENS;
        }
    }

    private static class InformationTokenizer
    extends FicheItemTokenizer {
        private InformationTokenizer(CorpusField corpusField, FicheItemFormatter ficheItemFormat, short itemFilter) {
            super(corpusField, ficheItemFormat, itemFilter);
        }

        @Override
        public Tokens tokenize(FormatSource formatSource) {
            FicheItems ficheItems = (FicheItems)((FichePointeur)formatSource.getSubsetItemPointeur()).getValue(this.corpusField);
            if (ficheItems == null) {
                return FormatterUtils.EMPTY_TOKENS;
            }
            ArrayList<String> valueList = new ArrayList<String>();
            for (FicheItem ficheItem : ficheItems) {
                if (!this.testFicheItem(ficheItem)) continue;
                valueList.add(this.ficheItemFormatter.formatFicheItem(ficheItem, formatSource));
            }
            if (valueList.isEmpty()) {
                return FormatterUtils.EMPTY_TOKENS;
            }
            return FormatterUtils.toTokens(valueList);
        }
    }
}

