/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheItemFormatter;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.tools.format.formatters.FicheItemFormatterParser;
import net.fichotheque.tools.format.formatters.FormatterParserUtils;
import net.fichotheque.tools.format.patterndefs.DefaultPattern;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class SubfieldFormatterParser {
    private static final SubfieldFormatter STRING_VALUE_PART = (subfieldValue, formatSource) -> {
        Object obj = subfieldValue.getValue();
        if (!(obj instanceof String)) {
            return "#ERR: " + obj.getClass().getName();
        }
        return (String)obj;
    };
    private static final SubfieldFormatter STRING_VALUE_UP_PART = (subfieldValue, formatSource) -> {
        Object obj = subfieldValue.getValue();
        if (!(obj instanceof String)) {
            return "#ERR: " + obj.getClass().getName();
        }
        return FormatterParserUtils.toUppercase((String)obj, formatSource);
    };

    private SubfieldFormatterParser() {
    }

    public static SubfieldFormatter parse(short subfieldType, String pattern, FormatContext formatContext, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPattern.subfield(subfieldType);
        }
        try {
            return SubfieldFormatterParser.parse(subfieldType, pattern, formatContext);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static SubfieldFormatter parse(short subfieldType, String pattern, FormatContext formatContext) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext, subfieldType), pattern);
        return new InternalSubfieldFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final FormatContext formatContext;
        private final short subfieldType;

        private InternalInstructionResolver(FormatContext formatContext, short subfieldType) {
            this.formatContext = formatContext;
            this.subfieldType = subfieldType;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            Object formatter;
            InstructionResolver resolver = this.formatContext.getInstructionResolverProvider().getInstructionResolver(SubfieldFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            switch (this.subfieldType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 11: 
                case 12: 
                case 21: 
                case 22: 
                case 31: 
                case 32: 
                case 33: {
                    return this.resolveStringValue(instruction);
                }
                case 99: 
                case 111: {
                    return this.resolveMontant(instruction, this.formatContext);
                }
            }
            throw new SwitchException("subfieldType = " + this.subfieldType);
        }

        private SubfieldFormatter resolveStringValue(Instruction instruction) {
            String key;
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "formsyntax": {
                    return STRING_VALUE_PART;
                }
                case "value": {
                    boolean up = FormatterParserUtils.isUppercase(instruction);
                    if (up) {
                        return STRING_VALUE_UP_PART;
                    }
                    return STRING_VALUE_PART;
                }
            }
            return null;
        }

        private SubfieldFormatter resolveMontant(Instruction instruction, FormatContext formatContext) throws ErrorMessageException {
            FicheItemFormatter ficheItemFormatter = FicheItemFormatterParser.resolveFicheItem(instruction, (short)9, formatContext, null);
            if (ficheItemFormatter == null) {
                return null;
            }
            return new FicheItemSubfieldPart(ficheItemFormatter);
        }
    }

    private static class InternalSubfieldFormatter
    implements SubfieldFormatter {
        private final Object[] partArray;

        private InternalSubfieldFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatSubfield(SubfieldValue subfieldValue, FormatSource formatSource) {
            if (subfieldValue == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                SubfieldFormatter formatter = (SubfieldFormatter)obj;
                buf.append(formatter.formatSubfield(subfieldValue, formatSource));
            }
            return buf.toString();
        }
    }

    private static class FicheItemSubfieldPart
    implements SubfieldFormatter {
        private final FicheItemFormatter ficheItemFormatter;

        private FicheItemSubfieldPart(FicheItemFormatter ficheItemFormatter) {
            this.ficheItemFormatter = ficheItemFormatter;
        }

        @Override
        public String formatSubfield(SubfieldValue subfieldValue, FormatSource formatSource) {
            Object obj = subfieldValue.getValue();
            if (!(obj instanceof FicheItem)) {
                return "#ERR: " + obj.getClass().getName();
            }
            return this.ficheItemFormatter.formatFicheItem((FicheItem)obj, formatSource);
        }
    }
}

