/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import java.io.IOException;
import net.fichotheque.album.Illustration;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.IllustrationFormatter;
import net.fichotheque.json.IllustrationJson;
import net.fichotheque.tools.format.formatters.JsonParameters;
import net.fichotheque.tools.format.patterndefs.DefaultPattern;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class IllustrationFormatterParser {
    private static final IllustrationFormatter ALBUM_PART = (illustration, poids, formatSource) -> illustration.getSubsetName();
    private static final IllustrationFormatter FORMAT_PART = (illustration, poids, formatSource) -> illustration.getFormatTypeString();
    private static final IllustrationFormatter ID_PART = (illustration, poids, formatSource) -> String.valueOf(illustration.getId());
    private static final IllustrationFormatter POIDS_PART = (illustration, poids, formatSource) -> String.valueOf(poids);
    private static final IllustrationFormatter WITHPOIDSFILTER_FORMSYNTAX_PART = new FormSyntaxPart(true);
    private static final IllustrationFormatter WITHOUTPOIDSFILTER_FORMSYNTAX_PART = new FormSyntaxPart(false);
    private static final JsonParameters DEFAULT_JSONPARAMETERS = JsonParameters.parse("format");

    private IllustrationFormatterParser() {
    }

    public static IllustrationFormatter parse(String pattern, FormatContext formatContext, boolean withPoidsFilter, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPattern.illustration();
        }
        try {
            return IllustrationFormatterParser.parse(pattern, formatContext, withPoidsFilter);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static IllustrationFormatter parse(String pattern, FormatContext formatContext, boolean withPoidsFilter) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext, withPoidsFilter), pattern);
        return new InternalIllustrationFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final InstructionResolverProvider provider;
        private final boolean withPoidsFilter;

        private InternalInstructionResolver(FormatContext formatContext, boolean withPoidsFilter) {
            this.provider = formatContext.getInstructionResolverProvider();
            this.withPoidsFilter = withPoidsFilter;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.provider.getInstructionResolver(IllustrationFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "album": {
                    return ALBUM_PART;
                }
                case "format": {
                    return FORMAT_PART;
                }
                case "formsyntax": {
                    if (this.withPoidsFilter) {
                        return WITHPOIDSFILTER_FORMSYNTAX_PART;
                    }
                    return WITHOUTPOIDSFILTER_FORMSYNTAX_PART;
                }
                case "id": 
                case "idalbum": {
                    return ID_PART;
                }
                case "json": {
                    JsonParameters jsonParameters = JsonParameters.fromInstruction(instruction);
                    if (jsonParameters == null) {
                        jsonParameters = DEFAULT_JSONPARAMETERS;
                    }
                    return new JsonPart(jsonParameters);
                }
                case "poids": {
                    return POIDS_PART;
                }
            }
            return null;
        }
    }

    private static class InternalIllustrationFormatter
    implements IllustrationFormatter {
        private final Object[] partArray;

        private InternalIllustrationFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatIllustration(Illustration illustration, int poids, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                IllustrationFormatter formatter = (IllustrationFormatter)obj;
                buf.append(formatter.formatIllustration(illustration, poids, formatSource));
            }
            return buf.toString();
        }
    }

    private static class FormSyntaxPart
    implements IllustrationFormatter {
        private final boolean withPoidsFilter;

        private FormSyntaxPart(boolean withPoidsFilter) {
            this.withPoidsFilter = withPoidsFilter;
        }

        @Override
        public String formatIllustration(Illustration illustration, int poids, FormatSource formatSource) {
            if (this.withPoidsFilter || poids == 1) {
                return String.valueOf(illustration.getId());
            }
            StringBuilder buf = new StringBuilder();
            buf.append(String.valueOf(illustration.getId()));
            buf.append(" <");
            buf.append(poids);
            buf.append(">");
            return buf.toString();
        }
    }

    private static class JsonPart
    implements IllustrationFormatter {
        private final JsonParameters jsonParameters;

        private JsonPart(JsonParameters jsonParameters) {
            this.jsonParameters = jsonParameters;
        }

        @Override
        public String formatIllustration(Illustration illustration, int poids, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            JSONWriter jsonWriter = new JSONWriter(buf);
            try {
                jsonWriter.object();
                IllustrationJson.properties(jsonWriter, illustration, this.jsonParameters);
                jsonWriter.endObject();
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            return buf.toString();
        }
    }
}

