/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.Courriel;
import net.fichotheque.corpus.fiche.Datation;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Geopoint;
import net.fichotheque.corpus.fiche.Image;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Langue;
import net.fichotheque.corpus.fiche.Link;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.corpus.fiche.Nombre;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.Pays;
import net.fichotheque.corpus.fiche.Personne;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.format.formatters.FicheItemFormatter;
import net.fichotheque.json.FicheItemJson;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.syntax.FormSyntax;
import net.fichotheque.tools.format.formatters.FormatterParserUtils;
import net.fichotheque.tools.format.formatters.JsonParameters;
import net.fichotheque.tools.format.formatters.LangParameters;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.SpecialCodes;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreSexagesimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.DateFormatBundle;
import net.mapeadores.util.text.StringUtils;

final class FicheItemFormatterParts {
    public static final FicheItemFormatter PAYS_CODE_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Pays) {
            return ((Pays)ficheItem).getCountry().toString();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter LANGUE_CODE_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Langue) {
            return ((Langue)ficheItem).getLang().toString();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter ITEM_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Item) {
            return ((Item)ficheItem).getValue();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PARA_RAW_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Para) {
            return ((Para)ficheItem).contentToString();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter GEO_LAT_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Geopoint) {
            return ((Geopoint)ficheItem).getLatitude().toString();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter GEO_LON_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Geopoint) {
            return ((Geopoint)ficheItem).getLongitude().toString();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter LINK_HREF_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Link) {
            return ((Link)ficheItem).getHref();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter LINK_TITLE_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Link) {
            return ((Link)ficheItem).getTitle();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter LINK_COMMENT_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Link) {
            return ((Link)ficheItem).getComment();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter IMAGE_SRC_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Image) {
            return ((Image)ficheItem).getSrc();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter IMAGE_ALT_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Image) {
            return ((Image)ficheItem).getAlt();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter IMAGE_TITLE_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Image) {
            return ((Image)ficheItem).getTitle();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter COURRIEL_COMPLETE_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Courriel) {
            return ((Courriel)ficheItem).getEmailCore().toCompleteString();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter COURRIEL_ADDRESS_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Courriel) {
            return ((Courriel)ficheItem).getEmailCore().getAddrSpec();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter COURRIEL_NAME_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Courriel) {
            return ((Courriel)ficheItem).getEmailCore().getRealName();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter NOMBRE_CODE_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Nombre) {
            return ((Nombre)ficheItem).getDecimal().toString();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter MONTANT_CODE_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Montant) {
            return ((Montant)ficheItem).toString();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter MONTANT_CURRENCY_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Montant) {
            return ((Montant)ficheItem).getCurrency().getCurrencyCode();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter MONTANT_DECIMAL_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Montant) {
            return ((Montant)ficheItem).getDecimal().toString();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter MONTANT_MONEYLONG_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Montant) {
            return String.valueOf(((Montant)ficheItem).toMoneyLong());
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATATION_CODE_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Datation) {
            return ((Datation)ficheItem).getDate().toString();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATATION_ISO_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Datation) {
            return ((Datation)ficheItem).getDate().toISOString(false);
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATATION_ISO_LAST_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Datation) {
            return ((Datation)ficheItem).getDate().toISOString(true);
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATATION_YEAR_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Datation) {
            return String.valueOf(((Datation)ficheItem).getDate().getYear());
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATATION_ISOMONTH_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Datation) {
            return ((Datation)ficheItem).getDate().toMonthString(false);
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter DATATION_ISOMONTH_LAST_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Datation) {
            return ((Datation)ficheItem).getDate().toMonthString(true);
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_LOGIN_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            String redacteurGlobalId = ((Personne)ficheItem).getRedacteurGlobalId();
            if (redacteurGlobalId != null) {
                Redacteur redacteur = SphereUtils.getRedacteur(formatSource.getFichotheque(), redacteurGlobalId);
                if (redacteur != null) {
                    return redacteur.getLogin();
                }
                return "";
            }
            return "";
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_SPHERE_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            String redacteurGlobalId = ((Personne)ficheItem).getRedacteurGlobalId();
            if (redacteurGlobalId != null) {
                try {
                    SubsetKey sphereKey = SphereUtils.getSubsetKey(redacteurGlobalId);
                    return sphereKey.getSubsetName();
                }
                catch (ParseException pe) {
                    return "#ERR: wrong redacteurGlobaleId = " + redacteurGlobalId;
                }
            }
            return "";
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_CODE_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            String redacteurGlobalId = ((Personne)ficheItem).getRedacteurGlobalId();
            if (redacteurGlobalId != null) {
                Redacteur redacteur = SphereUtils.getRedacteur(formatSource.getFichotheque(), redacteurGlobalId);
                if (redacteur != null) {
                    return redacteur.getBracketStyle();
                }
                return redacteurGlobalId;
            }
            return ((Personne)ficheItem).getPersonCore().toStandardStyle();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_STANDARD_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            PersonCore personCore = FormatterParserUtils.toPersonCore(ficheItem, formatSource);
            return personCore.toStandardStyle();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_DIRECTORY_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            PersonCore personCore = FormatterParserUtils.toPersonCore(ficheItem, formatSource);
            return personCore.toDirectoryStyle(false);
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_UPDIRECTORY_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            PersonCore personCore = FormatterParserUtils.toPersonCore(ficheItem, formatSource);
            return personCore.toDirectoryStyle(true);
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_BIBLIO_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            PersonCore personCore = FormatterParserUtils.toPersonCore(ficheItem, formatSource);
            return personCore.toBiblioStyle(false);
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_UPBIBLIO_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            PersonCore personCore = FormatterParserUtils.toPersonCore(ficheItem, formatSource);
            return personCore.toBiblioStyle(true);
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_SURNAME_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            return FormatterParserUtils.toPersonCore(ficheItem, formatSource).getSurname();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_UPSURNAME_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            return FormatterParserUtils.toPersonCore(ficheItem, formatSource).getSurname().toUpperCase();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_FORENAME_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            return FormatterParserUtils.toPersonCore(ficheItem, formatSource).getForename();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_NONLATIN_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            return FormatterParserUtils.toPersonCore(ficheItem, formatSource).getNonlatin();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_SURNAMEFIRST_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            PersonCore personCore = FormatterParserUtils.toPersonCore(ficheItem, formatSource);
            return personCore.isSurnameFirst() ? "1" : "0";
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter PERSONNE_ORGANISM_PART = (ficheItem, formatSource) -> {
        if (ficheItem instanceof Personne) {
            return ((Personne)ficheItem).getOrganism();
        }
        return FicheItemFormatterParts.getDefaultFormat(ficheItem);
    };
    public static final FicheItemFormatter FORMSYNTAX_FORMATTER = new FormSyntaxPart();

    private FicheItemFormatterParts() {
    }

    public static FicheItemFormatter newLinkHrefPart(String base) {
        if (base == null) {
            return LINK_HREF_PART;
        }
        return new LinkHrefPart(base);
    }

    public static FicheItemFormatter newImageSrcPart(String base) {
        if (base == null) {
            return IMAGE_SRC_PART;
        }
        return new ImageSrcPart(base);
    }

    public static FicheItemFormatter newPaysLabelPart(LangParameters langParameters) {
        return new PaysLabelPart(langParameters);
    }

    public static FicheItemFormatter newLangueLabelPart(LangParameters langParameters) {
        return new LangueLabelPart(langParameters);
    }

    public static FicheItemFormatter newGeoLatLabelPart(LangParameters langParameters) {
        return new GeoLatLabelPart(langParameters);
    }

    public static FicheItemFormatter newGeoLonLabelPart(LangParameters langParameters) {
        return new GeoLonLabelPart(langParameters);
    }

    public static FicheItemFormatter newNombreLabelPart(LangParameters langParameters) {
        return new NombreLabelPart(langParameters);
    }

    public static FicheItemFormatter newMontantLabelPart(LangParameters langParameters) {
        return new MontantLabelPart(langParameters);
    }

    public static FicheItemFormatter newDatationLabelPart(LangParameters langParameters, short truncateType) {
        return new DatationLabelPart(langParameters, truncateType);
    }

    public static FicheItemFormatter newJsonPart(JsonParameters jsonParameters, LangParameters langParameters) {
        return new JsonPart(jsonParameters, langParameters.getCustomLangContext());
    }

    public static FicheItemFormatter newParaTransformationPart(FicheBlockFormatter ficheBlockFormatter) {
        return new ParaTransformationPart(ficheBlockFormatter);
    }

    public static FicheItemFormatter newDatationPatternPart(DateTimeFormatter dateTimeFormatter) {
        return new DatationPatternPart(dateTimeFormatter);
    }

    private static String getDefaultFormat(FicheItem ficheItem) {
        if (ficheItem instanceof Item) {
            return ((Item)ficheItem).getValue();
        }
        return "#ERROR: wrong ficheItem = " + ficheItem.getClass().getName();
    }

    private static class LinkHrefPart
    implements FicheItemFormatter {
        private final String base;

        private LinkHrefPart(String base) {
            this.base = base;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (ficheItem instanceof Link) {
                String href = ((Link)ficheItem).getHref();
                if (!StringUtils.isAbsoluteUrlString(href)) {
                    href = this.base + href;
                }
                return href;
            }
            return FicheItemFormatterParts.getDefaultFormat(ficheItem);
        }
    }

    private static class ImageSrcPart
    implements FicheItemFormatter {
        private final String base;

        private ImageSrcPart(String base) {
            this.base = base;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (ficheItem instanceof Image) {
                String src = ((Image)ficheItem).getSrc();
                if (!StringUtils.isAbsoluteUrlString(src)) {
                    src = this.base + src;
                }
                return src;
            }
            return FicheItemFormatterParts.getDefaultFormat(ficheItem);
        }
    }

    private static class PaysLabelPart
    implements FicheItemFormatter {
        private final LangParameters langParameters;

        private PaysLabelPart(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            Lang[] langArray;
            if (!(ficheItem instanceof Pays)) {
                return FicheItemFormatterParts.getDefaultFormat(ficheItem);
            }
            Pays pays = (Pays)ficheItem;
            String countryCode = pays.getCountry().toString();
            StringBuilder buf = new StringBuilder();
            for (Lang lang : langArray = LangParameters.checkLangArray(this.langParameters, formatSource)) {
                MessageLocalisation messageLocalisation = formatSource.getMessageLocalisation(lang);
                String message = messageLocalisation.toString(countryCode);
                if (message == null) continue;
                message = StringUtils.getFirstPart(message);
                if (buf.length() > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                buf.append(message);
            }
            return buf.toString();
        }
    }

    private static class LangueLabelPart
    implements FicheItemFormatter {
        private final LangParameters langParameters;

        private LangueLabelPart(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            Lang[] langArray;
            if (!(ficheItem instanceof Langue)) {
                return FicheItemFormatterParts.getDefaultFormat(ficheItem);
            }
            Langue langue = (Langue)ficheItem;
            String langCode = langue.getLang().toString();
            StringBuilder buf = new StringBuilder();
            for (Lang lang : langArray = LangParameters.checkLangArray(this.langParameters, formatSource)) {
                MessageLocalisation messageLocalisation = formatSource.getMessageLocalisation(lang);
                String message = messageLocalisation.toString(langCode);
                if (message == null) continue;
                message = StringUtils.getFirstPart(message);
                if (buf.length() > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                buf.append(message);
            }
            return buf.toString();
        }
    }

    private static class GeoLatLabelPart
    implements FicheItemFormatter {
        private final LangParameters langParameters;

        private GeoLatLabelPart(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            Lang[] langArray;
            if (!(ficheItem instanceof Geopoint)) {
                return FicheItemFormatterParts.getDefaultFormat(ficheItem);
            }
            StringBuilder buf = new StringBuilder();
            DegreSexagesimal sexa = DegreSexagesimal.fromDegreDecimal(((Geopoint)ficheItem).getLatitude());
            for (Lang lang : langArray = LangParameters.checkLangArray(this.langParameters, formatSource)) {
                if (buf.length() > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                MessageLocalisation messageLocalisation = formatSource.getMessageLocalisation(lang);
                String code = SpecialCodes.getLatitudeSpecialCode(sexa);
                buf.append(sexa.toString(false, " "));
                String message = messageLocalisation.toString(code);
                if (message != null) {
                    buf.append(message);
                    continue;
                }
                buf.append(code);
            }
            return buf.toString();
        }
    }

    private static class GeoLonLabelPart
    implements FicheItemFormatter {
        private final LangParameters langParameters;

        private GeoLonLabelPart(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            Lang[] langArray;
            if (!(ficheItem instanceof Geopoint)) {
                return FicheItemFormatterParts.getDefaultFormat(ficheItem);
            }
            StringBuilder buf = new StringBuilder();
            DegreSexagesimal sexa = DegreSexagesimal.fromDegreDecimal(((Geopoint)ficheItem).getLongitude());
            for (Lang lang : langArray = LangParameters.checkLangArray(this.langParameters, formatSource)) {
                if (buf.length() > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                MessageLocalisation messageLocalisation = formatSource.getMessageLocalisation(lang);
                String code = SpecialCodes.getLongitudeSpecialCode(sexa);
                buf.append(sexa.toString(false, " "));
                String message = messageLocalisation.toString(code);
                if (message != null) {
                    buf.append(message);
                    continue;
                }
                buf.append(code);
            }
            return buf.toString();
        }
    }

    private static class NombreLabelPart
    implements FicheItemFormatter {
        private final LangParameters langParameters;

        private NombreLabelPart(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (!(ficheItem instanceof Nombre)) {
                return FicheItemFormatterParts.getDefaultFormat(ficheItem);
            }
            Decimal decimal = ((Nombre)ficheItem).getDecimal();
            StringBuilder buf = new StringBuilder();
            Locale[] array = LangParameters.checkLocaleArray(this.langParameters, formatSource);
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                this.appendLocale(buf, decimal, array[i]);
            }
            return buf.toString();
        }

        private void appendLocale(StringBuilder buf, Decimal decimal, Locale locale) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            buf.append(decimal.toString(symbols));
        }
    }

    private static class MontantLabelPart
    implements FicheItemFormatter {
        private final LangParameters langParameters;

        private MontantLabelPart(LangParameters langParameters) {
            this.langParameters = langParameters;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (!(ficheItem instanceof Montant)) {
                return FicheItemFormatterParts.getDefaultFormat(ficheItem);
            }
            StringBuilder buf = new StringBuilder();
            Montant montant = (Montant)ficheItem;
            Decimal decimal = montant.getDecimal();
            ExtendedCurrency currency = montant.getCurrency();
            Locale[] array = LangParameters.checkLocaleArray(this.langParameters, formatSource);
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                this.appendLocale(buf, decimal, currency, array[i]);
            }
            return buf.toString();
        }

        private void appendLocale(StringBuilder buf, Decimal decimal, ExtendedCurrency currency, Locale locale) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            buf.append(MoneyUtils.toLitteralString(decimal, currency, symbols));
        }
    }

    private static class DatationLabelPart
    implements FicheItemFormatter {
        private final LangParameters langParameters;
        private final short truncateType;

        private DatationLabelPart(LangParameters langParameters, short truncateType) {
            this.langParameters = langParameters;
            this.truncateType = truncateType;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (!(ficheItem instanceof Datation)) {
                return FicheItemFormatterParts.getDefaultFormat(ficheItem);
            }
            Datation datation = (Datation)ficheItem;
            StringBuilder buf = new StringBuilder();
            FuzzyDate date = datation.getDate();
            if (this.truncateType != 5) {
                date = date.truncate(this.truncateType);
            }
            Locale[] array = LangParameters.checkLocaleArray(this.langParameters, formatSource);
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(this.langParameters.getSeparator());
                }
                this.appendLocale(buf, date, array[i]);
            }
            return buf.toString();
        }

        private void appendLocale(StringBuilder buf, FuzzyDate date, Locale locale) {
            DateFormatBundle dateFormatBundle = DateFormatBundle.getDateFormatBundle(locale);
            buf.append(date.getDateLitteral(dateFormatBundle));
        }
    }

    public static class JsonPart
    implements FicheItemFormatter {
        private final JsonParameters jsonParameters;
        private final LangContext customLangContext;

        private JsonPart(JsonParameters jsonParameters, LangContext customLangContext) {
            this.jsonParameters = jsonParameters;
            this.customLangContext = customLangContext;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            JSONWriter jsonWriter = new JSONWriter(buf);
            try {
                LangContext langContext = this.customLangContext != null ? this.customLangContext : formatSource.getLangContext();
                FicheItemJson.object(jsonWriter, ficheItem, this.jsonParameters, langContext, formatSource.getFichotheque(), formatSource.getFormatContext().getMessageLocalisationProvider());
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            return buf.toString();
        }
    }

    private static class ParaTransformationPart
    implements FicheItemFormatter {
        private final FicheBlockFormatter ficheBlockFormatter;

        private ParaTransformationPart(FicheBlockFormatter ficheBlockFormatter) {
            this.ficheBlockFormatter = ficheBlockFormatter;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (ficheItem instanceof Para) {
                SubsetKey corpusKey = null;
                Subset currentSubset = formatSource.getSubsetItemPointeur().getSubset();
                if (currentSubset instanceof Corpus) {
                    corpusKey = currentSubset.getSubsetKey();
                }
                return this.ficheBlockFormatter.formatFicheBlocks(((Para)ficheItem).toFicheBlocks(), formatSource, corpusKey);
            }
            return FicheItemFormatterParts.getDefaultFormat(ficheItem);
        }
    }

    private static class DatationPatternPart
    implements FicheItemFormatter {
        private final DateTimeFormatter dateTimeFormatter;

        private DatationPatternPart(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            if (!(ficheItem instanceof Datation)) {
                return FicheItemFormatterParts.getDefaultFormat(ficheItem);
            }
            Datation datation = (Datation)ficheItem;
            return datation.toLocalDate(false).format(this.dateTimeFormatter);
        }
    }

    private static class FormSyntaxPart
    implements FicheItemFormatter {
        private FormSyntaxPart() {
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            return FormSyntax.toString(ficheItem, formatSource.getFichotheque(), null);
        }
    }
}

