/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import java.io.IOException;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.ExtractionFormatter;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.syntax.FicheblockSyntax;
import net.fichotheque.tools.format.formatters.FicheBlockFormat;
import net.fichotheque.tools.format.formatters.ValuesParameters;
import net.fichotheque.tools.format.patterndefs.DefaultPattern;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class FicheBlockFormatterParser {
    private static final FicheblockSyntax.Parameters DEFAULT_PARAMETERS = FicheblockSyntax.parameters().withSpecialParseChars(true);
    private static final FicheBlockFormatter FORMSYNTAX_PART = (ficheBlocks, formatSource, defaultCorpusKey) -> FicheblockSyntax.toString(ficheBlocks, DEFAULT_PARAMETERS);
    private static final FicheBlockFormatter TEXT_PART = (ficheBlocks, formatSource, defaultCorpusKey) -> {
        StringBuilder appendable = new StringBuilder();
        try {
            FicheBlockFormat.textFormat((Appendable)appendable, ficheBlocks, "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable.toString();
    };

    private FicheBlockFormatterParser() {
    }

    public static FicheBlockFormatter parse(String pattern, FormatContext formatContext, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPattern.ficheBlock();
        }
        try {
            return FicheBlockFormatterParser.parse(pattern, formatContext);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static FicheBlockFormatter parse(String pattern, FormatContext formatContext) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext), pattern);
        return new InternalFicheBlockFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final FormatContext formatContext;

        private InternalInstructionResolver(FormatContext formatContext) {
            this.formatContext = formatContext;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.formatContext.getInstructionResolverProvider().getInstructionResolver(ExtractionFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "formsyntax": {
                    return FORMSYNTAX_PART;
                }
                case "text": {
                    return TEXT_PART;
                }
                case "values": {
                    return new ValuesPart(ValuesParameters.fromInstruction(instruction));
                }
                case "xml": {
                    return this.formatContext.getFicheBlockFormatter("special:xml", instruction.toOptionMap(1));
                }
                case "transformation": 
                case "xslt": {
                    String name = arg1.getValue();
                    FicheBlockFormatter ficheBlockFormatter = this.formatContext.getFicheBlockFormatter(name, instruction.toOptionMap(1));
                    if (ficheBlockFormatter == null) {
                        throw new ErrorMessageException("_ error.unknown.template", name);
                    }
                    return ficheBlockFormatter;
                }
            }
            return null;
        }
    }

    private static class InternalFicheBlockFormatter
    implements FicheBlockFormatter {
        private final Object[] partArray;

        private InternalFicheBlockFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatFicheBlocks(FicheBlocks ficheBlocks, FormatSource formatSource, SubsetKey defaultCorpusKey) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                FicheBlockFormatter formatter = (FicheBlockFormatter)obj;
                buf.append(formatter.formatFicheBlocks(ficheBlocks, formatSource, defaultCorpusKey));
            }
            return buf.toString();
        }
    }

    private static class ValuesPart
    implements FicheBlockFormatter {
        private final ValuesParameters valuesParameters;

        private ValuesPart(ValuesParameters valuesParameters) {
            this.valuesParameters = valuesParameters;
        }

        @Override
        public String formatFicheBlocks(FicheBlocks ficheBlocks, FormatSource formatSource, SubsetKey defaultCorpusKey) {
            int limit = this.valuesParameters.getLimit();
            int startIndex = this.valuesParameters.getStartIndex();
            String separator = this.valuesParameters.getSeparator();
            List<String> list = FicheBlockFormat.valuesFormat(ficheBlocks);
            int size = list.size();
            if (limit != -1) {
                size = Math.min(size, startIndex + limit);
            }
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            for (int i = startIndex; i < size; ++i) {
                if (first) {
                    first = false;
                } else {
                    buf.append(separator);
                }
                buf.append(list.get(i));
            }
            return buf.toString();
        }
    }
}

