/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.formatters;

import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.ExtractionFormatter;
import net.fichotheque.tools.format.patterndefs.DefaultPattern;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class ExtractionFormatterParser {
    private ExtractionFormatterParser() {
    }

    public static ExtractionFormatter parse(String pattern, FormatContext formatContext, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPattern.extraction();
        }
        try {
            return ExtractionFormatterParser.parse(pattern, formatContext);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static ExtractionFormatter parse(String pattern, FormatContext formatContext) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext), pattern);
        return new InternalExtractionFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final FormatContext formatContext;

        private InternalInstructionResolver(FormatContext formatContext) {
            this.formatContext = formatContext;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.formatContext.getInstructionResolverProvider().getInstructionResolver(ExtractionFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "formsyntax": 
                case "xml": {
                    return this.formatContext.getExtractionFormatter(null, instruction.toOptionMap(1));
                }
                case "transformation": 
                case "xslt": {
                    String name = arg1.getValue();
                    ExtractionFormatter extractionFormatter = this.formatContext.getExtractionFormatter(name, instruction.toOptionMap(1));
                    if (extractionFormatter == null) {
                        throw new ErrorMessageException("_ error.unknown.template", name);
                    }
                    return extractionFormatter;
                }
            }
            return null;
        }
    }

    private static class InternalExtractionFormatter
    implements ExtractionFormatter {
        private final Object[] partArray;

        private InternalExtractionFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatExtraction(FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                ExtractionFormatter formatter = (ExtractionFormatter)obj;
                buf.append(formatter.formatExtraction(formatSource));
            }
            return buf.toString();
        }
    }
}

