/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format;

import java.text.ParseException;
import java.util.List;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.format.FichothequeFormatDef;
import net.fichotheque.format.FormatSourceKey;
import net.fichotheque.tools.format.FichothequeFormatDefBuilder;
import net.mapeadores.util.format.Calcul;
import net.mapeadores.util.format.FormatUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionErrorHandler;
import net.mapeadores.util.instruction.InstructionParser;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.StringUtils;

public class FichothequeFormatDefParser {
    private final MessageHandler messageHandler;
    private FichothequeFormatDefBuilder formatDefBuilder = null;

    public static FichothequeFormatDef parse(String[] formatArray, MessageHandler errorHandler) {
        int length = formatArray.length;
        if (length == 0) {
            throw new IllegalArgumentException("formatArray.length = 0");
        }
        String formatSource = formatArray[0];
        String formatPattern = length > 1 ? formatArray[1] : null;
        String formatInstruction = length > 2 ? formatArray[2] : null;
        return FichothequeFormatDefParser.parse(formatSource, formatPattern, formatInstruction, errorHandler);
    }

    public static FichothequeFormatDef parse(List<String> formatList, MessageHandler errorHandler) {
        int length = formatList.size();
        if (length == 0) {
            throw new IllegalArgumentException("formatArray.length = 0");
        }
        String formatSource = formatList.get(0);
        String formatPattern = length > 1 ? formatList.get(1) : null;
        String formatInstruction = length > 2 ? formatList.get(2) : null;
        return FichothequeFormatDefParser.parse(formatSource, formatPattern, formatInstruction, errorHandler);
    }

    public static FichothequeFormatDef parse(String formatSource, String formatPattern, String formatInstruction, MessageHandler errorHandler) {
        FichothequeFormatDefParser ficheFormatDefParser = new FichothequeFormatDefParser(errorHandler);
        return ficheFormatDefParser.parseFormatDef(formatSource, formatPattern, formatInstruction);
    }

    private FichothequeFormatDefParser(MessageHandler errorHandler) {
        this.messageHandler = errorHandler;
    }

    private FichothequeFormatDef parseFormatDef(String formatSource, String formatPattern, String formatInstruction) {
        boolean done = this.initFormatDef(formatSource);
        if (!done) {
            return null;
        }
        this.initFormatPattern(this.formatDefBuilder, formatPattern);
        Instruction instruction = this.getInstruction(formatInstruction);
        if (instruction != null) {
            for (Argument argument : instruction) {
                this.initArgument(argument);
            }
        }
        return this.formatDefBuilder.toFichothequeFormatDef();
    }

    private void initFormatPattern(FichothequeFormatDefBuilder formatDefBuilder, String formatPattern) {
        if (formatPattern == null) {
            return;
        }
        int idx = formatPattern.indexOf("||");
        if (idx == -1) {
            formatDefBuilder.addFormatPattern(formatPattern);
        } else {
            formatDefBuilder.addFormatPattern(formatPattern.substring(0, idx));
            this.initFormatPattern(formatDefBuilder, formatPattern.substring(idx + 2));
        }
    }

    private void initArgument(Argument arg) {
        boolean done;
        String key = arg.getKey();
        String value = arg.getValue();
        if (value == null) {
            value = "";
        }
        try {
            done = this.initCommonArgument(key, value);
        }
        catch (IllegalArgumentException iae) {
            this.addInstructionError("_ error.wrong.argumentvalue", key, value);
            return;
        }
        if (done) {
            return;
        }
        switch (key) {
            case "noitem": 
            case "onlyitem": 
            case "idsort": {
                this.formatDefBuilder.putBooleanValue(key, true);
                return;
            }
            case "defprop": {
                if (value.isEmpty()) {
                    this.addInstructionError("_ error.empty.argumentvalue", key);
                } else {
                    try {
                        FieldKey propFieldKey = FieldKey.parse(value);
                        try {
                            this.formatDefBuilder.setDefaultProprieteKey(propFieldKey);
                        }
                        catch (IllegalArgumentException iae) {
                            this.addInstructionError("_ error.wrong.argumentvalue", key, value);
                        }
                    }
                    catch (ParseException pe) {
                        this.addInstructionError("_ error.wrong.argumentvalue", key, value);
                    }
                }
                return;
            }
        }
        this.addInstructionWarning("_ error.unknown.argumentkey", key);
    }

    private boolean initCommonArgument(String key, String value) throws NumberFormatException, IllegalArgumentException {
        switch (key) {
            case "fixedempty": 
            case "unique": 
            case "null": 
            case "jsonarray": 
            case "columnsum": {
                this.formatDefBuilder.putBooleanValue(key, true);
                return true;
            }
            case "globalselect": {
                this.formatDefBuilder.putBooleanValue(key, FichothequeFormatDefParser.isTrue(value));
                return true;
            }
            case "defval": 
            case "sep": {
                this.formatDefBuilder.putStringValue(key, value);
                return true;
            }
            case "prefix": 
            case "suffix": 
            case "posttransform": {
                if (this.testValue(key, value)) {
                    this.formatDefBuilder.putStringValue(key, value);
                }
                return true;
            }
            case "maxlength": 
            case "fixedlength": 
            case "limit": {
                if (this.testValue(key, value)) {
                    int intValue = Integer.parseInt(value);
                    this.formatDefBuilder.putIntValue(key, intValue);
                }
                return true;
            }
            case "pos": {
                if (this.testValue(key, value)) {
                    if (value.equals("last")) {
                        this.formatDefBuilder.putIntValue(key, 999999999);
                    } else {
                        int position = Integer.parseInt(value);
                        this.formatDefBuilder.putIntValue(key, position - 1);
                    }
                }
                return true;
            }
        }
        if (key.equals("cast")) {
            if (this.testValue(key, value)) {
                short castType = FormatUtils.castTypeToShort(value);
                this.formatDefBuilder.setCastType(castType);
            }
        } else if (key.equals("fixedchar")) {
            if (this.testValue(key, value) && value.length() > 0) {
                this.formatDefBuilder.setFixedChar(value.charAt(0));
            }
        } else if (key.equals("calc")) {
            if (this.testValue(key, value)) {
                try {
                    Calcul calcul = Calcul.parse(value);
                    this.formatDefBuilder.setCalcul(calcul);
                }
                catch (ParseException pe) {
                    this.addInstructionError("_ error.wrong.argumentvalue", key, value);
                }
            }
        } else if (key.equals("sum")) {
            short sumCastType = value.isEmpty() ? (short)0 : FormatUtils.castTypeToShort(value);
            this.formatDefBuilder.setSum(true, sumCastType);
        } else if (key.equals("formula")) {
            short formulaCastType = value.isEmpty() ? (short)0 : FormatUtils.castTypeToShort(value);
            this.formatDefBuilder.setFormula(true, formulaCastType);
        } else if (key.startsWith("sep") && key.length() > 3) {
            int idx = key.indexOf(95);
            if (idx == -1) {
                try {
                    int pos = Integer.parseInt(key.substring(3));
                    this.formatDefBuilder.setInternalSeparator(pos - 1, value);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            } else {
                try {
                    int pos1 = Integer.parseInt(key.substring(3, idx));
                    int pos2 = Integer.parseInt(key.substring(idx + 1));
                    this.formatDefBuilder.setSourceSeparator(pos1 - 1, pos2 - 1, value);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean testValue(String key, String value) {
        if (value.isEmpty()) {
            this.addInstructionError("_ error.empty.argumentvalue", key);
            return false;
        }
        return true;
    }

    private Instruction getInstruction(String formatInstruction) {
        if (formatInstruction == null) {
            return null;
        }
        if ((formatInstruction = formatInstruction.trim()).length() == 0) {
            return null;
        }
        return InstructionParser.parse(formatInstruction, new InternalInstructionErrorHandler());
    }

    private boolean initFormatDef(String formatSource) {
        if ((formatSource = this.checkFormatSource(formatSource)) == null) {
            return false;
        }
        String[] tokens = StringUtils.getTechnicalTokens(formatSource, true);
        int length = tokens.length;
        if (length == 0) {
            this.addSourceError("_ error.empty.formatsource", new Object[0]);
            return false;
        }
        this.formatDefBuilder = new FichothequeFormatDefBuilder();
        if (length == 1) {
            try {
                FormatSourceKey formatSourceKey = FormatSourceKey.parse(formatSource);
                this.formatDefBuilder.addSource(formatSourceKey);
                return true;
            }
            catch (ParseException pe) {
                this.addSourceError("_ error.wrong.formatsource", formatSource);
                return false;
            }
        }
        boolean withError = false;
        for (int i = 0; i < length; ++i) {
            boolean done;
            try {
                FormatSourceKey formatSourceKey = FormatSourceKey.parse(tokens[i]);
                this.formatDefBuilder.addSource(formatSourceKey);
                done = true;
            }
            catch (ParseException pe) {
                this.addSourceError("_ error.wrong.formatsource", tokens[i]);
                done = false;
            }
            if (done) continue;
            withError = true;
        }
        return !withError;
    }

    private String checkFormatSource(String formatSource) {
        if (formatSource == null) {
            this.addSourceError("_ error.empty.formatsource", new Object[0]);
        } else if ((formatSource = formatSource.trim()).length() == 0) {
            this.addSourceError("_ error.empty.formatsource", new Object[0]);
            formatSource = null;
        }
        return formatSource;
    }

    private void addInstructionError(String messageKey, Object ... messageValues) {
        this.messageHandler.addMessage("severe.format.instruction", LocalisationUtils.toMessage(messageKey, messageValues));
    }

    private void addSourceError(String messageKey, Object ... messageValues) {
        this.messageHandler.addMessage("severe.format.source", LocalisationUtils.toMessage(messageKey, messageValues));
    }

    private void addInstructionWarning(String messageKey, Object ... messageValues) {
        this.messageHandler.addMessage("warning.format.instruction", LocalisationUtils.toMessage(messageKey, messageValues));
    }

    private static boolean isTrue(String value) {
        if (value == null) {
            return true;
        }
        if (value.isEmpty()) {
            return true;
        }
        if (value.equals("0")) {
            return false;
        }
        if ((value = value.toLowerCase()).equals("no")) {
            return false;
        }
        return !value.equals("false");
    }

    private class InternalInstructionErrorHandler
    implements InstructionErrorHandler {
        private InternalInstructionErrorHandler() {
        }

        @Override
        public void invalidAsciiCharacterError(String part, int row, int col) {
            FichothequeFormatDefParser.this.addInstructionError("_ error.wrong.character_notascii", new Object[]{part});
        }

        @Override
        public void invalidEndCharacterError(String part, int row, int col) {
            FichothequeFormatDefParser.this.addInstructionError("_ error.wrong.character_end", new Object[]{part});
        }

        @Override
        public void invalidSeparatorCharacterError(String part, int row, int col) {
            FichothequeFormatDefParser.this.addInstructionError("_ error.wrong.character_separator", new Object[]{part});
        }
    }
}

