/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.syntaxes;

import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.utils.SyntaxUtils;
import net.mapeadores.util.attr.AttributeKey;

public final class AttributeResolver {
    private AttributeResolver() {
    }

    public static String resolve(String value) {
        if (value.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        try {
            AttributeResolver.resolve(buf, value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static void resolve(Appendable appendable, String value) throws IOException {
        String valuePart;
        String keyPart;
        int idx = value.indexOf(61);
        boolean withOperator = false;
        if (idx != -1) {
            withOperator = true;
            keyPart = value.substring(0, idx).trim();
            valuePart = value.substring(idx + 1).trim();
        } else {
            keyPart = value.trim();
            valuePart = "";
        }
        try {
            AttributeKey attributeKey = AttributeKey.parse(keyPart);
            SyntaxUtils.appendSpan(appendable, "cm-atom", attributeKey.getNameSpace());
            SyntaxUtils.appendSpan(appendable, "cm-operator", ":");
            SyntaxUtils.appendSpan(appendable, "cm-def", attributeKey.getLocalKey());
        }
        catch (ParseException pe) {
            SyntaxUtils.appendErrorSpan(appendable, keyPart);
        }
        if (withOperator) {
            SyntaxUtils.appendSpan(appendable, "cm-operator", "=");
        }
        if (valuePart.length() > 0) {
            SyntaxUtils.appendSpan(appendable, "cm-quote", valuePart);
        }
    }
}

