/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.syntaxes;

import java.io.IOException;
import net.fichotheque.utils.SyntaxUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;

public abstract class AbstractStepResolver {
    protected final String text;
    protected final StringBuilder finalBuf = new StringBuilder();
    protected StringBuilder currentBuf = new StringBuilder();
    protected int step;

    public AbstractStepResolver(String text) {
        this.text = text;
    }

    protected void appendSpaceToFinal() {
        this.finalBuf.append(' ');
    }

    protected void appendToFinal(String className, String textPart) {
        try {
            if (className != null) {
                SyntaxUtils.appendSpan(this.finalBuf, className, textPart);
            } else {
                SyntaxUtils.escape(this.finalBuf, textPart);
            }
        }
        catch (IOException ioe) {
            throw new ShouldNotOccurException();
        }
    }

    protected void appendOperator(String textPart) {
        this.appendToFinal("cm-operator", textPart);
    }

    protected void appendPunctuation(String textPart) {
        this.appendToFinal("cm-punctuation", textPart);
    }

    protected void appendBracket(String textPart) {
        this.appendToFinal("cm-bracket", textPart);
    }

    protected void appendToCurrent(char carac) {
        this.currentBuf.append(carac);
    }

    protected void appendToCurrent(String part) {
        this.currentBuf.append(part);
    }

    protected void flush() {
        this.flush(false);
    }

    protected void flush(boolean end) {
        if (this.currentBuf.length() == 0) {
            return;
        }
        String textPart = this.currentBuf.toString();
        this.appendToFinal(this.getStepClassName(textPart, end), textPart);
        this.currentBuf = new StringBuilder();
    }

    protected String end() {
        this.flush(true);
        return this.finalBuf.toString();
    }

    public abstract String getStepClassName(String var1, boolean var2);
}

