/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.corpus;

import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Geopoint;
import net.fichotheque.corpus.fiche.Pays;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.extraction.run.FicheGroup;
import net.fichotheque.extraction.run.FicheItemGroupParams;
import net.fichotheque.tools.extraction.corpus.GroupBuilder;
import net.fichotheque.tools.extraction.corpus.GroupEngine;
import net.fichotheque.tools.extraction.corpus.GroupEngineProvider;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.geoloc.GeolocUtils;
import net.mapeadores.util.localisation.Country;
import net.mapeadores.util.primitives.DegrePoint;

public class PaysEngine
extends GroupEngine {
    private final GroupClause groupClause;
    private final GroupEngineProvider subGroupEngineProvider;
    private FieldKey fieldKey;
    private GroupBuilder emptyGroupBuilder;
    private final SortedMap<Country, GroupBuilder> treeMap = new TreeMap<Country, GroupBuilder>();

    PaysEngine(GroupClause groupClause, GroupEngineProvider subGroupEngineProvider) {
        this.groupClause = groupClause;
        this.subGroupEngineProvider = subGroupEngineProvider;
        FicheItemGroupParams groupParams = (FicheItemGroupParams)groupClause.getGroupParams();
        if (groupParams != null) {
            this.fieldKey = groupParams.getFieldKey();
        }
    }

    @Override
    public void add(FicheMeta ficheMeta, FicheFilter ficheFilter, Croisement croisement) {
        Object obj;
        Country country = null;
        if (this.fieldKey != null && (obj = FicheUtils.getValue(ficheMeta, this.fieldKey)) != null) {
            if (obj instanceof FicheItem) {
                country = this.getCountry((FicheItem)obj);
            } else if (obj instanceof FicheItems) {
                country = this.getCountry((FicheItem)((FicheItems)obj).get(0));
            }
        }
        GroupBuilder groupBuilder = this.getGroupBuilder(country);
        groupBuilder.add(ficheMeta, ficheFilter, croisement);
    }

    private Country getCountry(FicheItem ficheItem) {
        if (ficheItem instanceof Pays) {
            return ((Pays)ficheItem).getCountry();
        }
        return null;
    }

    @Override
    public FicheGroup[] toFicheGroupArray() {
        return PaysEngine.toGroupArray(this.treeMap.values(), this.groupClause, this.emptyGroupBuilder);
    }

    private GroupBuilder getGroupBuilder(Country country) {
        if (country == null) {
            if (this.emptyGroupBuilder == null) {
                this.emptyGroupBuilder = GroupBuilder.newInstance("_", this.groupClause.getTagNameInfo(), this.subGroupEngineProvider);
            }
            return this.emptyGroupBuilder;
        }
        GroupBuilder groupBuilder = (GroupBuilder)this.treeMap.get(country);
        if (groupBuilder == null) {
            FicheItem[] matchingFicheItemArray;
            groupBuilder = GroupBuilder.newInstance(country.toString(), this.groupClause.getTagNameInfo(), this.subGroupEngineProvider);
            this.treeMap.put(country, groupBuilder);
            Pays pays = new Pays(country);
            DegrePoint degrePoint = GeolocUtils.getCountryGeoloc(country.toString());
            if (degrePoint != null) {
                matchingFicheItemArray = new FicheItem[2];
                Geopoint geopoint = new Geopoint(degrePoint.getLatitude(), degrePoint.getLongitude());
                matchingFicheItemArray[1] = geopoint;
            } else {
                matchingFicheItemArray = new FicheItem[]{pays};
            }
            groupBuilder.setMatchingFicheItemArray(matchingFicheItemArray);
        }
        return groupBuilder;
    }
}

