/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.corpus;

import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Langue;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.GroupClause;
import net.fichotheque.extraction.run.FicheGroup;
import net.fichotheque.extraction.run.FicheItemGroupParams;
import net.fichotheque.tools.extraction.corpus.GroupBuilder;
import net.fichotheque.tools.extraction.corpus.GroupEngine;
import net.fichotheque.tools.extraction.corpus.GroupEngineProvider;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.localisation.Lang;

class LangueEngine
extends GroupEngine {
    private final GroupClause groupClause;
    private final GroupEngineProvider subGroupEngineProvider;
    private FieldKey fieldKey;
    private GroupBuilder emptyGroupBuilder;
    private final SortedMap<String, GroupBuilder> treeMap = new TreeMap<String, GroupBuilder>();

    LangueEngine(GroupClause groupClause, GroupEngineProvider subGroupEngineProvider) {
        this.groupClause = groupClause;
        this.subGroupEngineProvider = subGroupEngineProvider;
        FicheItemGroupParams groupParams = (FicheItemGroupParams)groupClause.getGroupParams();
        if (groupParams != null) {
            this.fieldKey = groupParams.getFieldKey();
        }
    }

    @Override
    public void add(FicheMeta ficheMeta, FicheFilter ficheFilter, Croisement croisement) {
        Lang value = null;
        if (this.fieldKey == null) {
            value = ficheMeta.getLang();
        } else {
            Object obj = FicheUtils.getValue(ficheMeta, this.fieldKey);
            if (obj != null) {
                if (obj instanceof FicheItem) {
                    value = this.getValue((FicheItem)obj);
                } else if (obj instanceof FicheItems) {
                    value = this.getValue((FicheItem)((FicheItems)obj).get(0));
                }
            }
        }
        GroupBuilder groupBuilder = this.getGroupBuilder(value);
        groupBuilder.add(ficheMeta, ficheFilter, croisement);
    }

    private Lang getValue(FicheItem ficheItem) {
        if (ficheItem instanceof Langue) {
            return ((Langue)ficheItem).getLang();
        }
        return null;
    }

    @Override
    public FicheGroup[] toFicheGroupArray() {
        return LangueEngine.toGroupArray(this.treeMap.values(), this.groupClause, this.emptyGroupBuilder);
    }

    private GroupBuilder getGroupBuilder(Lang value) {
        if (value == null) {
            if (this.emptyGroupBuilder == null) {
                this.emptyGroupBuilder = GroupBuilder.newInstance("_", this.groupClause.getTagNameInfo(), this.subGroupEngineProvider);
            }
            return this.emptyGroupBuilder;
        }
        String langKey = value.toString();
        GroupBuilder groupBuilder = (GroupBuilder)this.treeMap.get(langKey);
        if (groupBuilder == null) {
            groupBuilder = GroupBuilder.newInstance(langKey, this.groupClause.getTagNameInfo(), this.subGroupEngineProvider);
            this.treeMap.put(langKey, groupBuilder);
            Langue langue = new Langue(value);
            FicheItem[] matchingFicheItemArray = new FicheItem[]{langue};
            groupBuilder.setMatchingFicheItemArray(matchingFicheItemArray);
        }
        return groupBuilder;
    }
}

