/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.corpus;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.extraction.def.FicheFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.run.FicheExtractInfo;
import net.fichotheque.extraction.run.FicheGroup;
import net.fichotheque.tools.extraction.corpus.GroupEngine;
import net.fichotheque.tools.extraction.corpus.GroupEngineProvider;

class GroupBuilder {
    private final GroupEngine subGroupEngine;
    private final String name;
    private final TagNameInfo tagNameInfo;
    private List<FicheExtractInfo> infoList;
    private FicheItem[] matchingFicheItemArray;
    private Map<String, String> attributesMap;

    GroupBuilder(String name, TagNameInfo tagNameInfo, GroupEngine subGroupEngine) {
        this.subGroupEngine = subGroupEngine;
        this.name = name;
        this.tagNameInfo = tagNameInfo;
        if (subGroupEngine == null) {
            this.infoList = new ArrayList<FicheExtractInfo>();
        }
    }

    void add(FicheMeta ficheMeta, FicheFilter ficheFilter, Croisement croisement) {
        if (this.subGroupEngine != null) {
            this.subGroupEngine.add(ficheMeta, ficheFilter, croisement);
        } else {
            InternalFicheExtractInfo info = new InternalFicheExtractInfo(ficheMeta, ficheFilter, croisement, null);
            this.infoList.add(info);
        }
    }

    void add(FicheExtractInfo ficheExtractInfo) {
        if (this.subGroupEngine != null) {
            this.subGroupEngine.add(ficheExtractInfo.getFicheMeta(), ficheExtractInfo.getFicheFilter(), ficheExtractInfo.getCroisement());
        } else {
            this.infoList.add(ficheExtractInfo);
        }
    }

    void setMatchingFicheItemArray(FicheItem[] matchingFicheItemArray) {
        this.matchingFicheItemArray = matchingFicheItemArray;
    }

    void setAttributesMap(Map<String, String> attributesMap) {
        this.attributesMap = attributesMap;
    }

    FicheGroup toFicheGroup() {
        InternalFicheGroup ficheGroup = new InternalFicheGroup(this.name, this.tagNameInfo);
        if (this.subGroupEngine == null) {
            ficheGroup.bottomGroup = true;
            InternalFicheGroup.access$202(ficheGroup, null);
            InternalFicheGroup.access$302(ficheGroup, this.infoList.toArray(new FicheExtractInfo[this.infoList.size()]));
        } else {
            ficheGroup.bottomGroup = false;
            InternalFicheGroup.access$202(ficheGroup, this.subGroupEngine.toFicheGroupArray());
            InternalFicheGroup.access$302(ficheGroup, null);
        }
        InternalFicheGroup.access$402(ficheGroup, this.matchingFicheItemArray);
        ficheGroup.attributesMap = this.attributesMap;
        return ficheGroup;
    }

    static GroupBuilder newInstance(String name, TagNameInfo tagNameInfo, GroupEngineProvider subProvider) {
        GroupEngine subGroupEngine = null;
        if (subProvider != null) {
            subGroupEngine = subProvider.newGroupEngine();
        }
        return new GroupBuilder(name, tagNameInfo, subGroupEngine);
    }

    static FicheExtractInfo toFicheExtractInfo(FicheMeta ficheMeta, FicheFilter ficheFilter, Croisement croisement, Object groupClauseObject) {
        return new InternalFicheExtractInfo(ficheMeta, ficheFilter, croisement, groupClauseObject);
    }

    private static class InternalFicheExtractInfo
    implements FicheExtractInfo {
        private final FicheFilter ficheFilter;
        private final FicheMeta ficheMeta;
        private final Croisement croisement;
        private final Object groupClauseObject;

        public InternalFicheExtractInfo(FicheMeta ficheMeta, FicheFilter ficheFilter, Croisement croisement, Object groupClauseObject) {
            this.ficheFilter = ficheFilter;
            this.ficheMeta = ficheMeta;
            this.croisement = croisement;
            this.groupClauseObject = groupClauseObject;
        }

        @Override
        public FicheFilter getFicheFilter() {
            return this.ficheFilter;
        }

        @Override
        public FicheMeta getFicheMeta() {
            return this.ficheMeta;
        }

        @Override
        public Croisement getCroisement() {
            return this.croisement;
        }

        @Override
        public Object getGroupClauseObject() {
            return this.groupClauseObject;
        }
    }

    private static class InternalFicheGroup
    implements FicheGroup {
        private final String name;
        private final TagNameInfo tagNameInfo;
        private boolean bottomGroup;
        private FicheGroup[] subGroupArray;
        private FicheExtractInfo[] ficheExtractInfoArray;
        private FicheItem[] matchingFicheItemArray;
        private Map<String, String> attributesMap;

        private InternalFicheGroup(String name, TagNameInfo tagNameInfo) {
            this.name = name;
            this.tagNameInfo = tagNameInfo;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.tagNameInfo;
        }

        @Override
        public FicheItem[] getMatchingFicheItemArray() {
            return this.matchingFicheItemArray;
        }

        @Override
        public Map<String, String> getAttributesMap() {
            return this.attributesMap;
        }

        @Override
        public boolean isBottomGroup() {
            return this.bottomGroup;
        }

        @Override
        public FicheGroup[] getSubgroupArray() {
            return this.subGroupArray;
        }

        @Override
        public FicheExtractInfo[] getFicheExtractInfoArray() {
            return this.ficheExtractInfoArray;
        }

        static /* synthetic */ FicheGroup[] access$202(InternalFicheGroup x0, FicheGroup[] x1) {
            x0.subGroupArray = x1;
            return x1;
        }

        static /* synthetic */ FicheExtractInfo[] access$302(InternalFicheGroup x0, FicheExtractInfo[] x1) {
            x0.ficheExtractInfoArray = x1;
            return x1;
        }

        static /* synthetic */ FicheItem[] access$402(InternalFicheGroup x0, FicheItem[] x1) {
            x0.matchingFicheItemArray = x1;
            return x1;
        }
    }
}

