/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.extraction.builders;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.extraction.def.CorpusExtractDef;
import net.fichotheque.extraction.def.MotcleFilter;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.tools.extraction.builders.CorpusExtractDefBuilder;
import net.fichotheque.tools.extraction.builders.TitleClauseBuilder;
import net.fichotheque.utils.ExtractionUtils;
import net.fichotheque.utils.FilterUnits;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;

public class MotcleFilterBuilder {
    private static final CorpusExtractDef DEFAULT_INDEXATION_DEF = CorpusExtractDefBuilder.init(ExtractionXMLUtils.TITRE_FICHEFILTER).setClause("title", TitleClauseBuilder.DEFAULT).toCorpusExtractDef();
    private final short type;
    private final List<FilterUnit> filterUnitList = new ArrayList<FilterUnit>();
    private TagNameInfo tagNameInfo = TagNameInfo.DEFAULT;
    private boolean withIcon = false;
    private boolean withLevel = false;
    private boolean withLabels = false;
    private boolean withFicheStylePhrase = false;
    private MotcleFilter previousFilter = null;
    private MotcleFilter nextFilter = null;
    private boolean parentRecursive = false;
    private MotcleFilter parentFilter = null;
    private boolean childrenRecursive = false;
    private MotcleFilter childrenFilter = null;

    public MotcleFilterBuilder(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public MotcleFilterBuilder add(FilterUnit filterUnit) {
        if (filterUnit == null) {
            throw new NullPointerException("filterUnit is null");
        }
        this.filterUnitList.add(filterUnit);
        return this;
    }

    public MotcleFilterBuilder setTagNameInfo(TagNameInfo tagNameInfo) {
        this.tagNameInfo = tagNameInfo;
        return this;
    }

    public MotcleFilterBuilder setWithIcon(boolean withIcon) {
        this.withIcon = withIcon;
        return this;
    }

    public MotcleFilterBuilder setWithLevel(boolean withLevel) {
        this.withLevel = withLevel;
        return this;
    }

    public MotcleFilterBuilder setWithFicheStylePhrase(boolean withFicheStylePhrase) {
        this.withFicheStylePhrase = withFicheStylePhrase;
        return this;
    }

    public MotcleFilterBuilder setChildrenFilter(MotcleFilter childrenFilter) {
        this.childrenRecursive = false;
        this.childrenFilter = childrenFilter;
        return this;
    }

    public MotcleFilterBuilder setParentFilter(MotcleFilter parentFilter) {
        this.parentRecursive = false;
        this.parentFilter = parentFilter;
        return this;
    }

    public MotcleFilterBuilder setNextFilter(MotcleFilter nextFilter) {
        this.nextFilter = nextFilter;
        return this;
    }

    public MotcleFilterBuilder setWithLabels(boolean withLabels) {
        this.withLabels = withLabels;
        return this;
    }

    public MotcleFilterBuilder setPreviousFilter(MotcleFilter previousFilter) {
        this.previousFilter = previousFilter;
        return this;
    }

    public MotcleFilterBuilder addDefaultCorpusExtractDef() {
        this.add(FilterUnits.corpusExtract(DEFAULT_INDEXATION_DEF, ExtractionUtils.EMPTY_FILTERPARAMETERS));
        return this;
    }

    public MotcleFilterBuilder setRecursive() {
        switch (this.type) {
            case 1: {
                this.setChildrenRecursive();
                break;
            }
            case 2: {
                this.setParentRecursive();
            }
        }
        return this;
    }

    public MotcleFilterBuilder setChildrenRecursive() {
        this.childrenRecursive = true;
        this.childrenFilter = null;
        return this;
    }

    public MotcleFilterBuilder setParentRecursive() {
        this.parentRecursive = true;
        this.parentFilter = null;
        return this;
    }

    public MotcleFilter toMotcleFilter() {
        List<FilterUnit> finalFilterUnitList = ExtractionUtils.toImmutableList(this.filterUnitList);
        return new InternalMotcleFilter(this.type, this.tagNameInfo, this.withIcon, this.withLevel, this.withLabels, this.withFicheStylePhrase, this.previousFilter, this.nextFilter, this.parentRecursive, this.parentFilter, this.childrenRecursive, this.childrenFilter, finalFilterUnitList);
    }

    public static MotcleFilterBuilder init(short type) {
        return new MotcleFilterBuilder(type);
    }

    private static class InternalMotcleFilter
    implements MotcleFilter {
        private final short type;
        private final TagNameInfo tagNameInfo;
        private final boolean withIcon;
        private final boolean withLevel;
        private final boolean withLabels;
        private final boolean withFicheStylePhrase;
        private final MotcleFilter previousFilter;
        private final MotcleFilter nextFilter;
        private final boolean parentRecursive;
        private final MotcleFilter parentFilter;
        private final boolean childrenRecursive;
        private final MotcleFilter childrenFilter;
        private final List<FilterUnit> filterUnitList;

        private InternalMotcleFilter(short type, TagNameInfo tagNameInfo, boolean withIcon, boolean withLevel, boolean withLabels, boolean withFicheStylePhrase, MotcleFilter previousFilter, MotcleFilter nextFilter, boolean parentRecursive, MotcleFilter parentFilter, boolean childrenRecursive, MotcleFilter childrenFilter, List<FilterUnit> filterUnitList) {
            this.type = type;
            this.tagNameInfo = tagNameInfo;
            this.withIcon = withIcon;
            this.withLevel = withLevel;
            this.withLabels = withLabels;
            this.withFicheStylePhrase = withFicheStylePhrase;
            this.previousFilter = previousFilter;
            this.nextFilter = nextFilter;
            this.parentRecursive = parentRecursive;
            this.parentFilter = parentFilter;
            this.childrenRecursive = childrenRecursive;
            this.childrenFilter = childrenFilter;
            this.filterUnitList = filterUnitList;
        }

        @Override
        public short getType() {
            return this.type;
        }

        @Override
        public TagNameInfo getTagNameInfo() {
            return this.tagNameInfo;
        }

        @Override
        public boolean isNoneFiltering() {
            if (this.withLabels) {
                return false;
            }
            if (this.withLevel) {
                return false;
            }
            if (this.withFicheStylePhrase) {
                return false;
            }
            if (this.previousFilter != null) {
                return false;
            }
            if (this.nextFilter != null) {
                return false;
            }
            if (this.parentRecursive || this.parentFilter != null) {
                return false;
            }
            if (this.childrenRecursive || this.childrenFilter != null) {
                return false;
            }
            return this.filterUnitList.isEmpty();
        }

        @Override
        public boolean withIcon() {
            return this.withIcon;
        }

        @Override
        public boolean withLevel() {
            return this.withLevel;
        }

        @Override
        public boolean withLabels() {
            return this.withLabels;
        }

        @Override
        public boolean withFicheStylePhrase() {
            return this.withFicheStylePhrase;
        }

        @Override
        public MotcleFilter getChildrenFilter() {
            if (this.childrenRecursive) {
                return this;
            }
            return this.childrenFilter;
        }

        @Override
        public MotcleFilter getParentFilter() {
            if (this.parentRecursive) {
                return this;
            }
            return this.parentFilter;
        }

        @Override
        public MotcleFilter getNextFilter() {
            return this.nextFilter;
        }

        @Override
        public MotcleFilter getPreviousFilter() {
            return this.previousFilter;
        }

        @Override
        public List<FilterUnit> getFilterUnitList() {
            return this.filterUnitList;
        }
    }
}

