/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.transformation.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.tools.exportation.transformation.TemplateDefBuilder;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class TemplateDefDOMReader {
    private final TemplateDefBuilder templateDefBuilder;
    private final MessageHandler messageHandler;

    public TemplateDefDOMReader(TemplateDefBuilder templateDefBuilder, MessageHandler messageHandler) {
        this.templateDefBuilder = templateDefBuilder;
        this.messageHandler = messageHandler;
    }

    public TemplateDefDOMReader read(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
        return this;
    }

    public static TemplateDefDOMReader init(TemplateDefBuilder templateDefBuilder, MessageHandler messageHandler) {
        return new TemplateDefDOMReader(templateDefBuilder, messageHandler);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "label": {
                    try {
                        LabelUtils.readLabel(element, TemplateDefDOMReader.this.templateDefBuilder);
                    }
                    catch (ParseException ile) {
                        DomMessages.wrongLangAttribute(TemplateDefDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                    }
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement(TemplateDefDOMReader.this.templateDefBuilder.getAttributesBuilder(), element);
                    break;
                }
                default: {
                    DomMessages.unknownTagWarning(TemplateDefDOMReader.this.messageHandler, tagName);
                }
            }
        }
    }
}

