/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table.inclusionresolvers;

import java.security.NoSuchAlgorithmException;
import net.fichotheque.Subset;
import net.fichotheque.exportation.table.Col;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableInclusionDef;
import net.fichotheque.exportation.table.TableInclusionResolver;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.utils.TableDefUtils;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.text.StringUtils;

public class ChecksumInclusionResolver
implements TableInclusionResolver {
    public static final String MD5_NAMESPACE = "md5";
    public static final String SHA1_NAMESPACE = "sha1";
    public static final String SHA2_NAMESPACE = "sha2";
    public static final ChecksumInclusionResolver MD5_INSTANCE = new ChecksumInclusionResolver("md5", "MD5");
    public static final ChecksumInclusionResolver SHA1_INSTANCE = new ChecksumInclusionResolver("sha1", "SHA-1");
    public static final ChecksumInclusionResolver SHA2_INSTANCE = new ChecksumInclusionResolver("sha2", "SHA-256");
    private final String resolverNameSpace;
    private final InternalSourceFormatter sourceFormatter;

    private ChecksumInclusionResolver(String resolverNameSpace, String algorithm) {
        this.resolverNameSpace = resolverNameSpace;
        this.sourceFormatter = new InternalSourceFormatter(algorithm);
    }

    @Override
    public boolean test(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext, int lineNumber, LineMessageHandler lineMessageHandler) {
        String nameSpace = tableInclusionDef.getNameSpace();
        return nameSpace.equals(this.resolverNameSpace);
    }

    @Override
    public Col[] resolve(TableInclusionDef tableInclusionDef, Subset subset, TableExportContext tableExportContext) {
        String nameSpace = tableInclusionDef.getNameSpace();
        if (!nameSpace.equals(this.resolverNameSpace)) {
            return TableExportUtils.EMPTY_COLARRAY;
        }
        String localName = tableInclusionDef.getLocalName();
        if (localName.length() == 0) {
            localName = nameSpace;
        }
        Col[] colArray = new Col[]{TableExportUtils.toCol(TableDefUtils.toColDef(localName, tableInclusionDef.getLabels()), this.sourceFormatter)};
        return colArray;
    }

    private static class InternalSourceFormatter
    implements SourceFormatter {
        private final String algorithm;

        private InternalSourceFormatter(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public String formatSource(FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            boolean next = false;
            for (String previous : formatSource.getHistory().getPreviousFormatList()) {
                if (next) {
                    buf.append(',');
                } else {
                    next = true;
                }
                if (previous == null) continue;
                buf.append('\"');
                int length = previous.length();
                block7: for (int i = 0; i < length; ++i) {
                    char carac = previous.charAt(i);
                    switch (carac) {
                        case '\"': {
                            buf.append("\\\"");
                            continue block7;
                        }
                        case '\\': {
                            buf.append("\\\\");
                            continue block7;
                        }
                        default: {
                            buf.append(carac);
                        }
                    }
                }
                buf.append('\"');
            }
            try {
                return StringUtils.digest(this.algorithm, buf.toString());
            }
            catch (NoSuchAlgorithmException e) {
                return "NoSuchAlgorithmException: " + this.algorithm;
            }
        }
    }
}

