/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.util.ArrayList;
import java.util.List;
import net.fichotheque.exportation.table.CroisementTable;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.utils.TableExportUtils;

public class TableExportBuilder {
    private final List<SubsetTable> subsetTableList = new ArrayList<SubsetTable>();
    private final List<CroisementTable> croisementTableList = new ArrayList<CroisementTable>();
    private TableExportDef tableExportDef;

    public TableExportBuilder setTableExportDef(TableExportDef tableExportDef) {
        this.tableExportDef = tableExportDef;
        return this;
    }

    public TableExportBuilder addSubsetTable(SubsetTable subsetTable) {
        if (subsetTable == null) {
            throw new IllegalArgumentException("subsetTable is null");
        }
        this.subsetTableList.add(subsetTable);
        return this;
    }

    public TableExportBuilder addCroisementTable(CroisementTable croisementTable) {
        if (croisementTable == null) {
            throw new IllegalArgumentException("subsetTable is null");
        }
        this.croisementTableList.add(croisementTable);
        return this;
    }

    public TableExport toTableExport() {
        List<SubsetTable> finalSubsetTableList = TableExportUtils.wrap(this.subsetTableList.toArray(new SubsetTable[this.subsetTableList.size()]));
        List<CroisementTable> finalCroisementTableList = TableExportUtils.wrap(this.croisementTableList.toArray(new CroisementTable[this.croisementTableList.size()]));
        return new InternalTableExport(this.tableExportDef, finalSubsetTableList, finalCroisementTableList);
    }

    public static TableExportBuilder init() {
        return new TableExportBuilder();
    }

    private static class InternalTableExport
    implements TableExport {
        private final TableExportDef tableExportDef;
        private final List<SubsetTable> subsetTableList;
        private final List<CroisementTable> croisementTableList;

        private InternalTableExport(TableExportDef tableExportDef, List<SubsetTable> subsetTableList, List<CroisementTable> croisementTableList) {
            this.tableExportDef = tableExportDef;
            this.subsetTableList = subsetTableList;
            this.croisementTableList = croisementTableList;
        }

        @Override
        public TableExportDef getTableExportDef() {
            return this.tableExportDef;
        }

        @Override
        public List<SubsetTable> getSubsetTableList() {
            return this.subsetTableList;
        }

        @Override
        public List<CroisementTable> getCroisementTableList() {
            return this.croisementTableList;
        }
    }
}

