/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.exportation.table.Col;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.FormatColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableDefItem;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableInclusionDef;
import net.fichotheque.exportation.table.TableInclusionResolver;
import net.fichotheque.exportation.table.TableParameterDef;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.formatters.SourceFormatter;
import net.fichotheque.tools.format.FichothequeFormatDefEngine;
import net.fichotheque.utils.TableDefUtils;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.logging.SimpleMessageHandler;

public class SubsetTableBuilder {
    private final Subset subset;
    private final List<ColDef> colDefList = new ArrayList<ColDef>();
    private final List<Col> colList = new ArrayList<Col>();
    private final Map<String, String> parameterMap = new HashMap<String, String>();

    public SubsetTableBuilder(Subset subset) {
        this.subset = subset;
    }

    public SubsetTableBuilder addCol(ColDef colDef, SourceFormatter formatter) {
        this.colDefList.add(colDef);
        this.colList.add(TableExportUtils.toCol(colDef, formatter));
        return this;
    }

    public SubsetTableBuilder addCol(Col col) {
        this.colDefList.add(col.getColDef());
        this.colList.add(col);
        return this;
    }

    public SubsetTableBuilder addCols(TableInclusionDef tableInclusionDef, TableExportContext tableExportContext) {
        TableInclusionResolver tableInclusionResolver = tableExportContext.getTableInclusionResolverProvider().getTableInclusionResolver(tableInclusionDef.getNameSpace());
        if (tableInclusionResolver != null) {
            Col[] resolvedColArray;
            for (Col col : resolvedColArray = tableInclusionResolver.resolve(tableInclusionDef, this.subset, tableExportContext)) {
                this.addCol(col);
            }
        }
        return this;
    }

    public SubsetTableBuilder addCol(FormatColDef colDef, FormatContext formatContext, boolean ignoreMissingCorpusField, String defaultSeparator) {
        SimpleMessageHandler simpleHandler = new SimpleMessageHandler();
        SourceFormatter formatter = FichothequeFormatDefEngine.compute(this.subset, colDef.getFichothequeFormatDef(), simpleHandler, FichothequeFormatDefEngine.parameters(formatContext).defaultGlobalSelect(true).ignoreMissingCorpusField(ignoreMissingCorpusField).defaultSeparator(defaultSeparator));
        if (formatter != null) {
            this.addCol(colDef, formatter);
        }
        return this;
    }

    public SubsetTableBuilder addParameter(String parameterName, String parameterValue) {
        this.parameterMap.put(parameterName, parameterValue);
        return this;
    }

    public SubsetTableBuilder populate(TableDef tableDef, TableExportContext tableExportContext) {
        return this.populate(tableDef, tableExportContext, false, ";");
    }

    public SubsetTableBuilder populate(TableDef tableDef, TableExportContext tableExportContext, boolean ignoreMissingCorpusField, String defaultSeparator) {
        List<TableDefItem> defItemList = tableDef.getDefItemList();
        for (TableDefItem defItem : defItemList) {
            if (!(defItem instanceof TableParameterDef)) continue;
            TableParameterDef tableParameterDef = (TableParameterDef)defItem;
            this.addParameter(tableParameterDef.getParameterName(), tableParameterDef.getParameterValue());
        }
        for (TableDefItem defItem : defItemList) {
            if (defItem instanceof FormatColDef) {
                this.addCol((FormatColDef)defItem, tableExportContext.getFormatContext(), ignoreMissingCorpusField, defaultSeparator);
                continue;
            }
            if (!(defItem instanceof TableInclusionDef)) continue;
            this.addCols((TableInclusionDef)defItem, tableExportContext);
        }
        return this;
    }

    public SubsetTable toSubsetTable() {
        List<ColDef> finalColDefList = TableDefUtils.wrap(this.colDefList.toArray(new ColDef[this.colDefList.size()]));
        List<Col> finalColList = TableExportUtils.wrap(this.colList.toArray(new Col[this.colList.size()]));
        return new InternalSubsetTable(this.subset, finalColDefList, finalColList, this.parameterMap);
    }

    public static SubsetTableBuilder init(Subset subset) {
        return new SubsetTableBuilder(subset);
    }

    private static class InternalSubsetTable
    implements SubsetTable {
        private final Subset subset;
        private final List<ColDef> colDefList;
        private final List<Col> colList;
        private final Map<String, String> parameterMap;

        private InternalSubsetTable(Subset subset, List<ColDef> colDefList, List<Col> colList, Map<String, String> parameterMap) {
            this.subset = subset;
            this.colDefList = colDefList;
            this.colList = colList;
            this.parameterMap = parameterMap;
        }

        @Override
        public Subset getSubset() {
            return this.subset;
        }

        @Override
        public List<ColDef> getColDefList() {
            return this.colDefList;
        }

        @Override
        public List<Col> getColList() {
            return this.colList;
        }

        @Override
        public String getParameterValue(String parameterName) {
            return this.parameterMap.get(parameterName);
        }
    }
}

