/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.balayage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.exportation.balayage.BalayageContentDescription;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.utils.BalayageUtils;
import net.mapeadores.util.xml.DocumentFragmentHolder;
import net.mapeadores.util.xml.XMLUtils;

public class BalayageDescriptionBuilder {
    private final BalayageDef balayageDef;
    private final SortedMap<String, BalayageContentDescription> mainMap = new TreeMap<String, BalayageContentDescription>();
    private final Map<String, SubdirBuilder> subdirBuilderMap = new HashMap<String, SubdirBuilder>();
    private DocumentFragmentHolder includeCatalog = XMLUtils.EMPTY_DOCUMENTFRAGMENTHOLDER;

    public BalayageDescriptionBuilder(BalayageDef balayageDef) {
        this.balayageDef = balayageDef;
    }

    public BalayageDescriptionBuilder addBalayageContentDescription(BalayageContentDescription balayageContentDescription) {
        String path = balayageContentDescription.getPath();
        this.mainMap.put(path, balayageContentDescription);
        int idx = path.indexOf("/");
        String subdir = idx == -1 ? "" : path.substring(0, idx);
        SubdirBuilder builder = this.subdirBuilderMap.get(subdir);
        if (builder == null) {
            builder = new SubdirBuilder(subdir);
            this.subdirBuilderMap.put(subdir, builder);
        }
        builder.add(balayageContentDescription);
        return this;
    }

    public BalayageDescriptionBuilder setIncludeCatalog(DocumentFragmentHolder includeCatalog) {
        if (includeCatalog == null) {
            includeCatalog = XMLUtils.EMPTY_DOCUMENTFRAGMENTHOLDER;
        }
        this.includeCatalog = includeCatalog;
        return this;
    }

    public BalayageDescription toBalayageDescription() {
        HashMap<String, Subdir> subdirMap = new HashMap<String, Subdir>();
        for (Map.Entry<String, SubdirBuilder> entry : this.subdirBuilderMap.entrySet()) {
            subdirMap.put(entry.getKey(), entry.getValue().toSubdir());
        }
        BalayageContentDescription[] finalArray = this.mainMap.values().toArray(new BalayageContentDescription[this.mainMap.size()]);
        List<BalayageContentDescription> finalList = BalayageUtils.wrap(finalArray);
        String state = "ok";
        for (BalayageContentDescription balayageContentDescription : finalArray) {
            if (balayageContentDescription.getState() == 1) continue;
            state = "contains_errors";
            break;
        }
        return new InternalBalayageDescription(this.balayageDef, finalList, subdirMap, state, this.includeCatalog);
    }

    public static BalayageDescriptionBuilder init(BalayageDef balayageDef) {
        return new BalayageDescriptionBuilder(balayageDef);
    }

    private static class SubdirBuilder {
        private final SortedMap<String, BalayageContentDescription> map = new TreeMap<String, BalayageContentDescription>();
        private final String name;

        private SubdirBuilder(String name) {
            this.name = name;
        }

        private void add(BalayageContentDescription balayageContentDescription) {
            this.map.put(balayageContentDescription.getPath(), balayageContentDescription);
        }

        private Subdir toSubdir() {
            List<BalayageContentDescription> list = BalayageUtils.wrap(this.map.values().toArray(new BalayageContentDescription[this.map.size()]));
            return new Subdir(list);
        }
    }

    private static class Subdir {
        private final List<BalayageContentDescription> list;

        private Subdir(List<BalayageContentDescription> list) {
            this.list = list;
        }

        private List<BalayageContentDescription> getList() {
            return this.list;
        }
    }

    private static class InternalBalayageDescription
    implements BalayageDescription {
        private final BalayageDef balayageDef;
        private final List<BalayageContentDescription> contentDescriptionList;
        private final Map<String, Subdir> subdirMap;
        private final String state;
        private final DocumentFragmentHolder includeCatalog;

        private InternalBalayageDescription(BalayageDef balayageDef, List<BalayageContentDescription> contentDescriptionList, Map<String, Subdir> subdirMap, String state, DocumentFragmentHolder includeCatalog) {
            this.balayageDef = balayageDef;
            this.contentDescriptionList = contentDescriptionList;
            this.subdirMap = subdirMap;
            this.state = state;
            this.includeCatalog = includeCatalog;
        }

        @Override
        public BalayageDef getBalayageDef() {
            return this.balayageDef;
        }

        @Override
        public String getState() {
            return this.state;
        }

        @Override
        public List<BalayageContentDescription> getBalayageContentDescriptionList() {
            return this.contentDescriptionList;
        }

        @Override
        public List<BalayageContentDescription> getBalayageContentDescriptionList(String subdirName) {
            Subdir subdir = this.subdirMap.get(subdirName);
            if (subdir != null) {
                return subdir.getList();
            }
            return BalayageUtils.EMPTY_BALAYAGECONTENTDESCRIPTIONLIST;
        }

        @Override
        public DocumentFragmentHolder getIncludeCatalog() {
            return this.includeCatalog;
        }
    }
}

