/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.balayage;

import java.util.List;
import net.fichotheque.exportation.balayage.BalayageContentDescription;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.MessageByLine;
import net.mapeadores.util.logging.SimpleLineMessageHandler;

public class BalayageContentDescriptionBuilder {
    private final SimpleLineMessageHandler lineMessageHandler = new SimpleLineMessageHandler();
    private final String balayageName;
    private final String path;

    public BalayageContentDescriptionBuilder(String balayageName, String path) {
        this.balayageName = balayageName;
        this.path = path;
    }

    public LineMessageHandler getLineMessageHandler() {
        return this.lineMessageHandler;
    }

    public BalayageContentDescription toBalayageContentDescription() {
        List<MessageByLine> messageByLineList = this.lineMessageHandler.toMessageByLineList();
        short state = messageByLineList.isEmpty() ? (short)1 : 2;
        return new InternalBalayageContentDescription(this.balayageName, this.path, state, messageByLineList);
    }

    public static BalayageContentDescriptionBuilder init(String balayageName, String path) {
        return new BalayageContentDescriptionBuilder(balayageName, path);
    }

    private static class InternalBalayageContentDescription
    implements BalayageContentDescription {
        private final String balayageName;
        private final String path;
        private final short state;
        private final List<MessageByLine> messageByLineList;

        private InternalBalayageContentDescription(String balayageName, String path, short state, List<MessageByLine> messageByLineList) {
            this.balayageName = balayageName;
            this.path = path;
            this.state = state;
            this.messageByLineList = messageByLineList;
        }

        @Override
        public String getBalayageName() {
            return this.balayageName;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public short getState() {
            return this.state;
        }

        @Override
        public List<MessageByLine> getMessageByLineList() {
            return this.messageByLineList;
        }
    }
}

