/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.eligibility;

import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;

public class SatellitePredicate
implements Predicate<SubsetItem> {
    private final Subset subset;
    private final Corpus[] satelliteCorpusArray;
    private final boolean here;

    public SatellitePredicate(Subset subset, Corpus[] satelliteCorpusArray, boolean here) {
        this.subset = subset;
        this.satelliteCorpusArray = satelliteCorpusArray;
        this.here = here;
    }

    @Override
    public boolean test(SubsetItem subsetItem) {
        if (!subsetItem.getSubset().equals(this.subset)) {
            return false;
        }
        int id = subsetItem.getId();
        if (this.here) {
            for (Corpus satelliteCorpus : this.satelliteCorpusArray) {
                if (satelliteCorpus.getFicheMetaById(id) == null) continue;
                return true;
            }
            return false;
        }
        for (Corpus satelliteCorpus : this.satelliteCorpusArray) {
            if (satelliteCorpus.getFicheMetaById(id) == null) continue;
            return false;
        }
        return true;
    }
}

