/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.duplication;

import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.tools.duplication.DuplicationFilter;
import net.fichotheque.utils.EligibilityUtils;
import net.mapeadores.util.attr.Attribute;

public class DuplicationFilterParser {
    private final ExcludePredicate excludePredicate = new ExcludePredicate();
    private final ExcludeSubsetEligibility excludeSubsetEligibility = new ExcludeSubsetEligibility();

    private DuplicationFilterParser() {
    }

    private void parseToken(String token) {
        if (token.endsWith("_*")) {
            String wildToken = token.substring(0, token.length() - 2);
            try {
                short category = SubsetKey.categoryToShort(wildToken);
                this.excludeSubsetEligibility.add(category);
            }
            catch (IllegalArgumentException category) {}
        } else {
            try {
                FieldKey fieldKey = FieldKey.parse(token);
                this.excludePredicate.add(fieldKey);
            }
            catch (ParseException pe1) {
                try {
                    SubsetKey subsetKey = SubsetKey.parse(token);
                    this.excludeSubsetEligibility.add(subsetKey);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    private DuplicationFilter toDuplicationFilter() {
        return new DuplicationFilter(this.excludeSubsetEligibility, this.excludePredicate);
    }

    public static DuplicationFilter parseExclude(String[] tokens) {
        DuplicationFilterParser duplicationFilterParser = new DuplicationFilterParser();
        for (String token : tokens) {
            duplicationFilterParser.parseToken(token);
        }
        return duplicationFilterParser.toDuplicationFilter();
    }

    public static DuplicationFilter parseExclude(Attribute attribute) {
        DuplicationFilterParser duplicationFilterParser = new DuplicationFilterParser();
        for (String value : attribute) {
            duplicationFilterParser.parseToken(value);
        }
        return duplicationFilterParser.toDuplicationFilter();
    }

    private static class ExcludePredicate
    implements Predicate<FieldKey> {
        private final Set<FieldKey> set = new HashSet<FieldKey>();

        private ExcludePredicate() {
        }

        @Override
        public boolean test(FieldKey fieldKey) {
            return !this.set.contains(fieldKey);
        }

        private void add(FieldKey fieldKey) {
            this.set.add(fieldKey);
        }
    }

    private static class ExcludeSubsetEligibility
    implements SubsetEligibility {
        private final Set<Short> categorySet = new HashSet<Short>();
        private final Set<SubsetKey> subsetSet = new HashSet<SubsetKey>();

        private ExcludeSubsetEligibility() {
        }

        @Override
        public boolean accept(SubsetKey subsetKey) {
            if (this.categorySet.contains(subsetKey.getCategory())) {
                return false;
            }
            return !this.subsetSet.contains(subsetKey);
        }

        @Override
        public Predicate<SubsetItem> getPredicate(Subset subset) {
            if (this.accept(subset.getSubsetKey())) {
                return EligibilityUtils.ALL_SUBSETITEM_PREDICATE;
            }
            return EligibilityUtils.NONE_SUBSETITEM_PREDICATE;
        }

        private void add(SubsetKey subsetKey) {
            this.subsetSet.add(subsetKey);
        }

        private void add(short category) {
            this.categorySet.add(category);
        }
    }
}

