/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadataEditor;
import net.fichotheque.tools.dom.AbstractMetadataDOMReader;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class ThesaurusMetadataDOMReader
extends AbstractMetadataDOMReader {
    private final ThesaurusMetadataEditor thesaurusMetadataEditor;

    public ThesaurusMetadataDOMReader(ThesaurusMetadataEditor thesaurusMetadataEditor, MessageHandler messageHandler) {
        super(thesaurusMetadataEditor, messageHandler, "thesaurus");
        this.thesaurusMetadataEditor = thesaurusMetadataEditor;
    }

    public static short getThesaurusType(Element element) {
        String typeString = element.getAttribute("thesaurus-type");
        return ThesaurusUtils.thesaurusTypeToShort(typeString);
    }

    public void fillMetadata(Element element) {
        String langsString;
        if (((ThesaurusMetadata)this.thesaurusMetadataEditor.getMetadata()).getThesaurusType() != 3 && (langsString = element.getAttribute("thesaurus-langs")).length() > 0) {
            Langs langs = LangsUtils.toCleanLangs(langsString);
            if (langs.size() > 0) {
                this.thesaurusMetadataEditor.setAuthorizedLangs(langs);
            } else {
                DomMessages.wrongAttributeValue(this.messageHandler, element.getTagName(), "thesaurus-langs", langsString);
            }
        }
        AttributesBuilder attributesBuilder = new AttributesBuilder();
        LinkedHashSet<Lang> langSet = new LinkedHashSet<Lang>();
        DOMUtils.readChildren(element, new RootConsumer(attributesBuilder, langSet, "/" + element.getTagName()));
        if (!langSet.isEmpty()) {
            this.thesaurusMetadataEditor.setAuthorizedLangs(LangsUtils.fromCollection(langSet));
        }
        this.flush(attributesBuilder);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final AttributesBuilder attributesBuilder;
        private final Set<Lang> langSet;
        private final String parentXpath;

        private RootConsumer(AttributesBuilder attributesBuilder, Set<Lang> langSet, String parentXpath) {
            this.attributesBuilder = attributesBuilder;
            this.langSet = langSet;
            this.parentXpath = parentXpath;
        }

        @Override
        public void accept(Element element) {
            if (ThesaurusMetadataDOMReader.this.readCommonElement(element, this.attributesBuilder, this.parentXpath)) {
                return;
            }
            String tagName = element.getTagName();
            String xpath = this.parentXpath + "/" + tagName;
            if (tagName.equals("langs")) {
                LangsUtils.readLangElements(this.langSet, element, ThesaurusMetadataDOMReader.this.messageHandler, xpath);
            } else {
                DomMessages.unknownTagWarning(ThesaurusMetadataDOMReader.this.messageHandler, xpath);
            }
        }
    }
}

