/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.ExistingFieldKeyException;
import net.fichotheque.corpus.metadata.FieldGeneration;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.FieldOptionException;
import net.fichotheque.tools.corpus.FieldGenerationParser;
import net.fichotheque.tools.dom.AbstractMetadataDOMReader;
import net.fichotheque.tools.dom.FichothequeDOMUtils;
import net.fichotheque.utils.FieldOptionUtils;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.SimpleLineMessageHandler;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class CorpusMetadataDOMReader
extends AbstractMetadataDOMReader {
    private final CorpusMetadataEditor corpusMetadataEditor;

    public CorpusMetadataDOMReader(CorpusMetadataEditor corpusMetadataEditor, MessageHandler messageHandler) {
        super(corpusMetadataEditor, messageHandler, "corpus");
        this.corpusMetadataEditor = corpusMetadataEditor;
    }

    public void fillMetadata(Element element) {
        AttributesBuilder attributesBuilder = new AttributesBuilder();
        RootConsumer rootConsumer = new RootConsumer(attributesBuilder, "/" + element.getTagName());
        DOMUtils.readChildren(element, rootConsumer);
        rootConsumer.flush();
        this.flush(attributesBuilder);
    }

    private FieldKey getFieldKey(short category, Element element) {
        String fieldName = element.getAttribute("name");
        if (fieldName.length() == 0) {
            fieldName = element.getAttribute("type");
        }
        if (fieldName.length() == 0) {
            DomMessages.emptyAttribute(this.messageHandler, element.getTagName(), "name");
            return null;
        }
        try {
            return FieldKey.parse(category, fieldName);
        }
        catch (ParseException e) {
            DomMessages.wrongAttributeValue(this.messageHandler, element.getTagName(), "name", fieldName);
            return null;
        }
    }

    private short getFicheItemType(FieldKey fieldKey, Element element) {
        String ficheItem = element.getAttribute("fiche-item");
        if (ficheItem.length() > 0) {
            try {
                return CorpusField.ficheItemTypeToShort(ficheItem);
            }
            catch (IllegalArgumentException iae) {
                this.addFichothequeError("_ error.wrong.ficheitemtype", ficheItem + " (" + fieldKey.getKeyString() + ")");
                return 1;
            }
        }
        return 1;
    }

    private CorpusField getCorpusField(Element element) {
        FieldKey fieldKey;
        String fieldkey_string = element.getAttribute("field-key");
        if (fieldkey_string.length() == 0) {
            DomMessages.emptyAttribute(this.messageHandler, element.getTagName(), "field-key");
            return null;
        }
        try {
            fieldKey = FieldKey.parse(fieldkey_string);
        }
        catch (ParseException pe) {
            DomMessages.wrongAttributeValue(this.messageHandler, element.getTagName(), "field-key", fieldkey_string);
            return null;
        }
        CorpusField corpusField = ((CorpusMetadata)this.corpusMetadataEditor.getMetadata()).getCorpusField(fieldKey);
        if (corpusField == null) {
            this.addFichothequeError("_ error.unknown.fieldkey", fieldKey);
        }
        return corpusField;
    }

    private void addFichothequeError(String messageKey, Object messageValue) {
        this.messageHandler.addMessage("severe.fichotheque", LocalisationUtils.toMessage(messageKey, messageValue));
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final AttributesBuilder attributesBuilder;
        private final String parentXpath;
        private final StringBuilder fieldGenerationRawBuf = new StringBuilder();
        private Element fieldsElement = null;
        private Element optionsElement = null;
        private Element l10nElement = null;

        private RootConsumer(AttributesBuilder attributesBuilder, String parentXpath) {
            this.attributesBuilder = attributesBuilder;
            this.parentXpath = parentXpath;
        }

        @Override
        public void accept(Element element) {
            if (CorpusMetadataDOMReader.this.readCommonElement(element, this.attributesBuilder, this.parentXpath)) {
                return;
            }
            String tagname = element.getTagName();
            if (this.fieldsElement == null && tagname.equals("fields")) {
                this.fieldsElement = element;
            } else if (tagname.equals("field-generation")) {
                this.fieldGenerationRawBuf.append(XMLUtils.getRawData(element));
            } else if (this.optionsElement == null && tagname.equals("options")) {
                this.optionsElement = element;
            } else if (this.l10nElement == null && tagname.equals("l10n")) {
                this.l10nElement = element;
            } else {
                DomMessages.unknownTagWarning(CorpusMetadataDOMReader.this.messageHandler, tagname);
            }
        }

        private void flush() {
            DOMUtils.readChildren(this.fieldsElement, new FieldsConsumer());
            if (this.optionsElement != null) {
                DOMUtils.readChildren(this.optionsElement, new OptionsConsumer(this.fieldGenerationRawBuf));
            }
            if (this.l10nElement != null) {
                DOMUtils.readChildren(this.l10nElement, new L10nConsumer());
            }
            if (this.fieldGenerationRawBuf.length() > 0) {
                FieldGeneration fieldGeneration = FieldGenerationParser.parse(this.fieldGenerationRawBuf.toString(), new SimpleLineMessageHandler());
                CorpusMetadataDOMReader.this.corpusMetadataEditor.setFieldGeneration(fieldGeneration);
            }
        }
    }

    private class ValueConsumer
    implements Consumer<Element> {
        private final List<String> valueList;

        private ValueConsumer(List<String> valueList) {
            this.valueList = valueList;
        }

        @Override
        public void accept(Element el) {
            String tagname = el.getTagName();
            if (tagname.equals("value")) {
                this.valueList.add(XMLUtils.getData(el));
            } else {
                DomMessages.unknownTagWarning(CorpusMetadataDOMReader.this.messageHandler, tagname);
            }
        }
    }

    private class OptionsConsumer
    implements Consumer<Element> {
        private final StringBuilder fieldGenerationSourceBuf;

        private OptionsConsumer(StringBuilder fieldGenerationSourceBuf) {
            this.fieldGenerationSourceBuf = fieldGenerationSourceBuf;
        }

        @Override
        public void accept(Element element) {
            String tagname = element.getTagName();
            if (tagname.equals("option")) {
                String name = element.getAttribute("name");
                if (name.length() == 0) {
                    DomMessages.emptyAttribute(CorpusMetadataDOMReader.this.messageHandler, "option", "name");
                    return;
                }
                CorpusField corpusField = CorpusMetadataDOMReader.this.getCorpusField(element);
                if (corpusField == null) {
                    return;
                }
                if (!FieldOptionUtils.testFieldOption(name, corpusField)) {
                    CorpusMetadataDOMReader.this.addFichothequeError("_ error.unsupported.fieldoption", name);
                    return;
                }
                if (name.equals("mainPersonne")) {
                    this.initStringOption(corpusField, element, "subfieldDisplay");
                } else if (name.equals("titreGenerationFormat")) {
                    this.initOldFieldGeneration(corpusField, element, this.fieldGenerationSourceBuf);
                } else if (name.equals("currencyArray")) {
                    this.initCurrencies(corpusField, element);
                } else if (name.equals("geolocalisationField")) {
                    this.initGeolocalisationField(corpusField);
                } else if (name.equals("addressFieldArray")) {
                    this.initAddressFieldArray(corpusField, element);
                } else if (name.equals("langArray")) {
                    this.initLangs(corpusField, element);
                } else {
                    this.initStringOption(corpusField, element, name);
                }
            } else {
                DomMessages.unknownTagWarning(CorpusMetadataDOMReader.this.messageHandler, tagname);
            }
        }

        private void initGeolocalisationField(CorpusField corpusField) {
            CorpusMetadataDOMReader.this.corpusMetadataEditor.setGeolocalisationField(corpusField);
        }

        private void initOldFieldGeneration(CorpusField corpusField, Element el, StringBuilder fieldGenerationSourceBuf) {
            List<String> valueList = this.readValueList(el);
            if (valueList == null) {
                return;
            }
            if (fieldGenerationSourceBuf.length() > 0) {
                fieldGenerationSourceBuf.append("\n\n");
            }
            fieldGenerationSourceBuf.append(corpusField.getFieldString());
            fieldGenerationSourceBuf.append('\n');
            int size = valueList.size();
            fieldGenerationSourceBuf.append(valueList.get(0));
            fieldGenerationSourceBuf.append('\n');
            if (size > 1) {
                String value2 = valueList.get(1).trim();
                if (value2.length() == 0) {
                    fieldGenerationSourceBuf.append("-");
                } else {
                    fieldGenerationSourceBuf.append(value2);
                }
                fieldGenerationSourceBuf.append('\n');
                if (size > 2) {
                    fieldGenerationSourceBuf.append(valueList.get(2));
                }
            }
        }

        private void initAddressFieldArray(CorpusField corpusField, Element el) {
            List<String> valueList = this.readValueList(el);
            if (valueList == null) {
                return;
            }
            ArrayList<FieldKey> fieldKeyList = new ArrayList<FieldKey>();
            for (String value : valueList) {
                boolean done;
                try {
                    FieldKey otherFieldKey = FieldKey.parse(value);
                    CorpusField otherCorpusField = ((CorpusMetadata)CorpusMetadataDOMReader.this.corpusMetadataEditor.getMetadata()).getCorpusField(otherFieldKey);
                    if (otherCorpusField != null) {
                        fieldKeyList.add(otherFieldKey);
                        done = true;
                    } else {
                        done = false;
                    }
                }
                catch (ParseException pe) {
                    done = false;
                }
                if (done) continue;
                DomMessages.wrongElementValue(CorpusMetadataDOMReader.this.messageHandler, "value", value);
            }
            try {
                CorpusMetadataDOMReader.this.corpusMetadataEditor.setFieldOption(corpusField, "addressFieldArray", fieldKeyList.toArray(new FieldKey[fieldKeyList.size()]));
            }
            catch (FieldOptionException foe) {
                throw new ImplementationException(foe);
            }
        }

        private void initStringOption(CorpusField corpusField, Element el, String name) {
            if (name.equals("imageSource") || name.equals("albumKey")) {
                return;
            }
            String value = el.getAttribute("value");
            if (value.length() > 0) {
                try {
                    CorpusMetadataDOMReader.this.corpusMetadataEditor.setFieldOption(corpusField, name, value);
                }
                catch (FieldOptionException foe) {
                    DomMessages.wrongAttributeValue(CorpusMetadataDOMReader.this.messageHandler, el.getTagName(), "value", value);
                }
            }
        }

        private void initCurrencies(CorpusField corpusField, Element el) {
            List<String> valueList = this.readValueList(el);
            if (valueList == null) {
                return;
            }
            ArrayList<ExtendedCurrency> currencyList = new ArrayList<ExtendedCurrency>();
            for (String value : valueList) {
                try {
                    currencyList.add(ExtendedCurrency.parse(value));
                }
                catch (ParseException pe) {
                    DomMessages.wrongElementValue(CorpusMetadataDOMReader.this.messageHandler, "value", value);
                }
            }
            if (currencyList.isEmpty()) {
                return;
            }
            try {
                CorpusMetadataDOMReader.this.corpusMetadataEditor.setFieldOption(corpusField, "currencyArray", currencyList.toArray(new ExtendedCurrency[currencyList.size()]));
            }
            catch (FieldOptionException foe) {
                throw new ImplementationException(foe);
            }
        }

        private void initLangs(CorpusField corpusField, Element el) {
            List<String> valueList = this.readValueList(el);
            if (valueList == null) {
                return;
            }
            ArrayList<Lang> langList = new ArrayList<Lang>();
            for (String value : valueList) {
                try {
                    langList.add(Lang.parse(value));
                }
                catch (ParseException pe) {
                    DomMessages.wrongElementValue(CorpusMetadataDOMReader.this.messageHandler, "value", value);
                }
            }
            if (langList.isEmpty()) {
                return;
            }
            try {
                CorpusMetadataDOMReader.this.corpusMetadataEditor.setFieldOption(corpusField, "langArray", langList.toArray(new Lang[langList.size()]));
            }
            catch (FieldOptionException foe) {
                throw new ImplementationException(foe);
            }
        }

        private List<String> readValueList(Element element) {
            ArrayList<String> valueList = new ArrayList<String>();
            DOMUtils.readChildren(element, new ValueConsumer(valueList));
            int size = valueList.size();
            if (size == 0) {
                DomMessages.missingChildTag(CorpusMetadataDOMReader.this.messageHandler, element.getTagName(), "value");
                return null;
            }
            return valueList;
        }
    }

    private class FieldL10nConsumer
    implements Consumer<Element> {
        private final CorpusField corpusField;

        private FieldL10nConsumer(CorpusField corpusField) {
            this.corpusField = corpusField;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("label") || tagName.equals("lib")) {
                try {
                    Label label = LabelUtils.readLabel(element);
                    if (label != null) {
                        CorpusMetadataDOMReader.this.corpusMetadataEditor.putFieldLabel(this.corpusField, label);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    private class L10nConsumer
    implements Consumer<Element> {
        private L10nConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagname = element.getTagName();
            if (tagname.equals("field")) {
                CorpusField corpusField = CorpusMetadataDOMReader.this.getCorpusField(element);
                if (corpusField == null) {
                    return;
                }
                FieldL10nConsumer fieldL10nHandler = new FieldL10nConsumer(corpusField);
                DOMUtils.readChildren(element, fieldL10nHandler);
            } else if (tagname.equals("intitule")) {
                FichothequeDOMUtils.readIntitule(element, CorpusMetadataDOMReader.this.corpusMetadataEditor, CorpusMetadataDOMReader.this.messageHandler, "corpus");
            }
        }
    }

    private class FieldsConsumer
    implements Consumer<Element> {
        private FieldsConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagname = element.getTagName();
            FieldKey fieldKey = null;
            short ficheItemType = 0;
            if (tagname.equals("soustitre")) {
                fieldKey = FieldKey.SOUSTITRE;
            } else if (tagname.equals("texte")) {
                fieldKey = FieldKey.build((short)3, "texte");
            } else if (tagname.equals("section") || tagname.equals("annexe")) {
                fieldKey = CorpusMetadataDOMReader.this.getFieldKey((short)3, element);
            } else if (tagname.equals("propriete")) {
                fieldKey = CorpusMetadataDOMReader.this.getFieldKey((short)1, element);
                if (fieldKey != null) {
                    ficheItemType = CorpusMetadataDOMReader.this.getFicheItemType(fieldKey, element);
                }
            } else if (tagname.equals("information")) {
                fieldKey = CorpusMetadataDOMReader.this.getFieldKey((short)2, element);
                if (fieldKey != null) {
                    ficheItemType = CorpusMetadataDOMReader.this.getFicheItemType(fieldKey, element);
                }
            } else {
                DomMessages.unknownTagWarning(CorpusMetadataDOMReader.this.messageHandler, tagname);
            }
            if (fieldKey != null) {
                try {
                    CorpusMetadataDOMReader.this.corpusMetadataEditor.createCorpusField(fieldKey, ficheItemType);
                }
                catch (ExistingFieldKeyException efke) {
                    CorpusMetadataDOMReader.this.addFichothequeError("_ error.existing.fieldkey", fieldKey.getKeyString());
                }
            }
        }
    }
}

