/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.corpus;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.Information;
import net.fichotheque.corpus.fiche.Propriete;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;

public final class PurgeEngine {
    private final Predicate<FieldKey> fieldPredicate;
    private final boolean soustitrePurge;

    public PurgeEngine(Predicate<FieldKey> fieldPredicate) {
        this.fieldPredicate = fieldPredicate;
        this.soustitrePurge = !fieldPredicate.test(FieldKey.SOUSTITRE);
    }

    public void purge(Fiche fiche) {
        if (this.soustitrePurge) {
            fiche.setSoustitre(null);
        }
        this.purgeProprieteList(fiche);
        this.purgeInformationList(fiche);
        this.purgeSectionList(fiche);
    }

    private void purgeProprieteList(Fiche fiche) {
        ArrayList<FieldKey> purgeList = new ArrayList<FieldKey>();
        for (Propriete propriete : fiche.getProprieteList()) {
            FieldKey fieldKey = propriete.getFieldKey();
            if (this.fieldPredicate.test(fieldKey)) continue;
            purgeList.add(fieldKey);
        }
        if (!purgeList.isEmpty()) {
            for (FieldKey fieldKey : purgeList) {
                fiche.setPropriete(fieldKey, null);
            }
        }
    }

    private void purgeInformationList(Fiche fiche) {
        ArrayList<FieldKey> purgeList = new ArrayList<FieldKey>();
        for (Information information : fiche.getInformationList()) {
            FieldKey fieldKey = information.getFieldKey();
            if (this.fieldPredicate.test(fieldKey)) continue;
            purgeList.add(fieldKey);
        }
        if (!purgeList.isEmpty()) {
            for (FieldKey fieldKey : purgeList) {
                fiche.setInformation(fieldKey, null);
            }
        }
    }

    private void purgeSectionList(Fiche fiche) {
        ArrayList<FieldKey> purgeList = new ArrayList<FieldKey>();
        for (Section section : fiche.getSectionList()) {
            FieldKey fieldKey = section.getFieldKey();
            if (this.fieldPredicate.test(fieldKey)) continue;
            purgeList.add(fieldKey);
        }
        if (!purgeList.isEmpty()) {
            for (FieldKey fieldKey : purgeList) {
                fiche.setSection(fieldKey, null);
            }
        }
    }
}

