/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.conversion.fieldtofield;

import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.conversion.fieldtofield.FicheItemFieldToFicheBlockField;
import net.fichotheque.tools.conversion.fieldtofield.InformationToFicheItemField;
import net.fichotheque.tools.conversion.fieldtofield.ProprieteToFicheItemField;
import net.fichotheque.tools.conversion.fieldtofield.SectionToFicheBlockField;
import net.fichotheque.tools.conversion.fieldtofield.SectionToFicheItemField;
import net.fichotheque.tools.conversion.fieldtofield.SimpleToField;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.logging.MultiMessageHandler;

public abstract class FieldToFieldConverter {
    protected final MultiMessageHandler messageHandler;

    protected FieldToFieldConverter(MultiMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    protected void addWarning(String messageKey, Object messageValue) {
        this.messageHandler.addMessage("warning.conversion", LocalisationUtils.toMessage(messageKey, messageValue));
    }

    public static FieldToFieldConverter getInstance(CorpusField source, CorpusField destination, MultiMessageHandler messageHandler) {
        return FieldToFieldConverter.getInstance(source.getFieldKey(), destination.getFieldKey(), messageHandler);
    }

    public static FieldToFieldConverter getInstance(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        switch (sourceKey.getCategory()) {
            case 1: {
                return FieldToFieldConverter.getProprieteInstance(sourceKey, destinationKey, messageHandler);
            }
            case 2: {
                return FieldToFieldConverter.getInformationInstance(sourceKey, destinationKey, messageHandler);
            }
            case 3: {
                return FieldToFieldConverter.getSectionInstance(sourceKey, destinationKey, messageHandler);
            }
            case 0: {
                switch (sourceKey.getKeyString()) {
                    case "redacteurs": {
                        return FieldToFieldConverter.getInformationInstance(sourceKey, destinationKey, messageHandler);
                    }
                }
                return new SimpleToField(sourceKey, destinationKey, messageHandler);
            }
        }
        throw new SwitchException("Unknown category = " + sourceKey.getCategory());
    }

    public void convert(FicheMeta ficheMeta, Fiche fiche) {
        this.convert(ficheMeta, fiche, false);
    }

    public void convert(FicheMeta ficheMeta, Fiche fiche, boolean removeOldField) {
        String uri = ficheMeta.getGlobalId();
        this.messageHandler.setCurrentSource(uri);
        this.convertContent(fiche, removeOldField);
    }

    abstract void convertContent(Fiche var1, boolean var2);

    private static boolean isFicheItemDestination(FieldKey destinationKey) {
        switch (destinationKey.getCategory()) {
            case 1: 
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        throw new IllegalArgumentException("wrong destination : " + destinationKey.getKeyString());
    }

    private static FieldToFieldConverter getProprieteInstance(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        if (FieldToFieldConverter.isFicheItemDestination(destinationKey)) {
            return new ProprieteToFicheItemField(sourceKey, destinationKey, messageHandler);
        }
        return new FicheItemFieldToFicheBlockField(sourceKey, destinationKey, messageHandler);
    }

    private static FieldToFieldConverter getInformationInstance(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        if (FieldToFieldConverter.isFicheItemDestination(destinationKey)) {
            return new InformationToFicheItemField(sourceKey, destinationKey, messageHandler);
        }
        return new FicheItemFieldToFicheBlockField(sourceKey, destinationKey, messageHandler);
    }

    private static FieldToFieldConverter getSectionInstance(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        if (FieldToFieldConverter.isFicheItemDestination(destinationKey)) {
            return new SectionToFicheItemField(sourceKey, destinationKey, messageHandler);
        }
        return new SectionToFicheBlockField(sourceKey, destinationKey, messageHandler);
    }
}

