/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.conversion.fieldtofield;

import java.util.ArrayList;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Information;
import net.fichotheque.corpus.fiche.Propriete;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.conversion.ConversionUtils;
import net.fichotheque.tools.conversion.fieldtofield.FieldToFieldConverter;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.logging.MultiMessageHandler;

class FicheItemFieldToFicheBlockField
extends FieldToFieldConverter {
    private final FieldKey sourceKey;
    private final FieldKey destinationKey;

    FicheItemFieldToFicheBlockField(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        super(messageHandler);
        this.sourceKey = sourceKey;
        this.destinationKey = destinationKey;
    }

    @Override
    void convertContent(Fiche fiche, boolean removeOldField) {
        FicheBlocks list = this.sourceKey.isPropriete() ? this.getProprieteFicheBlocks(fiche) : this.getInformationFicheBlocks(fiche);
        if (list.isEmpty()) {
            return;
        }
        fiche.appendSection(this.destinationKey, list);
        if (removeOldField) {
            if (this.sourceKey.isPropriete()) {
                fiche.setPropriete(this.sourceKey, null);
            } else {
                fiche.setInformation(this.sourceKey, null);
            }
        }
    }

    private FicheBlocks getProprieteFicheBlocks(Fiche fiche) {
        Propriete propriete = fiche.getPropriete(this.sourceKey);
        if (propriete == null) {
            return FicheUtils.EMPTY_FICHEBLOCKS;
        }
        FicheItem ficheItem = propriete.getFicheItem();
        if (ficheItem == null) {
            return FicheUtils.EMPTY_FICHEBLOCKS;
        }
        return FicheUtils.toFicheBlocks(ConversionUtils.toFicheBlock(ficheItem));
    }

    private FicheBlocks getInformationFicheBlocks(Fiche fiche) {
        Information information = fiche.getInformation(this.sourceKey);
        if (information == null) {
            return FicheUtils.EMPTY_FICHEBLOCKS;
        }
        ArrayList<FicheBlock> list = new ArrayList<FicheBlock>();
        for (FicheItem ficheItem : information) {
            FicheBlock ficheBlock = ConversionUtils.toFicheBlock(ficheItem);
            if (ficheBlock == null) continue;
            list.add(ficheBlock);
        }
        return FicheUtils.toFicheBlocks(list);
    }
}

