/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.alias;

import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.MessageHandler;

public class AliasUtils {
    public static final String SEVERE_ALIAS = "severe.alias";

    private AliasUtils() {
    }

    public static boolean testDatationPropriete(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isPropriete()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "propriete");
            return false;
        }
        if (corpusField.getFicheItemType() != 5) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, (short)5);
            return false;
        }
        return true;
    }

    public static boolean testMontantPropriete(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isPropriete()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "propriete");
            return false;
        }
        if (corpusField.getFicheItemType() != 9) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, (short)9);
            return false;
        }
        return true;
    }

    public static boolean testNombrePropriete(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isPropriete()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "propriete");
            return false;
        }
        if (corpusField.getFicheItemType() != 8) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, (short)8);
            return false;
        }
        return true;
    }

    public static boolean testPersonnePropriete(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isPropriete()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "propriete");
            return false;
        }
        if (corpusField.getFicheItemType() != 2) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, (short)2);
            return false;
        }
        return true;
    }

    public static boolean testItemPropriete(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isPropriete()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "propriete");
            return false;
        }
        if (corpusField.getFicheItemType() != 1) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, (short)1);
            return false;
        }
        return true;
    }

    public static boolean testDatationInformation(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isInformation()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "information");
            return false;
        }
        if (corpusField.getFicheItemType() != 5) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, (short)5);
            return false;
        }
        return true;
    }

    public static boolean testMontantInformation(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isInformation()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "information");
            return false;
        }
        if (corpusField.getFicheItemType() != 9) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, (short)9);
            return false;
        }
        return true;
    }

    public static boolean testLangueInformation(String alias, CorpusField corpusField, MessageHandler messageHandler) {
        if (!corpusField.isInformation()) {
            AliasUtils.wrongFieldCategory(messageHandler, alias, corpusField, "information");
            return false;
        }
        if (corpusField.getFicheItemType() != 3) {
            AliasUtils.wrongFicheItemType(messageHandler, alias, corpusField, (short)3);
            return false;
        }
        return true;
    }

    public static void unknownAlias(MessageHandler messageHandler, String aliasType, String alias) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.unknown.alias", aliasType, alias);
    }

    public static void missingSubset(MessageHandler messageHandler, String alias, SubsetKey subsetKey) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.unknown.alias.subset", alias, subsetKey);
    }

    public static void missingField(MessageHandler messageHandler, String alias, FieldKey fieldKey) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.unknown.alias.field", alias, fieldKey);
    }

    public static void wrongFieldCategory(MessageHandler messageHandler, String alias, CorpusField corpusField, String expectedCategories) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.wrong.alias.fieldcategory", alias, corpusField.getFieldString(), expectedCategories);
    }

    public static void wrongFicheItemType(MessageHandler messageHandler, String alias, CorpusField corpusField, short expectedFicheItemType) {
        messageHandler.addMessage(SEVERE_ALIAS, "_ error.wrong.alias.itemtype", alias, corpusField.getFieldString(), CorpusField.ficheItemTypeToString(expectedFicheItemType));
    }

    public static class ErrorHandler
    implements MessageHandler {
        private final MessageHandler wrappedHandler;
        private boolean withError = false;

        public ErrorHandler(MessageHandler wrappedHandler) {
            this.wrappedHandler = wrappedHandler;
        }

        public boolean isWithError() {
            return this.withError;
        }

        @Override
        public void addMessage(String category, Message message) {
            if (category.equals(AliasUtils.SEVERE_ALIAS)) {
                this.withError = true;
            }
            this.wrappedHandler.addMessage(category, message);
        }
    }
}

