/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.syntax;

import java.io.IOException;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.Courriel;
import net.fichotheque.corpus.fiche.Datation;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Geopoint;
import net.fichotheque.corpus.fiche.Image;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Langue;
import net.fichotheque.corpus.fiche.Link;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.corpus.fiche.Nombre;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.Pays;
import net.fichotheque.corpus.fiche.Personne;
import net.fichotheque.corpus.fiche.TextContent;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.syntax.FicheblockSyntax;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.text.SeparatorOptions;

public final class FormSyntax {
    public static final SeparatorOptions DEFAULT_INLINE_SEPARATOROPTIONS = new SeparatorOptions(';', true, true);
    public static final SeparatorOptions DEFAULT_BLOCK_SEPARATOROPTIONS = new SeparatorOptions('\n', true, false);

    private FormSyntax() {
    }

    public static String toString(FicheItems ficheItems, Fichotheque fichotheque, SeparatorOptions separatorOptions, Parameters parameters) {
        int size = ficheItems.size();
        if (size == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(128);
        for (int k = 0; k < size; ++k) {
            FicheItem ficheItem = (FicheItem)ficheItems.get(k);
            buf.append(FormSyntax.toString(ficheItem, fichotheque, parameters));
            if (k < size - 1) {
                buf.append(separatorOptions.getSeparator());
                if (!separatorOptions.isSpaceInclude()) continue;
                buf.append(' ');
                continue;
            }
            if (!separatorOptions.isLastInclude()) continue;
            buf.append(separatorOptions.getSeparator());
            if (!separatorOptions.isSpaceInclude()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static String toString(FicheItem item, Fichotheque fichotheque, Parameters parameters) {
        if (item instanceof Item) {
            return FormSyntax.toString((Item)item);
        }
        if (item instanceof Personne) {
            return FormSyntax.toString((Personne)item, fichotheque, FormSyntax.getDefaultSphereKey(parameters));
        }
        if (item instanceof Langue) {
            return FormSyntax.toString((Langue)item);
        }
        if (item instanceof Pays) {
            return FormSyntax.toString((Pays)item);
        }
        if (item instanceof Datation) {
            return FormSyntax.toString((Datation)item);
        }
        if (item instanceof Courriel) {
            return FormSyntax.toString((Courriel)item);
        }
        if (item instanceof Link) {
            return FormSyntax.toString((Link)item);
        }
        if (item instanceof Nombre) {
            return FormSyntax.toString((Nombre)item, FormSyntax.getDecimalChar(parameters));
        }
        if (item instanceof Montant) {
            return FormSyntax.toString((Montant)item, FormSyntax.getDecimalChar(parameters));
        }
        if (item instanceof Geopoint) {
            return FormSyntax.toString((Geopoint)item, FormSyntax.getDecimalChar(parameters));
        }
        if (item instanceof Para) {
            return FormSyntax.toString((Para)item);
        }
        if (item instanceof Image) {
            return FormSyntax.toString((Image)item);
        }
        throw new IllegalArgumentException("unknown FicheItem implementation");
    }

    public static String toString(DegreDecimal degreDecimal, Parameters parameters) {
        return degreDecimal.toDecimal().toStringWithBlank(FormSyntax.getDecimalChar(parameters));
    }

    public static String toString(Para para) {
        StringBuilder buf = new StringBuilder();
        try {
            FicheblockSyntax.appendTextContent((Appendable)buf, (TextContent)para, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static String toString(Item item) {
        String value = item.getValue();
        return FormSyntax.escapeString(value);
    }

    public static String escapeString(String s) {
        StringBuilder buf = new StringBuilder(s.length() + 20);
        FormSyntax.escapeString(buf, s);
        return buf.toString();
    }

    private static void escapeString(StringBuilder buf, String s) {
        try {
            FormSyntax.escapeString((Appendable)buf, s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void escapeString(Appendable buf, String s) throws IOException {
        int length = s.length();
        block3: for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            switch (carac) {
                case '\u00a0': 
                case '\u202f': {
                    buf.append('~');
                    continue block3;
                }
                default: {
                    buf.append(carac);
                }
            }
        }
    }

    public static String toString(Personne personne, Fichotheque fichotheque, SubsetKey defaultSphereKey) {
        String redacteurGlobalId = personne.getRedacteurGlobalId();
        if (redacteurGlobalId != null) {
            Redacteur redacteur = SphereUtils.getRedacteur(fichotheque, redacteurGlobalId);
            if (redacteur != null) {
                if (defaultSphereKey != null && defaultSphereKey.equals(redacteur.getSubsetKey())) {
                    return redacteur.getLogin();
                }
                return redacteur.getBracketStyle();
            }
            return redacteurGlobalId;
        }
        PersonCore personCore = personne.getPersonCore();
        StringBuilder buf = new StringBuilder(64);
        FormSyntax.escapeString(buf, personCore.getSurname());
        buf.append('*');
        if (personCore.isSurnameFirst()) {
            buf.append('%');
        }
        FormSyntax.escapeString(buf, personCore.getForename());
        String organism = personne.getOrganism();
        if (organism != null) {
            buf.append('*');
            FormSyntax.escapeString(buf, organism);
        }
        return buf.toString();
    }

    public static String toString(Langue langue) {
        return langue.getLang().toString();
    }

    public static String toString(Pays pays) {
        return pays.getCountry().toString();
    }

    public static String toString(Datation datation) {
        return datation.toString();
    }

    public static String toString(Courriel courriel) {
        return courriel.toString();
    }

    public static String toString(Link link) {
        StringBuilder buf = new StringBuilder(128);
        String href = link.getHref();
        buf.append(href);
        String title = link.getTitle();
        if (title.length() == 0) {
            title = null;
        } else if (title.equals(href)) {
            title = null;
        } else if (href.length() > 8 && title.equals(href.substring(7))) {
            title = null;
        } else {
            buf.append('*');
            FormSyntax.escapeString(buf, title);
        }
        String comment = link.getComment();
        if (comment.length() > 0) {
            if (title == null) {
                buf.append('*');
            }
            buf.append('*');
            FormSyntax.escapeString(buf, comment);
        }
        return buf.toString();
    }

    public static String toString(Image image) {
        StringBuilder buf = new StringBuilder(128);
        String src = image.getSrc();
        String alt = image.getAlt();
        String title = image.getTitle();
        buf.append(src);
        if (alt.length() > 0) {
            buf.append('*');
            FormSyntax.escapeString(buf, alt);
        }
        if (title.length() > 0) {
            if (alt.length() == 0) {
                buf.append('*');
            }
            buf.append('*');
            FormSyntax.escapeString(buf, alt);
        }
        return buf.toString();
    }

    public static String toString(Nombre nombre, char decimalChar) {
        String valString = nombre.getDecimal().toStringWithBlank(decimalChar);
        return valString;
    }

    public static String toString(Montant montant, char decimalChar) {
        String valString = montant.getDecimal().toStringWithBlank(decimalChar);
        String cur = montant.getCurrency().getCurrencyCode();
        return valString + cur;
    }

    public static String toString(Geopoint geopoint, char decimalChar) {
        StringBuilder buf = new StringBuilder();
        buf.append(geopoint.getLatitude().toDecimal().toStringWithBlank(decimalChar));
        buf.append("* ");
        buf.append(geopoint.getLongitude().toDecimal().toStringWithBlank(decimalChar));
        return buf.toString();
    }

    public static Parameters parameters() {
        return new Parameters();
    }

    public static Parameters parameters(Parameters others) {
        return new Parameters(others);
    }

    private static char getDecimalChar(Parameters parameters) {
        if (parameters == null) {
            return '.';
        }
        return parameters.decimalChar();
    }

    private static SubsetKey getDefaultSphereKey(Parameters parameters) {
        if (parameters == null) {
            return null;
        }
        return parameters.defautSphereKey();
    }

    public static class Parameters {
        private SubsetKey defautSphereKey = null;
        private char decimalChar = (char)46;

        private Parameters() {
        }

        private Parameters(Parameters other) {
            this.decimalChar = other.decimalChar;
            this.defautSphereKey = other.defautSphereKey;
        }

        public SubsetKey defautSphereKey() {
            return this.defautSphereKey;
        }

        public Parameters defautSphereKey(SubsetKey defautSphereKey) {
            this.defautSphereKey = defautSphereKey;
            return this;
        }

        public char decimalChar() {
            return this.decimalChar;
        }

        public Parameters decimalChar(char decimalChar) {
            this.decimalChar = decimalChar;
            return this;
        }
    }
}

