/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.syntax;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class FicheblockSyntaxHandler
implements Appendable {
    private final StringBuilder buf;
    private final Map<String, Integer> matchingMap = new LinkedHashMap<String, Integer>();
    private int lastLineNumber = 1;
    private int lastLength = 0;

    public FicheblockSyntaxHandler(StringBuilder buf) {
        this.buf = buf;
    }

    public StringBuilder getStringBuilder() {
        return this.buf;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.buf.append(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.buf.append(csq, start, end);
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.buf.append(c);
        return this;
    }

    public Map<String, Integer> getMatchingMap() {
        return this.matchingMap;
    }

    public void storeLine(String positionPrefix, int position) {
        this.storeLine(positionPrefix + position);
    }

    public void storeLine(String position) {
        int currentLength = this.buf.length();
        for (int i = this.lastLength; i < currentLength; ++i) {
            char carac = this.buf.charAt(i);
            if (carac != '\n') continue;
            ++this.lastLineNumber;
        }
        this.matchingMap.put(position, this.lastLineNumber);
        this.lastLength = currentLength;
    }
}

