/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.json;

import java.io.IOException;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Information;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.Propriete;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.syntax.FicheblockSyntax;
import net.fichotheque.syntax.FormSyntax;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.SeparatorOptions;

public final class FicheJson {
    private FicheJson() {
    }

    public static void properties(JSONWriter jsonWriter, Corpus corpus, FicheAPI fiche) throws IOException {
        FicheItems redacteurs;
        Lang lang;
        Fichotheque fichotheque = corpus.getFichotheque();
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        jsonWriter.key("titre");
        jsonWriter.value(fiche.getTitre());
        Para soustitre = fiche.getSoustitre();
        if (soustitre != null) {
            jsonWriter.key("soustitre");
            jsonWriter.value(FormSyntax.toString(soustitre, fichotheque, null));
        }
        if ((lang = fiche.getLang()) != null) {
            jsonWriter.key("lang");
            jsonWriter.value(lang.toString());
        }
        if ((redacteurs = fiche.getRedacteurs()) != null) {
            jsonWriter.key("redacteurs");
            jsonWriter.value(FormSyntax.toString(redacteurs, fichotheque, FormSyntax.DEFAULT_INLINE_SEPARATOROPTIONS, null));
        }
        for (Propriete propriete : fiche.getProprieteList()) {
            jsonWriter.key(propriete.getFieldKey().getKeyString());
            jsonWriter.value(FormSyntax.toString(propriete.getFicheItem(), fichotheque, null));
        }
        for (Information information : fiche.getInformationList()) {
            FieldKey informationFieldKey = information.getFieldKey();
            SeparatorOptions separatorOptions = FormSyntax.DEFAULT_INLINE_SEPARATOROPTIONS;
            CorpusField corpusField = corpusMetadata.getCorpusField(informationFieldKey);
            if (corpusField != null && corpusField.isBlockDisplayInformationField()) {
                separatorOptions = FormSyntax.DEFAULT_BLOCK_SEPARATOROPTIONS;
            }
            jsonWriter.key(informationFieldKey.getKeyString());
            jsonWriter.value(FormSyntax.toString(information, fichotheque, separatorOptions, null));
        }
        FicheblockSyntax.Parameters ficheBlockFormSyntaxParameters = FicheblockSyntax.parameters().withSpecialParseChars(true);
        for (Section section : fiche.getSectionList()) {
            jsonWriter.key(section.getFieldKey().getKeyString());
            jsonWriter.value(FicheblockSyntax.toString(section, ficheBlockFormSyntaxParameters));
        }
    }
}

