/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.include;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.fichotheque.include.IncludeMode;
import net.mapeadores.util.text.StringUtils;

public final class IncludeKey
implements IncludeMode {
    private static final Map<String, IncludeKey> internMap = new HashMap<String, IncludeKey>();
    private final String includeKeyString;
    private final SubsetKey subsetKey;
    private final String mode;
    private final int poidsFilter;

    private IncludeKey(SubsetKey subsetKey, String mode, int poidsFilter) {
        this.subsetKey = subsetKey;
        this.includeKeyString = IncludeKey.toString(subsetKey.getKeyString(), mode, poidsFilter);
        this.mode = mode;
        this.poidsFilter = poidsFilter;
        IncludeKey.intern(this);
    }

    public SubsetKey getSubsetKey() {
        return this.subsetKey;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public int getPoidsFilter() {
        return this.poidsFilter;
    }

    public boolean hasPoidsFilter() {
        return this.poidsFilter != -1;
    }

    public String getKeyString() {
        return this.includeKeyString;
    }

    public String toString() {
        return this.includeKeyString;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        IncludeKey otherKey = (IncludeKey)other;
        return otherKey.includeKeyString.equals(this.includeKeyString);
    }

    public int hashCode() {
        return this.includeKeyString.hashCode();
    }

    public static IncludeKey parse(String key) throws ParseException {
        int poidsFilter;
        String mode;
        SubsetKey subsetKey;
        block21: {
            short category;
            IncludeKey current;
            if (key.equals("association")) {
                key = "addenda_doc";
            }
            if ((current = internMap.get(key)) != null) {
                return current;
            }
            int oldIdx = key.indexOf(58);
            if (oldIdx != -1) {
                return IncludeKey.parse(key.replace(':', '_'));
            }
            String[] tokens = StringUtils.getTokens(key, '_', (short)0);
            int length = tokens.length;
            if (length < 2) {
                throw new ParseException("Missing underscore", 0);
            }
            if (length > 4) {
                throw new ParseException("Too many underscore", 0);
            }
            String token1 = tokens[0];
            String token2 = tokens[1];
            try {
                category = SubsetKey.categoryToShort(token1);
            }
            catch (IllegalArgumentException iae) {
                throw new ParseException("Unknown subset category", 0);
            }
            try {
                subsetKey = SubsetKey.parse(category, token2);
            }
            catch (ParseException pe) {
                throw new ParseException("Wrong subset name", token1.length() + 1);
            }
            mode = "";
            poidsFilter = -1;
            if (length == 3) {
                String token3 = tokens[2];
                try {
                    poidsFilter = Integer.parseInt(token3);
                    if (poidsFilter < 1) {
                        throw new ParseException("Wrong poids filter", token1.length() + token2.length() + 1);
                    }
                    break block21;
                }
                catch (NumberFormatException nfe) {
                    try {
                        StringUtils.checkTechnicalName(token3, false);
                        mode = token3;
                        poidsFilter = -1;
                        break block21;
                    }
                    catch (ParseException pe) {
                        throw new ParseException("Wrong mode", token1.length() + token2.length() + 1);
                    }
                }
            }
            if (length == 4) {
                String token3 = tokens[2];
                String token4 = tokens[3];
                try {
                    StringUtils.checkTechnicalName(token3, false);
                    mode = token3;
                }
                catch (ParseException pe) {
                    throw new ParseException("Wrong mode", token1.length() + token2.length() + 1);
                }
                try {
                    poidsFilter = Integer.parseInt(token4);
                    if (poidsFilter < 1) {
                        throw new ParseException("Wrong poids filter", token1.length() + token2.length() + token3.length() + 1);
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Wrong poids filter", token1.length() + token2.length() + token3.length() + 1);
                }
            }
        }
        return new IncludeKey(subsetKey, mode, poidsFilter);
    }

    public static IncludeKey build(String key) {
        try {
            return IncludeKey.parse(key);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    public static IncludeKey newInstance(SubsetKey subsetKey) {
        return IncludeKey.newInstance(subsetKey, "", -1);
    }

    public static IncludeKey newInstance(SubsetKey subsetKey, String mode, int poidsFilter) {
        String key = IncludeKey.toString(subsetKey.getKeyString(), mode, poidsFilter);
        IncludeKey current = internMap.get(key);
        if (current != null) {
            return current;
        }
        if (poidsFilter == 0 || poidsFilter < -1) {
            throw new IllegalArgumentException();
        }
        if (mode.length() > 0) {
            try {
                StringUtils.checkTechnicalName(mode, false);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Wrong mode: " + mode);
            }
        }
        return new IncludeKey(subsetKey, mode, poidsFilter);
    }

    private static synchronized void intern(IncludeKey includeKey) {
        internMap.put(includeKey.includeKeyString, includeKey);
    }

    private static String toString(String name, String mode, int poidsFilter) {
        if (mode.length() > 0) {
            if (poidsFilter < 1) {
                return name + "_" + mode;
            }
            return name + "_" + mode + "_" + poidsFilter;
        }
        if (poidsFilter < 1) {
            return name;
        }
        return name + "_" + poidsFilter;
    }
}

