/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.include;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.include.IncludeMode;

public final class ExtendedIncludeKey
implements IncludeMode {
    public static final String MASTER_PREFIX = "_master_";
    private static final Map<String, ExtendedIncludeKey> internMap = new HashMap<String, ExtendedIncludeKey>();
    private final String name;
    private final IncludeKey rootIncludeKey;
    private final boolean master;

    private ExtendedIncludeKey(String name, IncludeKey rootIncludeKey, boolean master) {
        this.name = name;
        this.rootIncludeKey = rootIncludeKey;
        this.master = master;
        ExtendedIncludeKey.intern(this);
    }

    public boolean isMaster() {
        return this.master;
    }

    public IncludeKey getRootIncludeKey() {
        return this.rootIncludeKey;
    }

    public SubsetKey getSubsetKey() {
        return this.rootIncludeKey.getSubsetKey();
    }

    public short getCategory() {
        return this.rootIncludeKey.getSubsetKey().getCategory();
    }

    @Override
    public String getMode() {
        return this.rootIncludeKey.getMode();
    }

    @Override
    public int getPoidsFilter() {
        return this.rootIncludeKey.getPoidsFilter();
    }

    public boolean hasPoidsFilter() {
        return this.rootIncludeKey.hasPoidsFilter();
    }

    public String getKeyString() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        ExtendedIncludeKey otherKey = (ExtendedIncludeKey)other;
        return otherKey.name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static ExtendedIncludeKey parse(String name) throws ParseException {
        IncludeKey rootIncludeKey;
        ExtendedIncludeKey current = internMap.get(name);
        if (current != null) {
            return current;
        }
        boolean master = false;
        if (name.startsWith(MASTER_PREFIX)) {
            master = true;
            rootIncludeKey = IncludeKey.parse(name.substring(MASTER_PREFIX.length()));
            name = MASTER_PREFIX + rootIncludeKey;
        } else {
            rootIncludeKey = IncludeKey.parse(name);
            name = rootIncludeKey.getKeyString();
        }
        return new ExtendedIncludeKey(name, rootIncludeKey, master);
    }

    public static ExtendedIncludeKey build(String name) {
        try {
            return ExtendedIncludeKey.parse(name);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static ExtendedIncludeKey newInstance(IncludeKey rootIncludeKey) {
        String name = rootIncludeKey.getKeyString();
        ExtendedIncludeKey current = internMap.get(name);
        if (current != null) {
            return current;
        }
        return new ExtendedIncludeKey(name, rootIncludeKey, false);
    }

    public static ExtendedIncludeKey newInstance(IncludeKey rootIncludeKey, boolean master) {
        String name = master ? MASTER_PREFIX + rootIncludeKey : rootIncludeKey.getKeyString();
        ExtendedIncludeKey current = internMap.get(name);
        if (current != null) {
            return current;
        }
        return new ExtendedIncludeKey(name, rootIncludeKey, master);
    }

    private static synchronized void intern(ExtendedIncludeKey includeKey) {
        internMap.put(includeKey.name, includeKey);
    }
}

