/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.FichothequeEditorProvider;
import net.fichotheque.FichothequeListener;
import net.fichotheque.NoRemoveableSubsetException;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.addenda.AddendaEditor;
import net.fichotheque.album.Album;
import net.fichotheque.album.AlbumEditor;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.CroisementChange;
import net.fichotheque.croisement.CroisementChanges;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.croisement.CroisementKey;
import net.fichotheque.croisement.CroisementRevision;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.impl.AbstractMetadata;
import net.fichotheque.impl.AbstractSubsetItem;
import net.fichotheque.impl.AddendaImpl;
import net.fichotheque.impl.AlbumImpl;
import net.fichotheque.impl.CorpusImpl;
import net.fichotheque.impl.CroisementDataSource;
import net.fichotheque.impl.CroisementImpl;
import net.fichotheque.impl.FichothequeDataSource;
import net.fichotheque.impl.FichothequeMetadataImpl;
import net.fichotheque.impl.Listeners;
import net.fichotheque.impl.SphereImpl;
import net.fichotheque.impl.ThesaurusImpl;
import net.fichotheque.metadata.FichothequeMetadata;
import net.fichotheque.metadata.FichothequeMetadataEditor;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.SphereEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.SphereUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.html.HtmlCleaner;

public class FichothequeImpl
implements Fichotheque {
    private final Map<SubsetKey, Subset> subsetMap = new HashMap<SubsetKey, Subset>();
    private final Map<CroisementKey, CroisementImpl> croisementMap = new HashMap<CroisementKey, CroisementImpl>();
    private final List<SphereImpl> sphereList = new ArrayList<SphereImpl>();
    private final List<CorpusImpl> corpusList = new ArrayList<CorpusImpl>();
    private final List<ThesaurusImpl> thesaurusList = new ArrayList<ThesaurusImpl>();
    private final List<AlbumImpl> albumList = new ArrayList<AlbumImpl>();
    private final List<AddendaImpl> addendaList = new ArrayList<AddendaImpl>();
    private List<Addenda> cacheAddendaList;
    private List<Album> cacheAlbumList;
    private List<Corpus> cacheCorpusList;
    private List<Sphere> cacheSphereList;
    private List<Thesaurus> cacheThesaurusList;
    private FichothequeMetadataImpl fichothequeMetadata;
    private final Listeners listeners = new Listeners();
    private FichothequeDataSource fichothequeDataSource;

    private FichothequeImpl() {
    }

    public static InitEditor init() {
        FichothequeImpl fichotheque = new FichothequeImpl();
        return new InitEditor(fichotheque);
    }

    @Override
    public void addFichothequeListener(FichothequeListener fichothequeListener) {
        this.listeners.addFichothequeListener(fichothequeListener);
    }

    @Override
    public void removeFichothequeListener(FichothequeListener fichothequeListener) {
        this.listeners.removeFichothequeListener(fichothequeListener);
    }

    @Override
    public FichothequeMetadata getFichothequeMetadata() {
        return this.fichothequeMetadata;
    }

    @Override
    public List<Corpus> getCorpusList() {
        List<Corpus> result = this.cacheCorpusList;
        if (result == null) {
            result = this.initCorpusList();
        }
        return result;
    }

    @Override
    public List<Thesaurus> getThesaurusList() {
        List<Thesaurus> result = this.cacheThesaurusList;
        if (result == null) {
            result = this.initThesaurusList();
        }
        return result;
    }

    @Override
    public List<Sphere> getSphereList() {
        List<Sphere> result = this.cacheSphereList;
        if (result == null) {
            result = this.initSphereList();
        }
        return result;
    }

    @Override
    public List<Album> getAlbumList() {
        List<Album> result = this.cacheAlbumList;
        if (result == null) {
            result = this.initAlbumList();
        }
        return result;
    }

    @Override
    public List<Addenda> getAddendaList() {
        List<Addenda> result = this.cacheAddendaList;
        if (result == null) {
            result = this.initAddendaList();
        }
        return result;
    }

    @Override
    public Subset getSubset(SubsetKey subsetKey) {
        return this.subsetMap.get(subsetKey);
    }

    @Override
    public Croisement getCroisement(SubsetItem subsetItem1, SubsetItem subsetItem2) {
        CroisementKey croisementKey = CroisementKey.toCroisementKey(subsetItem1, subsetItem2);
        return this.croisementMap.get(croisementKey);
    }

    @Override
    public Croisements getCroisements(SubsetItem subsetItem, Subset subset) {
        return ((AbstractSubsetItem)subsetItem).getCroisements(subset);
    }

    @Override
    public boolean isRemoveable(Subset subset) {
        if (!subset.getSatelliteCorpusList().isEmpty()) {
            return false;
        }
        return subset.size() == 0;
    }

    @Override
    public boolean isRemoveable(SubsetItem subsetItem) {
        int id = subsetItem.getId();
        for (Corpus corpus : subsetItem.getSubset().getSatelliteCorpusList()) {
            if (corpus.getSubsetItemById(id) == null) continue;
            return false;
        }
        AbstractSubsetItem abstractSubsetItem = (AbstractSubsetItem)subsetItem;
        if (abstractSubsetItem.hasCroisement()) {
            return false;
        }
        if (subsetItem instanceof Motcle) {
            if (!((Motcle)subsetItem).getChildList().isEmpty()) {
                return false;
            }
        } else if (subsetItem instanceof Redacteur) {
            Redacteur redacteur = (Redacteur)subsetItem;
            for (Corpus corpus : this.getCorpusList()) {
                List<CorpusField> personneFieldList;
                boolean test = SphereUtils.testRedacteursAndFields(corpus, redacteur, personneFieldList = CorpusMetadataUtils.getCorpusFieldListByFicheItemType(corpus.getCorpusMetadata(), (short)2, false));
                if (!test) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public CroisementRevision getCroisementRevision(CroisementKey croisementKey, String revisionName) {
        return this.fichothequeDataSource.getCroisementDataSource().getCroisementRevision(croisementKey, revisionName);
    }

    private FichothequeEditor getFichothequeEditor(EditOrigin editOrigin) {
        return new FichothequeEditorImpl(editOrigin);
    }

    Listeners getListeners() {
        return this.listeners;
    }

    FichothequeDataSource getFichothequeDataSource() {
        return this.fichothequeDataSource;
    }

    private void testCorpusCreate(SubsetKey corpusKey, Subset masterSubset) throws ExistingSubsetException {
        if (corpusKey == null) {
            throw new IllegalArgumentException("corpusKey == null");
        }
        if (!corpusKey.isCorpusSubset()) {
            throw new IllegalArgumentException("corpusKey.isCorpusKey() == false");
        }
        if (this.subsetMap.containsKey(corpusKey)) {
            throw new ExistingSubsetException();
        }
        if (masterSubset != null) {
            if (masterSubset instanceof CorpusImpl) {
                if (((CorpusImpl)masterSubset).getMasterSubset() != null) {
                    throw new IllegalArgumentException("masterSubset : " + masterSubset.getSubsetKeyString() + " cannot be a satellite subset");
                }
            } else if (!(masterSubset instanceof ThesaurusImpl)) {
                throw new IllegalArgumentException("bad implementation of masterSubset : " + masterSubset.getClass().getName());
            }
        }
    }

    private void testSphereCreate(SubsetKey sphereKey) throws ExistingSubsetException {
        if (sphereKey == null) {
            throw new IllegalArgumentException("sphereKey == null");
        }
        if (!sphereKey.isSphereSubset()) {
            throw new IllegalArgumentException("sphereKey.isSphereKey() == false");
        }
        if (this.subsetMap.containsKey(sphereKey)) {
            throw new ExistingSubsetException();
        }
    }

    private void testThesaurusCreate(SubsetKey thesaurusKey, short thesaurusType) throws ExistingSubsetException {
        if (!ThesaurusUtils.testThesaurusType(thesaurusType)) {
            throw new IllegalArgumentException("wrong thesaurusType value");
        }
        if (thesaurusKey == null) {
            throw new IllegalArgumentException("thesaurusKey == null");
        }
        if (!thesaurusKey.isThesaurusSubset()) {
            throw new IllegalArgumentException("thesaurusKey.isThesaurusKey() == false");
        }
        if (this.subsetMap.containsKey(thesaurusKey)) {
            throw new ExistingSubsetException();
        }
    }

    private void testAlbumCreate(SubsetKey albumKey) throws ExistingSubsetException {
        if (albumKey == null) {
            throw new IllegalArgumentException("albumKey == null");
        }
        if (!albumKey.isAlbumSubset()) {
            throw new IllegalArgumentException("albumKey.isAlbumKey() == false");
        }
        if (this.subsetMap.containsKey(albumKey)) {
            throw new ExistingSubsetException();
        }
    }

    private void testAddendaCreate(SubsetKey addendaKey) throws ExistingSubsetException {
        if (addendaKey == null) {
            throw new IllegalArgumentException("addendaKey == null");
        }
        if (!addendaKey.isAddendaSubset()) {
            throw new IllegalArgumentException("addendaKey.isAddendaKey() == false");
        }
        if (this.subsetMap.containsKey(addendaKey)) {
            throw new ExistingSubsetException();
        }
    }

    private synchronized void endCorpusCreation(CorpusImpl corpus, Subset masterSubset) {
        if (masterSubset != null) {
            if (masterSubset instanceof CorpusImpl) {
                CorpusImpl masterCorpus = (CorpusImpl)masterSubset;
                masterCorpus.addSatelliteCorpus(corpus);
            } else {
                ThesaurusImpl masterThesaurus = (ThesaurusImpl)masterSubset;
                masterThesaurus.addSatelliteCorpus(corpus);
            }
        }
        this.subsetMap.put(corpus.getSubsetKey(), corpus);
        this.corpusList.add(corpus);
        this.clearCache();
    }

    private synchronized void endSphereCreation(SphereImpl sphere) {
        this.subsetMap.put(sphere.getSubsetKey(), sphere);
        this.sphereList.add(sphere);
        this.clearCache();
    }

    private synchronized void endThesaurusCreation(ThesaurusImpl thesaurus) {
        this.subsetMap.put(thesaurus.getSubsetKey(), thesaurus);
        this.thesaurusList.add(thesaurus);
        this.clearCache();
    }

    private synchronized void endAlbumCreation(AlbumImpl album) {
        this.subsetMap.put(album.getSubsetKey(), album);
        this.albumList.add(album);
        this.clearCache();
    }

    private synchronized void endAddendaCreation(AddendaImpl addenda) {
        this.subsetMap.put(addenda.getSubsetKey(), addenda);
        this.addendaList.add(addenda);
        this.clearCache();
    }

    private synchronized void innerRemoveSphere(Sphere sphere) throws NoRemoveableSubsetException {
        SphereImpl sphereImpl = this.testSphere(sphere);
        if (!this.isRemoveable(sphere)) {
            throw new NoRemoveableSubsetException();
        }
        SubsetKey sphereKey = sphereImpl.getSubsetKey();
        this.sphereList.remove(sphereImpl);
        this.subsetMap.remove(sphereKey);
        this.clearCache();
    }

    private synchronized void innerRemoveThesaurus(Thesaurus thesaurus) throws NoRemoveableSubsetException {
        ThesaurusImpl thesaurusImpl = this.testThesaurus(thesaurus);
        if (!this.isRemoveable(thesaurus)) {
            throw new NoRemoveableSubsetException();
        }
        SubsetKey thesaurusKey = thesaurusImpl.getSubsetKey();
        this.thesaurusList.remove(thesaurusImpl);
        this.subsetMap.remove(thesaurusKey);
        this.clearCache();
    }

    private synchronized void innerRemoveAlbum(Album album) throws NoRemoveableSubsetException {
        AlbumImpl albumImpl = this.testAlbum(album);
        if (!this.isRemoveable(album)) {
            throw new NoRemoveableSubsetException();
        }
        SubsetKey albumKey = albumImpl.getSubsetKey();
        this.albumList.remove(albumImpl);
        this.subsetMap.remove(albumKey);
        albumImpl.clear();
        this.clearCache();
    }

    private synchronized void innerRemoveAddenda(Addenda addenda) throws NoRemoveableSubsetException {
        AddendaImpl addendaImpl = this.testAddenda(addenda);
        if (!this.isRemoveable(addenda)) {
            throw new NoRemoveableSubsetException();
        }
        SubsetKey addendaKey = addendaImpl.getSubsetKey();
        this.addendaList.remove(addendaImpl);
        this.subsetMap.remove(addendaKey);
        this.clearCache();
    }

    private synchronized void innerRemoveCorpus(Corpus corpus) throws NoRemoveableSubsetException {
        CorpusImpl corpusImpl = this.testCorpus(corpus);
        if (!this.isRemoveable(corpus)) {
            throw new NoRemoveableSubsetException();
        }
        SubsetKey corpusKey = corpusImpl.getSubsetKey();
        Subset masterSubset = corpusImpl.getMasterSubset();
        if (masterSubset != null) {
            if (masterSubset instanceof CorpusImpl) {
                ((CorpusImpl)masterSubset).removeSatelliteCorpus(corpusImpl);
            } else if (masterSubset instanceof ThesaurusImpl) {
                ((ThesaurusImpl)masterSubset).removeSatelliteCorpus(corpusImpl);
            } else {
                throw new SwitchException("masterSubset class = " + masterSubset.getClass().getName());
            }
        }
        this.corpusList.remove(corpusImpl);
        this.subsetMap.remove(corpusKey);
        corpusImpl.clear();
        this.clearCache();
    }

    private boolean innerPutAttribute(Object attributeHolder, Attribute attribute) {
        if (attributeHolder instanceof AbstractMetadata) {
            AbstractMetadata metadata = (AbstractMetadata)attributeHolder;
            return metadata.innerPutAttribute(attribute);
        }
        if (attributeHolder instanceof AbstractSubsetItem) {
            AbstractSubsetItem subsetItem = (AbstractSubsetItem)attributeHolder;
            return subsetItem.innerPutAttribute(attribute);
        }
        if (attributeHolder instanceof CroisementImpl) {
            CroisementImpl croisement = (CroisementImpl)attributeHolder;
            return croisement.innerPutAttribute(attribute);
        }
        return false;
    }

    private boolean innerRemoveAttribute(Object attributeHolder, AttributeKey attributeKey) {
        if (attributeHolder instanceof AbstractMetadata) {
            AbstractMetadata metadata = (AbstractMetadata)attributeHolder;
            return metadata.innerRemoveAttribute(attributeKey);
        }
        if (attributeHolder instanceof AbstractSubsetItem) {
            AbstractSubsetItem subsetItem = (AbstractSubsetItem)attributeHolder;
            return subsetItem.innerRemoveAttribute(attributeKey);
        }
        if (attributeHolder instanceof CroisementImpl) {
            CroisementImpl croisement = (CroisementImpl)attributeHolder;
            return croisement.innerRemoveAttribute(attributeKey);
        }
        return false;
    }

    private void clearCache() {
        this.cacheAddendaList = null;
        this.cacheAlbumList = null;
        this.cacheCorpusList = null;
        this.cacheSphereList = null;
        this.cacheThesaurusList = null;
    }

    private synchronized List<Addenda> initAddendaList() {
        if (this.cacheAddendaList != null) {
            return this.cacheAddendaList;
        }
        TreeMap<String, AddendaImpl> sortedMap = new TreeMap<String, AddendaImpl>();
        for (AddendaImpl addenda : this.addendaList) {
            sortedMap.put(addenda.getSubsetName(), addenda);
        }
        List<Addenda> list = FichothequeUtils.wrap(sortedMap.values().toArray(new Addenda[sortedMap.size()]));
        this.cacheAddendaList = list;
        return list;
    }

    private synchronized List<Album> initAlbumList() {
        if (this.cacheAlbumList != null) {
            return this.cacheAlbumList;
        }
        TreeMap<String, AlbumImpl> sortedMap = new TreeMap<String, AlbumImpl>();
        for (AlbumImpl album : this.albumList) {
            sortedMap.put(album.getSubsetName(), album);
        }
        List<Album> list = FichothequeUtils.wrap(sortedMap.values().toArray(new Album[sortedMap.size()]));
        this.cacheAlbumList = list;
        return list;
    }

    private synchronized List<Corpus> initCorpusList() {
        if (this.cacheCorpusList != null) {
            return this.cacheCorpusList;
        }
        TreeMap<String, CorpusImpl> sortedMap = new TreeMap<String, CorpusImpl>();
        for (CorpusImpl corpus : this.corpusList) {
            sortedMap.put(corpus.getSubsetName(), corpus);
        }
        List<Corpus> list = FichothequeUtils.wrap(sortedMap.values().toArray(new Corpus[sortedMap.size()]));
        this.cacheCorpusList = list;
        return list;
    }

    private synchronized List<Sphere> initSphereList() {
        if (this.cacheSphereList != null) {
            return this.cacheSphereList;
        }
        TreeMap<String, SphereImpl> sortedMap = new TreeMap<String, SphereImpl>();
        for (SphereImpl sphere : this.sphereList) {
            sortedMap.put(sphere.getSubsetName(), sphere);
        }
        List<Sphere> list = FichothequeUtils.wrap(sortedMap.values().toArray(new Sphere[sortedMap.size()]));
        this.cacheSphereList = list;
        return list;
    }

    private synchronized List<Thesaurus> initThesaurusList() {
        if (this.cacheThesaurusList != null) {
            return this.cacheThesaurusList;
        }
        TreeMap<String, ThesaurusImpl> sortedMap = new TreeMap<String, ThesaurusImpl>();
        for (ThesaurusImpl thesaurus : this.thesaurusList) {
            sortedMap.put(thesaurus.getSubsetName(), thesaurus);
        }
        List<Thesaurus> list = FichothequeUtils.wrap(sortedMap.values().toArray(new Thesaurus[sortedMap.size()]));
        this.cacheThesaurusList = list;
        return list;
    }

    private SphereImpl testSphere(Sphere sphere) {
        if (sphere == null) {
            throw new IllegalArgumentException("sphere argument cannot be null");
        }
        try {
            SphereImpl sphereImpl = (SphereImpl)sphere;
            if (sphereImpl.getFichotheque() != this) {
                throw new IllegalArgumentException("sphere argument does not come from this Fichotheque instance");
            }
            return sphereImpl;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("sphere argument does not come from this Fichotheque instance");
        }
    }

    private ThesaurusImpl testThesaurus(Thesaurus thesaurus) {
        if (thesaurus == null) {
            throw new IllegalArgumentException("thesaurus argument cannot be null");
        }
        try {
            ThesaurusImpl thesaurusImpl = (ThesaurusImpl)thesaurus;
            if (thesaurusImpl.getFichotheque() != this) {
                throw new IllegalArgumentException("thesaurus argument does not come from this Fichotheque instance");
            }
            return thesaurusImpl;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("thesaurus argument does not come from this Fichotheque instance");
        }
    }

    private CorpusImpl testCorpus(Corpus corpus) {
        if (corpus == null) {
            throw new IllegalArgumentException("corpus argument cannot be null");
        }
        try {
            CorpusImpl corpusImpl = (CorpusImpl)corpus;
            if (corpusImpl.getFichotheque() != this) {
                throw new IllegalArgumentException("corpus argument does not come from this Fichotheque instance");
            }
            return corpusImpl;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("corpus argument does not come from this Fichotheque instance");
        }
    }

    private AlbumImpl testAlbum(Album album) {
        if (album == null) {
            throw new IllegalArgumentException("album argument cannot be null");
        }
        try {
            AlbumImpl albumImpl = (AlbumImpl)album;
            if (albumImpl.getFichotheque() != this) {
                throw new IllegalArgumentException("album argument does not come from this Fichotheque instance");
            }
            return albumImpl;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("album argument does not come from this Fichotheque instance");
        }
    }

    private AddendaImpl testAddenda(Addenda addenda) {
        if (addenda == null) {
            throw new IllegalArgumentException("addenda argument cannot be null");
        }
        try {
            AddendaImpl addendaImpl = (AddendaImpl)addenda;
            if (addendaImpl.getFichotheque() != this) {
                throw new IllegalArgumentException("addenda argument does not come from this Fichotheque instance");
            }
            return addendaImpl;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("addenda argument does not come from this Fichotheque instance");
        }
    }

    public static class InitEditor
    implements FichothequeEditor {
        private final FichothequeImpl fichotheque;
        private final FichothequeMetadataImpl.InitEditor metadataInitEditor;
        private final Map<SubsetKey, Object> subsetEditorMap = new HashMap<SubsetKey, Object>();
        private final InitCroisementEditor initCroisementEditor;

        private InitEditor(FichothequeImpl fichotheque) {
            this.fichotheque = fichotheque;
            this.metadataInitEditor = FichothequeMetadataImpl.init(fichotheque, this);
            fichotheque.fichothequeMetadata = (FichothequeMetadataImpl)this.metadataInitEditor.getMetadata();
            this.initCroisementEditor = new InitCroisementEditor(fichotheque, this);
        }

        @Override
        public Fichotheque getFichotheque() {
            return this.fichotheque;
        }

        @Override
        public EditOrigin getEditOrigin() {
            throw new UnsupportedOperationException("No edit here, only init");
        }

        @Override
        public FichothequeMetadataEditor getFichothequeMetadataEditor() {
            return this.metadataInitEditor;
        }

        @Override
        public CorpusEditor createCorpus(SubsetKey corpusKey, Subset masterSubset) throws ExistingSubsetException {
            this.fichotheque.testCorpusCreate(corpusKey, masterSubset);
            CorpusImpl.InitEditor corpusInitEditor = CorpusImpl.fromInit(corpusKey, this.fichotheque, masterSubset, this);
            this.subsetEditorMap.put(corpusKey, corpusInitEditor);
            this.fichotheque.endCorpusCreation((CorpusImpl)corpusInitEditor.getCorpus(), masterSubset);
            return corpusInitEditor;
        }

        @Override
        public SphereEditor createSphere(SubsetKey sphereKey) throws ExistingSubsetException {
            this.fichotheque.testSphereCreate(sphereKey);
            SphereImpl.InitEditor sphereInitEditor = SphereImpl.fromInit(sphereKey, this.fichotheque, this);
            this.fichotheque.endSphereCreation((SphereImpl)sphereInitEditor.getSphere());
            return sphereInitEditor;
        }

        @Override
        public ThesaurusEditor createThesaurus(SubsetKey thesaurusKey, short thesaurusType) throws ExistingSubsetException {
            this.fichotheque.testThesaurusCreate(thesaurusKey, thesaurusType);
            ThesaurusImpl.InitEditor thesaurusInitEditor = ThesaurusImpl.fromInit(thesaurusKey, thesaurusType, this.fichotheque, this);
            this.fichotheque.endThesaurusCreation((ThesaurusImpl)thesaurusInitEditor.getThesaurus());
            return thesaurusInitEditor;
        }

        @Override
        public AlbumEditor createAlbum(SubsetKey albumKey) throws ExistingSubsetException {
            this.fichotheque.testAlbumCreate(albumKey);
            AlbumImpl.InitEditor albumInitEditor = AlbumImpl.fromInit(albumKey, this.fichotheque, this);
            this.fichotheque.endAlbumCreation((AlbumImpl)albumInitEditor.getAlbum());
            return albumInitEditor;
        }

        @Override
        public AddendaEditor createAddenda(SubsetKey addendaKey) throws ExistingSubsetException {
            this.fichotheque.testAddendaCreate(addendaKey);
            AddendaImpl.InitEditor addendaInitEditor = AddendaImpl.fromInit(addendaKey, this.fichotheque, this);
            this.fichotheque.endAddendaCreation((AddendaImpl)addendaInitEditor.getAddenda());
            return addendaInitEditor;
        }

        @Override
        public CorpusEditor getCorpusEditor(SubsetKey corpusKey) {
            return (CorpusEditor)this.subsetEditorMap.get(corpusKey);
        }

        @Override
        public AddendaEditor getAddendaEditor(SubsetKey addendaKey) {
            return (AddendaEditor)this.subsetEditorMap.get(addendaKey);
        }

        @Override
        public SphereEditor getSphereEditor(SubsetKey sphereKey) {
            return (SphereEditor)this.subsetEditorMap.get(sphereKey);
        }

        @Override
        public ThesaurusEditor getThesaurusEditor(SubsetKey thesaurusKey) {
            return (ThesaurusEditor)this.subsetEditorMap.get(thesaurusKey);
        }

        @Override
        public AlbumEditor getAlbumEditor(SubsetKey albumKey) {
            return (AlbumEditor)this.subsetEditorMap.get(albumKey);
        }

        @Override
        public CroisementEditor getCroisementEditor() {
            return this.initCroisementEditor;
        }

        @Override
        public void removeSphere(Sphere sphere) throws NoRemoveableSubsetException {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public void removeThesaurus(Thesaurus thesaurus) throws NoRemoveableSubsetException {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public void removeAlbum(Album album) throws NoRemoveableSubsetException {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public void removeCorpus(Corpus corpus) throws NoRemoveableSubsetException {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public boolean putAttribute(Object attributeHolder, Attribute attribute) {
            return this.fichotheque.innerPutAttribute(attributeHolder, attribute);
        }

        @Override
        public void removeAddenda(Addenda addenda) throws NoRemoveableSubsetException {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public boolean removeAttribute(Object attributeHolder, AttributeKey attributeKey) {
            return this.fichotheque.innerRemoveAttribute(attributeHolder, attributeKey);
        }

        public FichothequeEditorProvider endInit(FichothequeDataSource fichothequeDataSource, HtmlCleaner htmlCleaner) {
            this.fichotheque.fichothequeDataSource = fichothequeDataSource;
            return new FichothequeEditorProviderImpl(this.fichotheque, htmlCleaner);
        }

        @Override
        public void saveChanges() {
            throw new UnsupportedOperationException("Not during init");
        }
    }

    private class FichothequeEditorImpl
    implements FichothequeEditor {
        private final EditOrigin editOrigin;
        private final Map<SubsetKey, Object> editorBufferMap = new HashMap<SubsetKey, Object>();
        private FichothequeMetadataImpl.FichothequeMetadataEditorImpl fichothequeMetadataEditor;
        private CroisementEditorImpl croisementEditor;

        private FichothequeEditorImpl(EditOrigin editOrigin) {
            this.editOrigin = editOrigin;
        }

        @Override
        public Fichotheque getFichotheque() {
            return FichothequeImpl.this;
        }

        @Override
        public EditOrigin getEditOrigin() {
            return this.editOrigin;
        }

        @Override
        public FichothequeMetadataEditor getFichothequeMetadataEditor() {
            if (this.fichothequeMetadataEditor == null) {
                this.fichothequeMetadataEditor = FichothequeImpl.this.fichothequeMetadata.getFichothequeMetadataEditor(this);
            }
            return this.fichothequeMetadataEditor;
        }

        @Override
        public CroisementEditor getCroisementEditor() {
            if (this.croisementEditor == null) {
                this.croisementEditor = new CroisementEditorImpl(this);
            }
            return this.croisementEditor;
        }

        @Override
        public CorpusEditor createCorpus(SubsetKey corpusKey, Subset masterSubset) throws ExistingSubsetException {
            FichothequeImpl.this.testCorpusCreate(corpusKey, masterSubset);
            CorpusImpl corpus = CorpusImpl.fromNew(corpusKey, FichothequeImpl.this, masterSubset);
            FichothequeImpl.this.endCorpusCreation(corpus, masterSubset);
            FichothequeImpl.this.getListeners().fireSubsetCreated(this, corpus);
            CorpusImpl.CorpusEditorImpl corpusEditor = (CorpusImpl.CorpusEditorImpl)this.getCorpusEditor(corpusKey);
            corpusEditor.setMetadataChange();
            return corpusEditor;
        }

        @Override
        public SphereEditor createSphere(SubsetKey sphereKey) throws ExistingSubsetException {
            FichothequeImpl.this.testSphereCreate(sphereKey);
            SphereImpl sphere = SphereImpl.fromNew(sphereKey, FichothequeImpl.this);
            FichothequeImpl.this.endSphereCreation(sphere);
            FichothequeImpl.this.getListeners().fireSubsetCreated(this, sphere);
            SphereImpl.SphereEditorImpl sphereEditor = (SphereImpl.SphereEditorImpl)this.getSphereEditor(sphereKey);
            sphereEditor.setMetadataChange();
            return sphereEditor;
        }

        @Override
        public ThesaurusEditor createThesaurus(SubsetKey thesaurusKey, short thesaurusType) throws ExistingSubsetException {
            FichothequeImpl.this.testThesaurusCreate(thesaurusKey, thesaurusType);
            ThesaurusImpl thesaurus = ThesaurusImpl.fromNew(thesaurusKey, thesaurusType, FichothequeImpl.this);
            FichothequeImpl.this.endThesaurusCreation(thesaurus);
            FichothequeImpl.this.getListeners().fireSubsetCreated(this, thesaurus);
            ThesaurusImpl.ThesaurusEditorImpl thesaurusEditor = (ThesaurusImpl.ThesaurusEditorImpl)this.getThesaurusEditor(thesaurusKey);
            thesaurusEditor.setMetadataChange();
            return thesaurusEditor;
        }

        @Override
        public AlbumEditor createAlbum(SubsetKey albumKey) throws ExistingSubsetException {
            FichothequeImpl.this.testAlbumCreate(albumKey);
            AlbumImpl album = AlbumImpl.fromNew(albumKey, FichothequeImpl.this);
            FichothequeImpl.this.endAlbumCreation(album);
            FichothequeImpl.this.getListeners().fireSubsetCreated(this, album);
            AlbumImpl.AlbumEditorImpl albumEditor = (AlbumImpl.AlbumEditorImpl)this.getAlbumEditor(albumKey);
            albumEditor.setMetadataChange();
            return albumEditor;
        }

        @Override
        public AddendaEditor createAddenda(SubsetKey addendaKey) throws ExistingSubsetException {
            FichothequeImpl.this.testAddendaCreate(addendaKey);
            AddendaImpl addenda = AddendaImpl.fromNew(addendaKey, FichothequeImpl.this);
            FichothequeImpl.this.endAddendaCreation(addenda);
            FichothequeImpl.this.getListeners().fireSubsetCreated(this, addenda);
            AddendaImpl.AddendaEditorImpl addendaEditor = (AddendaImpl.AddendaEditorImpl)this.getAddendaEditor(addendaKey);
            addendaEditor.setMetadataChange();
            return addendaEditor;
        }

        @Override
        public CorpusEditor getCorpusEditor(SubsetKey corpusKey) {
            Object editor = this.editorBufferMap.get(corpusKey);
            if (editor != null) {
                return (CorpusEditor)editor;
            }
            CorpusImpl corpus = (CorpusImpl)FichothequeImpl.this.subsetMap.get(corpusKey);
            if (corpus == null) {
                return null;
            }
            CorpusImpl.CorpusEditorImpl corpusEditor = corpus.getCorpusEditor(this);
            this.editorBufferMap.put(corpusKey, corpusEditor);
            return corpusEditor;
        }

        @Override
        public AddendaEditor getAddendaEditor(SubsetKey addendaKey) {
            Object editor = this.editorBufferMap.get(addendaKey);
            if (editor != null) {
                return (AddendaEditor)editor;
            }
            AddendaImpl addenda = (AddendaImpl)FichothequeImpl.this.subsetMap.get(addendaKey);
            if (addenda == null) {
                return null;
            }
            AddendaImpl.AddendaEditorImpl addendaEditor = addenda.getAddendaEditor(this);
            this.editorBufferMap.put(addendaKey, addendaEditor);
            return addendaEditor;
        }

        @Override
        public SphereEditor getSphereEditor(SubsetKey sphereKey) {
            Object editor = this.editorBufferMap.get(sphereKey);
            if (editor != null) {
                return (SphereEditor)editor;
            }
            SphereImpl sphere = (SphereImpl)FichothequeImpl.this.subsetMap.get(sphereKey);
            if (sphere == null) {
                return null;
            }
            SphereImpl.SphereEditorImpl sphereEditor = sphere.getSphereEditor(this);
            this.editorBufferMap.put(sphereKey, sphereEditor);
            return sphereEditor;
        }

        @Override
        public ThesaurusEditor getThesaurusEditor(SubsetKey thesaurusKey) {
            Object editor = this.editorBufferMap.get(thesaurusKey);
            if (editor != null) {
                return (ThesaurusEditor)editor;
            }
            ThesaurusImpl thesaurus = (ThesaurusImpl)FichothequeImpl.this.subsetMap.get(thesaurusKey);
            if (thesaurus == null) {
                return null;
            }
            ThesaurusImpl.ThesaurusEditorImpl thesaurusEditor = thesaurus.getThesaurusEditor(this);
            this.editorBufferMap.put(thesaurusKey, thesaurusEditor);
            return thesaurusEditor;
        }

        @Override
        public AlbumEditor getAlbumEditor(SubsetKey albumKey) {
            Object editor = this.editorBufferMap.get(albumKey);
            if (editor != null) {
                return (AlbumEditor)editor;
            }
            AlbumImpl album = (AlbumImpl)FichothequeImpl.this.subsetMap.get(albumKey);
            if (album == null) {
                return null;
            }
            AlbumImpl.AlbumEditorImpl albumEditor = album.getAlbumEditor(this);
            this.editorBufferMap.put(albumKey, albumEditor);
            return albumEditor;
        }

        @Override
        public void removeSphere(Sphere sphere) throws NoRemoveableSubsetException {
            SubsetKey sphereKey = sphere.getSubsetKey();
            Object editor = this.editorBufferMap.get(sphereKey);
            if (editor != null) {
                this.editorBufferMap.remove(sphereKey);
                ((SphereImpl.SphereEditorImpl)editor).saveChanges();
            }
            FichothequeImpl.this.innerRemoveSphere(sphere);
            FichothequeImpl.this.fichothequeDataSource.removeSphere(sphereKey, this.editOrigin);
            FichothequeImpl.this.getListeners().fireSubsetRemoved(this, sphereKey, null);
        }

        @Override
        public void removeThesaurus(Thesaurus thesaurus) throws NoRemoveableSubsetException {
            SubsetKey thesaurusKey = thesaurus.getSubsetKey();
            Object editor = this.editorBufferMap.get(thesaurusKey);
            if (editor != null) {
                this.editorBufferMap.remove(thesaurusKey);
                ((ThesaurusImpl.ThesaurusEditorImpl)editor).saveChanges();
            }
            FichothequeImpl.this.innerRemoveThesaurus(thesaurus);
            FichothequeImpl.this.fichothequeDataSource.removeThesaurus(thesaurusKey, this.editOrigin);
            FichothequeImpl.this.getListeners().fireSubsetRemoved(this, thesaurusKey, null);
        }

        @Override
        public void removeAlbum(Album album) throws NoRemoveableSubsetException {
            SubsetKey albumKey = album.getSubsetKey();
            Object editor = this.editorBufferMap.get(albumKey);
            if (editor != null) {
                this.editorBufferMap.remove(albumKey);
                ((ThesaurusImpl.ThesaurusEditorImpl)editor).saveChanges();
            }
            FichothequeImpl.this.innerRemoveAlbum(album);
            FichothequeImpl.this.fichothequeDataSource.removeAlbum(albumKey, this.editOrigin);
            FichothequeImpl.this.getListeners().fireSubsetRemoved(this, albumKey, null);
        }

        @Override
        public void removeAddenda(Addenda addenda) throws NoRemoveableSubsetException {
            SubsetKey addendaKey = addenda.getSubsetKey();
            Object editor = this.editorBufferMap.get(addendaKey);
            if (editor != null) {
                this.editorBufferMap.remove(addendaKey);
                ((ThesaurusImpl.ThesaurusEditorImpl)editor).saveChanges();
            }
            FichothequeImpl.this.innerRemoveAddenda(addenda);
            FichothequeImpl.this.fichothequeDataSource.removeAddenda(addendaKey, this.editOrigin);
            FichothequeImpl.this.getListeners().fireSubsetRemoved(this, addendaKey, null);
        }

        @Override
        public void removeCorpus(Corpus corpus) throws NoRemoveableSubsetException {
            SubsetKey corpusKey = corpus.getSubsetKey();
            Subset masterSubset = corpus.getMasterSubset();
            Object editor = this.editorBufferMap.get(corpusKey);
            if (editor != null) {
                this.editorBufferMap.remove(corpusKey);
                ((CorpusImpl.CorpusEditorImpl)editor).saveChanges();
            }
            FichothequeImpl.this.innerRemoveCorpus(corpus);
            FichothequeImpl.this.fichothequeDataSource.removeCorpus(corpusKey, masterSubset, this.editOrigin);
            FichothequeImpl.this.getListeners().fireSubsetRemoved(this, corpusKey, masterSubset);
        }

        @Override
        public boolean putAttribute(Object attributeHolder, Attribute attribute) {
            boolean done = FichothequeImpl.this.innerPutAttribute(attributeHolder, attribute);
            if (done) {
                if (attributeHolder instanceof AbstractMetadata) {
                    ((AbstractMetadata)attributeHolder).fireChange(this);
                } else if (attributeHolder instanceof AbstractSubsetItem) {
                    this.saveAttributes((SubsetItem)attributeHolder);
                } else if (attributeHolder instanceof CroisementImpl) {
                    this.addCroisementChange(((CroisementImpl)attributeHolder).getCroisementKey());
                }
            }
            return done;
        }

        @Override
        public boolean removeAttribute(Object attributeHolder, AttributeKey attributeKey) {
            boolean done = FichothequeImpl.this.innerRemoveAttribute(attributeHolder, attributeKey);
            if (done) {
                if (attributeHolder instanceof AbstractMetadata) {
                    ((AbstractMetadata)attributeHolder).fireChange(this);
                } else if (attributeHolder instanceof AbstractSubsetItem) {
                    this.saveAttributes((SubsetItem)attributeHolder);
                } else if (attributeHolder instanceof CroisementImpl) {
                    this.addCroisementChange(((CroisementImpl)attributeHolder).getCroisementKey());
                }
            }
            return done;
        }

        @Override
        public void saveChanges() {
            if (this.fichothequeMetadataEditor != null) {
                this.fichothequeMetadataEditor.saveChanges();
            }
            if (this.croisementEditor != null) {
                this.croisementEditor.saveChanges();
            }
            for (Object obj : this.editorBufferMap.values()) {
                if (obj instanceof ThesaurusImpl.ThesaurusEditorImpl) {
                    ((ThesaurusImpl.ThesaurusEditorImpl)obj).saveChanges();
                    continue;
                }
                if (obj instanceof CorpusImpl.CorpusEditorImpl) {
                    ((CorpusImpl.CorpusEditorImpl)obj).saveChanges();
                    continue;
                }
                if (obj instanceof SphereImpl.SphereEditorImpl) {
                    ((SphereImpl.SphereEditorImpl)obj).saveChanges();
                    continue;
                }
                if (obj instanceof AlbumImpl.AlbumEditorImpl) {
                    ((AlbumImpl.AlbumEditorImpl)obj).saveChanges();
                    continue;
                }
                if (!(obj instanceof AddendaImpl.AddendaEditorImpl)) continue;
                ((AddendaImpl.AddendaEditorImpl)obj).saveChanges();
            }
        }

        private void saveAttributes(SubsetItem subsetItem) {
            SubsetKey subsetKey = subsetItem.getSubsetKey();
            int id = subsetItem.getId();
            if (subsetKey.isThesaurusSubset()) {
                ThesaurusEditor thesaurusEditor = this.getThesaurusEditor(subsetKey);
                ((ThesaurusImpl.ThesaurusEditorImpl)thesaurusEditor).addMotcleChange(id);
            } else if (subsetKey.isSphereSubset()) {
                SphereEditor sphereEditor = this.getSphereEditor(subsetKey);
                ((SphereImpl.SphereEditorImpl)sphereEditor).addRedacteurChange(id);
            } else if (subsetKey.isAlbumSubset()) {
                AlbumEditor albumEditor = this.getAlbumEditor(subsetKey);
                ((AlbumImpl.AlbumEditorImpl)albumEditor).addIllustrationChange(id);
            } else if (subsetKey.isAddendaSubset()) {
                AddendaEditor addendaEditor = this.getAddendaEditor(subsetKey);
                ((AddendaImpl.AddendaEditorImpl)addendaEditor).addDocumentChange(id);
            } else if (subsetKey.isCorpusSubset()) {
                CorpusEditor corpusEditor = this.getCorpusEditor(subsetKey);
                ((CorpusImpl.CorpusEditorImpl)corpusEditor).addAttributesChange(id);
            }
        }

        private void addCroisementChange(CroisementKey croisementKey) {
            ((CroisementEditorImpl)this.getCroisementEditor()).addCroisementChange(croisementKey);
        }
    }

    private static class FichothequeEditorProviderImpl
    implements FichothequeEditorProvider {
        private final FichothequeImpl fichotheque;
        private final HtmlCleaner htmlCleaner;

        private FichothequeEditorProviderImpl(FichothequeImpl fichotheque, HtmlCleaner htmlCleaner) {
            this.fichotheque = fichotheque;
            this.htmlCleaner = htmlCleaner;
        }

        @Override
        public Fichotheque getFichotheque() {
            return this.fichotheque;
        }

        @Override
        public HtmlCleaner getHtmlCleaner() {
            return this.htmlCleaner;
        }

        @Override
        public FichothequeEditor newFichothequeEditor(EditOrigin editOrigin) {
            return this.fichotheque.getFichothequeEditor(editOrigin);
        }
    }

    private class CroisementEditorImpl
    implements CroisementEditor {
        private final FichothequeEditor fichothequeEditor;
        private final Set<CroisementKey> removedCroisementSet = new HashSet<CroisementKey>();
        private final Set<CroisementKey> changedCroisementSet = new HashSet<CroisementKey>();

        private CroisementEditorImpl(FichothequeEditor fichothequeEditor) {
            this.fichothequeEditor = fichothequeEditor;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.fichothequeEditor;
        }

        @Override
        public boolean removeCroisement(SubsetItem subsetItem1, SubsetItem subsetItem2) {
            CroisementKey croisementKey = CroisementKey.toCroisementKey(subsetItem1, subsetItem2);
            CroisementImpl croisement = (CroisementImpl)FichothequeImpl.this.croisementMap.get(croisementKey);
            if (croisement == null) {
                return false;
            }
            croisement.unlink();
            FichothequeImpl.this.croisementMap.remove(croisementKey);
            this.removedCroisementSet.add(croisementKey);
            return true;
        }

        @Override
        public Croisement updateCroisement(SubsetItem subsetItem1, SubsetItem subsetItem2, CroisementChange croisementChange) {
            boolean done;
            CroisementKey croisementKey = CroisementKey.toCroisementKey(subsetItem1, subsetItem2);
            CroisementImpl croisement = (CroisementImpl)FichothequeImpl.this.croisementMap.get(croisementKey);
            if (croisement == null) {
                if (croisementChange.getChangedLienList().isEmpty()) {
                    return null;
                }
                croisement = CroisementImpl.newInstance(croisementKey, (AbstractSubsetItem)subsetItem1, (AbstractSubsetItem)subsetItem2);
                FichothequeImpl.this.croisementMap.put(croisementKey, croisement);
            }
            if (done = croisement.change(croisementChange)) {
                this.addCroisementChange(croisementKey);
                if (croisement.isEmpty()) {
                    croisement.unlink();
                    FichothequeImpl.this.croisementMap.remove(croisementKey);
                    this.removedCroisementSet.add(croisementKey);
                    return null;
                }
            }
            return croisement;
        }

        @Override
        public void updateCroisements(SubsetItem mainSubsetItem, CroisementChanges croisementChanges) {
            for (SubsetItem otherSubsetItem : croisementChanges.getRemovedList()) {
                this.removeCroisement(mainSubsetItem, otherSubsetItem);
            }
            for (CroisementChanges.Entry entry : croisementChanges.getEntryList()) {
                SubsetItem otherSubsetItem = entry.getSubsetItem();
                this.updateCroisement(mainSubsetItem, otherSubsetItem, entry.getCroisementChange());
            }
        }

        void addCroisementChange(CroisementKey croisementKey) {
            this.changedCroisementSet.add(croisementKey);
        }

        void saveChanges() {
            EditOrigin editOrigin = this.fichothequeEditor.getEditOrigin();
            CroisementDataSource croisementDataSource = FichothequeImpl.this.getFichothequeDataSource().getCroisementDataSource();
            for (CroisementKey croisementKey : this.changedCroisementSet) {
                Croisement croisement = (Croisement)FichothequeImpl.this.croisementMap.get(croisementKey);
                if (croisement == null) continue;
                croisementDataSource.saveCroisement(croisement, editOrigin);
            }
            this.changedCroisementSet.clear();
            for (CroisementKey croisementKey : this.removedCroisementSet) {
                croisementDataSource.removeCroisement(croisementKey, editOrigin);
            }
            this.removedCroisementSet.clear();
        }
    }

    private static class InitCroisementEditor
    implements CroisementEditor {
        private final FichothequeImpl fichotheque;
        private final InitEditor initEditor;

        private InitCroisementEditor(FichothequeImpl fichotheque, InitEditor initEditor) {
            this.fichotheque = fichotheque;
            this.initEditor = initEditor;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.initEditor;
        }

        @Override
        public boolean removeCroisement(SubsetItem subsetItem1, SubsetItem subsetItem2) {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public Croisement updateCroisement(SubsetItem subsetItem1, SubsetItem subsetItem2, CroisementChange croisementChange) {
            CroisementKey croisementKey = CroisementKey.toCroisementKey(subsetItem1, subsetItem2);
            CroisementImpl croisement = (CroisementImpl)this.fichotheque.croisementMap.get(croisementKey);
            if (croisement == null) {
                if (croisementChange.getChangedLienList().isEmpty()) {
                    return null;
                }
                croisement = CroisementImpl.newInstance(croisementKey, (AbstractSubsetItem)subsetItem1, (AbstractSubsetItem)subsetItem2);
                this.fichotheque.croisementMap.put(croisementKey, croisement);
            }
            croisement.change(croisementChange);
            return croisement;
        }

        @Override
        public void updateCroisements(SubsetItem mainSubsetItem, CroisementChanges croisementChanges) {
            for (CroisementChanges.Entry entry : croisementChanges.getEntryList()) {
                SubsetItem otherSubsetItem = entry.getSubsetItem();
                this.updateCroisement(mainSubsetItem, otherSubsetItem, entry.getCroisementChange());
            }
        }
    }
}

