/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.croisement.Croisement;
import net.fichotheque.croisement.CroisementChange;
import net.fichotheque.croisement.CroisementKey;
import net.fichotheque.croisement.Lien;
import net.fichotheque.impl.AbstractSubsetItem;
import net.fichotheque.utils.CroisementUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesCache;

class CroisementImpl
implements Croisement {
    private final CroisementKey croisementKey;
    private final Map<String, Lien> lienMap = new HashMap<String, Lien>();
    private AttributesCache attributesCache = null;
    private List<Lien> cacheList;
    AbstractSubsetItem subsetItem1;
    AbstractSubsetItem subsetItem2;

    private CroisementImpl(CroisementKey croisementKey, AbstractSubsetItem subsetItem1, AbstractSubsetItem subsetItem2) {
        this.croisementKey = croisementKey;
        this.subsetItem1 = subsetItem1;
        this.subsetItem2 = subsetItem2;
    }

    boolean isEmpty() {
        return this.lienMap.isEmpty();
    }

    @Override
    public CroisementKey getCroisementKey() {
        return this.croisementKey;
    }

    @Override
    public List<Lien> getLienList() {
        List<Lien> result = this.cacheList;
        if (result == null) {
            result = this.initCache();
        }
        return result;
    }

    @Override
    public Lien getLienByMode(String mode) {
        return this.lienMap.get(mode);
    }

    @Override
    public Attributes getAttributes() {
        if (this.attributesCache == null) {
            return AttributeUtils.EMPTY_ATTRIBUTES;
        }
        return this.attributesCache.getAttributes();
    }

    protected synchronized boolean innerRemoveAttribute(AttributeKey attributeKey) {
        if (this.attributesCache == null) {
            return false;
        }
        return this.attributesCache.removeAttribute(attributeKey);
    }

    protected synchronized boolean innerPutAttribute(Attribute attribute) {
        if (this.attributesCache == null) {
            this.attributesCache = new AttributesCache();
        }
        return this.attributesCache.putAttribute(attribute);
    }

    protected synchronized boolean change(CroisementChange croisementChange) {
        this.clearCache();
        boolean done = false;
        for (String mode : croisementChange.getRemovedModeList()) {
            Lien currentLien = this.lienMap.remove(mode);
            if (currentLien == null) continue;
            done = true;
        }
        for (Lien changedLien : croisementChange.getChangedLienList()) {
            String mode = changedLien.getMode();
            Lien currentLien = this.lienMap.get(mode);
            if (currentLien != null) {
                if (CroisementUtils.areEquals(currentLien, changedLien)) continue;
                this.lienMap.put(mode, changedLien);
                done = true;
                continue;
            }
            this.lienMap.put(mode, changedLien);
            done = true;
        }
        return done;
    }

    private synchronized List<Lien> initCache() {
        if (this.cacheList != null) {
            return this.cacheList;
        }
        TreeMap<String, Lien> sortedMap = new TreeMap<String, Lien>(this.lienMap);
        List<Lien> list = CroisementUtils.wrap(sortedMap.values().toArray(new Lien[sortedMap.size()]));
        this.cacheList = list;
        return list;
    }

    void unlink() {
        this.subsetItem1.unlink(this.subsetItem2, this);
        this.subsetItem2.unlink(this.subsetItem1, this);
        this.subsetItem1 = null;
        this.subsetItem2 = null;
    }

    private void clearCache() {
        this.cacheList = null;
    }

    static CroisementImpl newInstance(Fichotheque fichotheque, CroisementKey croisementKey) {
        Subset subset1 = fichotheque.getSubset(croisementKey.getSubsetKey1());
        if (subset1 == null) {
            return null;
        }
        AbstractSubsetItem subsetItem1 = (AbstractSubsetItem)subset1.getSubsetItemById(croisementKey.getId1());
        if (subsetItem1 == null) {
            return null;
        }
        Subset subset2 = fichotheque.getSubset(croisementKey.getSubsetKey2());
        if (subset2 == null) {
            return null;
        }
        AbstractSubsetItem subsetItem2 = (AbstractSubsetItem)subset2.getSubsetItemById(croisementKey.getId2());
        if (subsetItem2 == null) {
            return null;
        }
        CroisementImpl croisement = new CroisementImpl(croisementKey, subsetItem1, subsetItem2);
        subsetItem1.link(subsetItem2, croisement);
        subsetItem2.link(subsetItem1, croisement);
        return croisement;
    }

    static CroisementImpl newInstance(CroisementKey croisementKey, AbstractSubsetItem subsetItem1, AbstractSubsetItem subsetItem2) {
        if (croisementKey.getOrder(subsetItem1) == 2) {
            AbstractSubsetItem temp = subsetItem1;
            subsetItem1 = subsetItem2;
            subsetItem2 = temp;
        }
        CroisementImpl croisement = new CroisementImpl(croisementKey, subsetItem1, subsetItem2);
        subsetItem1.link(subsetItem2, croisement);
        subsetItem2.link(subsetItem1, croisement);
        return croisement;
    }
}

