/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Metadata;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Personne;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.history.CroisementHistory;
import net.fichotheque.history.FicheHistory;
import net.fichotheque.impl.AbstractSubsetItem;
import net.fichotheque.impl.CorpusDataSource;
import net.fichotheque.impl.CorpusMetadataImpl;
import net.fichotheque.impl.FichothequeImpl;
import net.fichotheque.impl.Listeners;
import net.fichotheque.impl.Satellites;
import net.fichotheque.namespaces.BdfSpace;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.utils.CorpusUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.StringUtils;

class CorpusImpl
implements Corpus {
    private final SubsetKey corpusKey;
    private final FichothequeImpl fichotheque;
    private CorpusMetadataImpl corpusMetadata;
    private int availableId = 1;
    private final Satellites satellites = new Satellites();
    private Subset masterSubset;
    private List<SubsetItem> cacheSubsetItemList;
    private List<FicheMeta> cacheList;
    private final Map<Integer, FicheMetaImpl> itemMap = new HashMap<Integer, FicheMetaImpl>();

    private CorpusImpl(SubsetKey corpusKey, FichothequeImpl fichotheque, Subset masterSubset) {
        this.fichotheque = fichotheque;
        this.corpusKey = corpusKey;
        this.masterSubset = masterSubset;
    }

    static InitEditor fromInit(SubsetKey corpusKey, FichothequeImpl fichotheque, Subset masterSubset, FichothequeImpl.InitEditor fichothequeInitEditor) {
        CorpusImpl corpus = new CorpusImpl(corpusKey, fichotheque, masterSubset);
        return new InitEditor(corpus, fichothequeInitEditor);
    }

    static CorpusImpl fromNew(SubsetKey corpusKey, FichothequeImpl fichotheque, Subset masterSubset) {
        CorpusImpl corpus = new CorpusImpl(corpusKey, fichotheque, masterSubset);
        corpus.corpusMetadata = CorpusMetadataImpl.fromNew(corpus);
        return corpus;
    }

    @Override
    public Fichotheque getFichotheque() {
        return this.fichotheque;
    }

    @Override
    public Metadata getMetadata() {
        return this.corpusMetadata;
    }

    @Override
    public FicheMeta getFicheMetaById(int id) {
        return this.itemMap.get(id);
    }

    @Override
    public Fiche getFicheAPI(FicheMeta ficheMeta, boolean withSection) {
        return this.getCorpusDataSource().getFiche(ficheMeta, withSection);
    }

    @Override
    public Fiche getFiche(FicheMeta ficheMeta) {
        return this.getCorpusDataSource().getFiche(ficheMeta, true);
    }

    @Override
    public SubsetKey getSubsetKey() {
        return this.corpusKey;
    }

    @Override
    public SubsetItem getSubsetItemById(int id) {
        return this.itemMap.get(id);
    }

    @Override
    public int size() {
        return this.itemMap.size();
    }

    @Override
    public List<SubsetItem> getSubsetItemList() {
        List<SubsetItem> list = this.cacheSubsetItemList;
        if (list == null) {
            list = this.initSubsetItemList();
        }
        return list;
    }

    @Override
    public List<FicheMeta> getFicheMetaList() {
        List<FicheMeta> result = this.cacheList;
        if (result == null) {
            result = this.initFicheMetaList();
        }
        return result;
    }

    @Override
    public Subset getMasterSubset() {
        return this.masterSubset;
    }

    @Override
    public List<Corpus> getSatelliteCorpusList() {
        return this.satellites.getCache();
    }

    @Override
    public FicheHistory getFicheHistory(int id) {
        return this.getCorpusDataSource().getFicheHistory(this.corpusKey, id);
    }

    @Override
    public List<FicheHistory> getRemovedFicheHistoryList() {
        return this.getCorpusDataSource().getRemovedFicheHistoryList(this);
    }

    @Override
    public List<CroisementHistory> getCroisementHistoryList(int ficheId, SubsetKey subsetKey) {
        return this.getCorpusDataSource().getCroisementHistoryList(this.corpusKey, ficheId, subsetKey);
    }

    @Override
    public Fiche getFicheRevision(int id, String revisionName) {
        return this.getCorpusDataSource().getFicheRevision(this.corpusKey, id, revisionName);
    }

    CorpusEditorImpl getCorpusEditor(FichothequeEditor fichothequeEditor) {
        return new CorpusEditorImpl(fichothequeEditor);
    }

    void clear() {
        this.corpusMetadata.clear();
        this.masterSubset = null;
    }

    Listeners getListeners() {
        return this.fichotheque.getListeners();
    }

    void addSatelliteCorpus(CorpusImpl corpus) {
        this.satellites.add(corpus);
    }

    void removeSatelliteCorpus(CorpusImpl corpus) {
        this.satellites.remove(corpus);
    }

    private CorpusDataSource getCorpusDataSource() {
        return this.fichotheque.getFichothequeDataSource().getCorpusDataSource();
    }

    private synchronized FicheMeta innerCreateFiche(int id) throws ExistingIdException, NoMasterIdException {
        if (this.masterSubset != null) {
            SubsetItem subsetItem = this.masterSubset.getSubsetItemById(id);
            if (subsetItem == null) {
                throw new NoMasterIdException();
            }
            if (this.itemMap.containsKey(id)) {
                throw new ExistingIdException();
            }
        } else if (id < 1) {
            id = this.availableId;
        } else if (this.itemMap.containsKey(id)) {
            throw new ExistingIdException();
        }
        FicheMetaImpl ficheMeta = new FicheMetaImpl(id);
        this.itemMap.put(id, ficheMeta);
        this.availableId = Math.max(this.availableId, id + 1);
        this.clearCache();
        return ficheMeta;
    }

    private boolean innerSetDate(FicheMeta ficheMeta, FuzzyDate date, boolean modification) {
        FicheMetaImpl ficheMetaImpl = this.testFicheMeta(ficheMeta);
        return ficheMetaImpl.setDate(date, modification);
    }

    private void innerUpdateFiche(FicheMeta ficheMeta, FicheAPI fiche) {
        FicheMetaImpl ficheMetaImpl = this.testFicheMeta(ficheMeta);
        ficheMetaImpl.update(fiche);
    }

    private synchronized boolean innerRemoveFiche(FicheMeta ficheMeta) {
        FicheMetaImpl ficheMetaImpl = this.testFicheMeta(ficheMeta);
        if (!this.fichotheque.isRemoveable(ficheMetaImpl)) {
            return false;
        }
        int id = ficheMetaImpl.getId();
        this.itemMap.remove(id);
        this.clearCache();
        return true;
    }

    private void clearCache() {
        this.cacheSubsetItemList = null;
        this.cacheList = null;
    }

    private synchronized List<SubsetItem> initSubsetItemList() {
        TreeMap<Integer, FicheMetaImpl> sortedMap = new TreeMap<Integer, FicheMetaImpl>();
        sortedMap.putAll(this.itemMap);
        List<SubsetItem> list = FichothequeUtils.wrap(sortedMap.values().toArray(new FicheMeta[sortedMap.size()]));
        this.cacheSubsetItemList = list;
        return list;
    }

    private synchronized List<FicheMeta> initFicheMetaList() {
        TreeMap<Integer, FicheMetaImpl> sortedMap = new TreeMap<Integer, FicheMetaImpl>();
        sortedMap.putAll(this.itemMap);
        List<FicheMeta> list = CorpusUtils.wrap(sortedMap.values().toArray(new FicheMeta[sortedMap.size()]));
        this.cacheList = list;
        return list;
    }

    private FicheMetaImpl testFicheMeta(FicheMeta ficheMeta) {
        if (ficheMeta == null) {
            throw new IllegalArgumentException("ficheMeta argument cannot be null");
        }
        try {
            FicheMetaImpl ficheMetaImpl = (FicheMetaImpl)ficheMeta;
            if (ficheMetaImpl.getCorpus() != this) {
                throw new IllegalArgumentException("ficheMeta argument does not come from this corpus");
            }
            return ficheMetaImpl;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("ficheMeta argument does not come from this corpus");
        }
    }

    static class InitEditor
    implements CorpusEditor {
        private final CorpusImpl corpus;
        private final FichothequeImpl.InitEditor fichothequeInitEditor;
        private final CorpusMetadataImpl.InitEditor metadataInitEditor;

        private InitEditor(CorpusImpl corpus, FichothequeImpl.InitEditor fichothequeInitEditor) {
            this.corpus = corpus;
            this.fichothequeInitEditor = fichothequeInitEditor;
            this.metadataInitEditor = CorpusMetadataImpl.fromInit(this);
            corpus.corpusMetadata = (CorpusMetadataImpl)this.metadataInitEditor.getMetadata();
        }

        @Override
        public Corpus getCorpus() {
            return this.corpus;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.fichothequeInitEditor;
        }

        @Override
        public CorpusMetadataEditor getCorpusMetadataEditor() {
            return this.metadataInitEditor;
        }

        @Override
        public FicheMeta createFiche(int id) throws ExistingIdException, NoMasterIdException {
            return this.corpus.innerCreateFiche(id);
        }

        @Override
        public void saveFiche(FicheMeta ficheMeta, FicheAPI fiche) {
            this.corpus.innerUpdateFiche(ficheMeta, fiche);
        }

        @Override
        public boolean removeFiche(FicheMeta ficheMeta) {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public void setDate(FicheMeta ficheMeta, FuzzyDate date, boolean modification) {
            if (date == null) {
                throw new IllegalArgumentException("date is null");
            }
            this.corpus.innerSetDate(ficheMeta, date, modification);
        }
    }

    class CorpusEditorImpl
    implements CorpusEditor {
        private final FichothequeEditor fichothequeEditor;
        private final Set<Integer> chronoChangeSet = new HashSet<Integer>();
        private final Set<Integer> attributesChangeSet = new HashSet<Integer>();
        private final Set<Integer> removedFicheSet = new HashSet<Integer>();
        private CorpusMetadataEditor corpusMetadataEditor;
        private boolean metadataChanged = false;
        private boolean commitNeeded = false;

        private CorpusEditorImpl(FichothequeEditor fichothequeEditor) {
            this.fichothequeEditor = fichothequeEditor;
        }

        @Override
        public FicheMeta createFiche(int id) throws ExistingIdException, NoMasterIdException {
            FicheMeta ficheMeta = CorpusImpl.this.innerCreateFiche(id);
            CorpusImpl.this.getListeners().fireSubsetItemCreated(this.fichothequeEditor, ficheMeta);
            CorpusDataSource corpusDataSource = CorpusImpl.this.getCorpusDataSource();
            corpusDataSource.saveFiche(ficheMeta, new Fiche(), this.fichothequeEditor.getEditOrigin());
            this.commitNeeded = true;
            return ficheMeta;
        }

        @Override
        public Corpus getCorpus() {
            return CorpusImpl.this;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.fichothequeEditor;
        }

        @Override
        public CorpusMetadataEditor getCorpusMetadataEditor() {
            if (this.corpusMetadataEditor == null) {
                this.corpusMetadataEditor = CorpusImpl.this.corpusMetadata.getCorpusMetadataEditor(this);
            }
            return this.corpusMetadataEditor;
        }

        @Override
        public boolean removeFiche(FicheMeta ficheMeta) {
            int id = ficheMeta.getId();
            boolean done = CorpusImpl.this.innerRemoveFiche(ficheMeta);
            if (done) {
                this.removedFicheSet.add(id);
            }
            return done;
        }

        @Override
        public void saveFiche(FicheMeta ficheMeta, FicheAPI fiche) {
            CorpusImpl.this.innerUpdateFiche(ficheMeta, fiche);
            CorpusImpl.this.getCorpusDataSource().saveFiche(ficheMeta, fiche, this.fichothequeEditor.getEditOrigin());
            CorpusImpl.this.getListeners().fireFicheSaved(this.fichothequeEditor, ficheMeta, fiche);
            this.commitNeeded = true;
        }

        @Override
        public void setDate(FicheMeta ficheMeta, FuzzyDate date, boolean modification) {
            if (date == null) {
                throw new IllegalArgumentException("date is null");
            }
            boolean done = CorpusImpl.this.innerSetDate(ficheMeta, date, modification);
            if (done) {
                this.chronoChangeSet.add(ficheMeta.getId());
            }
        }

        void addAttributesChange(int id) {
            this.attributesChangeSet.add(id);
        }

        void setMetadataChange() {
            this.metadataChanged = true;
        }

        void saveChanges() {
            FicheMeta ficheMeta;
            EditOrigin editOrigin = this.fichothequeEditor.getEditOrigin();
            CorpusDataSource corpusDataSource = CorpusImpl.this.getCorpusDataSource();
            for (Integer id : this.chronoChangeSet) {
                ficheMeta = CorpusImpl.this.getFicheMetaById(id);
                if (ficheMeta == null) continue;
                corpusDataSource.saveChrono(ficheMeta, editOrigin);
            }
            this.chronoChangeSet.clear();
            for (Integer id : this.attributesChangeSet) {
                ficheMeta = CorpusImpl.this.getFicheMetaById(id);
                if (ficheMeta == null) continue;
                corpusDataSource.saveAttributes(ficheMeta, editOrigin);
            }
            this.attributesChangeSet.clear();
            for (Integer id : this.removedFicheSet) {
                corpusDataSource.removeFiche(CorpusImpl.this, id, editOrigin);
                this.commitNeeded = true;
            }
            this.removedFicheSet.clear();
            if (this.metadataChanged) {
                corpusDataSource.saveMetadata(CorpusImpl.this, editOrigin);
                this.metadataChanged = false;
            }
            if (this.commitNeeded) {
                corpusDataSource.commitChanges();
                this.commitNeeded = false;
            }
        }
    }

    private class FicheMetaImpl
    extends AbstractSubsetItem
    implements FicheMeta {
        private final int id;
        private Lang lang = null;
        private String titre = "";
        private FuzzyDate creationDate = null;
        private FuzzyDate modificationDate = null;
        private boolean discarded = false;
        private List<String> redacteurGlobalIdList = StringUtils.EMPTY_STRINGLIST;

        private FicheMetaImpl(int id) {
            this.id = id;
        }

        @Override
        public Subset getSubset() {
            return CorpusImpl.this;
        }

        @Override
        public String getTitre() {
            return this.titre;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public Lang getLang() {
            return this.lang;
        }

        @Override
        public FuzzyDate getModificationDate() {
            return this.modificationDate;
        }

        @Override
        public FuzzyDate getCreationDate() {
            return this.creationDate;
        }

        @Override
        public List<String> getRedacteurGlobalIdList() {
            return this.redacteurGlobalIdList;
        }

        @Override
        public boolean isDiscarded() {
            return this.discarded;
        }

        @Override
        protected boolean innerRemoveAttribute(AttributeKey attributeKey) {
            boolean done = super.innerRemoveAttribute(attributeKey);
            if (done && attributeKey.equals(BdfSpace.DISCARDTEXT_KEY)) {
                this.discarded = false;
            }
            return done;
        }

        @Override
        protected boolean innerPutAttribute(Attribute attribute) {
            AttributeKey attributeKey;
            boolean done = super.innerPutAttribute(attribute);
            if (done && (attributeKey = attribute.getAttributeKey()).equals(BdfSpace.DISCARDTEXT_KEY)) {
                this.discarded = true;
            }
            return done;
        }

        void update(FicheAPI fiche) {
            this.lang = fiche.getLang();
            this.titre = fiche.getTitre();
            FicheItems redacList = fiche.getRedacteurs();
            if (redacList == null) {
                this.redacteurGlobalIdList = StringUtils.EMPTY_STRINGLIST;
            } else {
                int size = redacList.size();
                ArrayList<String> tempList = new ArrayList<String>();
                for (int i = 0; i < size; ++i) {
                    Redacteur redacteur;
                    String redacteurGlobalId;
                    FicheItem ficheItem = (FicheItem)redacList.get(i);
                    if (!(ficheItem instanceof Personne) || (redacteurGlobalId = ((Personne)ficheItem).getRedacteurGlobalId()) == null || (redacteur = SphereUtils.getRedacteur(CorpusImpl.this.fichotheque, redacteurGlobalId)) == null) continue;
                    tempList.add(redacteurGlobalId);
                }
                this.redacteurGlobalIdList = StringUtils.toList(tempList);
            }
        }

        boolean setDate(FuzzyDate date, boolean modification) {
            int mask = 0;
            if (!modification) {
                if (FuzzyDate.compare(date, this.creationDate) != 0) {
                    mask = 1;
                    this.creationDate = date;
                    if (FuzzyDate.compare(this.modificationDate, date) < 0) {
                        this.modificationDate = date;
                        mask = 3;
                    }
                }
            } else if (this.creationDate == null) {
                this.creationDate = date;
                this.modificationDate = date;
                mask = 3;
            } else if (!date.equals(this.modificationDate) && FuzzyDate.compare(date, this.creationDate) > 0) {
                this.modificationDate = date;
                mask = 2;
            }
            return mask > 0;
        }
    }
}

