/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.RandomAccess;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.AttsImpl;
import net.fichotheque.corpus.fiche.ParagraphBlock;
import net.fichotheque.corpus.fiche.Td;
import net.fichotheque.corpus.fiche.TextContent;
import net.fichotheque.corpus.fiche.TextContentBuilder;
import net.fichotheque.corpus.fiche.Tr;
import net.fichotheque.corpus.fiche.ZoneBlock;

public class Table
extends AbstractList<Tr>
implements ZoneBlock,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 5L;
    private final ParagraphBlock numero = new ParagraphBlock();
    private final ParagraphBlock legende = new ParagraphBlock();
    private Tr[] trArray = new Tr[4];
    private int size = 0;
    private AttsImpl attsImpl;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Tr get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.trArray[index];
    }

    @Override
    public boolean add(Tr tr) {
        if (tr == null) {
            throw new NullPointerException();
        }
        this.checkLength();
        this.trArray[this.size] = tr;
        ++this.size;
        return true;
    }

    @Override
    public TextContent getNumero() {
        return this.numero;
    }

    @Override
    public TextContent getLegende() {
        return this.legende;
    }

    @Override
    public TextContentBuilder getNumeroBuilder() {
        return this.numero;
    }

    @Override
    public TextContentBuilder getLegendeBuilder() {
        return this.legende;
    }

    @Override
    public Atts getAtts() {
        return AttsImpl.check(this.attsImpl);
    }

    @Override
    public void putAtt(String name, String value) {
        this.attsImpl = AttsImpl.put(this.attsImpl, name, value);
    }

    private void checkLength() {
        if (this.size == this.trArray.length) {
            Tr[] nv = new Tr[this.size * 2];
            System.arraycopy(this.trArray, 0, nv, 0, this.size);
            this.trArray = nv;
        }
    }

    public static int checkColCount(Table table) {
        int cols = 0;
        for (Tr tr : table) {
            int cur = 0;
            int tdSize = tr.size();
            for (int j = 0; j < tdSize; ++j) {
                ++cur;
                Td td = tr.get(j);
                Atts atts = td.getAtts();
                int attLength = atts.size();
                for (int k = 0; k < attLength; ++k) {
                    String name = atts.getName(k);
                    if (!name.equals("colspan")) continue;
                    try {
                        int colspan = Integer.parseInt(atts.getValue(k));
                        if (colspan <= 1) continue;
                        cur = cur + colspan - 1;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            cols = Math.max(cols, cur);
        }
        return cols;
    }
}

