/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheBlocksImpl;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.FicheItemsImpl;
import net.fichotheque.corpus.fiche.Information;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.Personne;
import net.fichotheque.corpus.fiche.Propriete;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.StringUtils;

public class Fiche
implements FicheAPI,
Serializable {
    private static final long serialVersionUID = 13L;
    private static final List<Propriete> EMPTY_PROPRIETELIST = Collections.emptyList();
    private static final List<Information> EMPTY_INFORMATIONLIST = Collections.emptyList();
    private static final List<Section> EMPTY_SECTIONLIST = Collections.emptyList();
    private final Map<String, Object> fieldMap = new HashMap<String, Object>();
    private ArrayList<Information> informationList;
    private ArrayList<Propriete> proprieteList;
    private ArrayList<Section> sectionList;
    private FicheItemsImpl redacteurs = null;
    private String titre = "";
    private Para soustitre = null;
    private Lang lang = null;

    public void setLang(Lang lang) {
        this.lang = lang;
    }

    @Override
    public Lang getLang() {
        return this.lang;
    }

    @Override
    public String getTitre() {
        return this.titre;
    }

    public void setTitre(String titre) {
        if (titre == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.titre = StringUtils.cleanString(titre);
    }

    @Override
    public Para getSoustitre() {
        return this.soustitre;
    }

    public void setSoustitre(Para soustitrePara) {
        this.soustitre = soustitrePara == null || soustitrePara.isEmpty() ? null : soustitrePara;
    }

    @Override
    public FicheItems getRedacteurs() {
        return this.redacteurs;
    }

    @Override
    public List<Propriete> getProprieteList() {
        if (this.proprieteList == null) {
            return EMPTY_PROPRIETELIST;
        }
        return this.proprieteList;
    }

    @Override
    public List<Information> getInformationList() {
        if (this.informationList == null) {
            return EMPTY_INFORMATIONLIST;
        }
        return this.informationList;
    }

    @Override
    public List<Section> getSectionList() {
        if (this.sectionList == null) {
            return EMPTY_SECTIONLIST;
        }
        return this.sectionList;
    }

    public void appendRedacteurs(FicheItems ficheItems) {
        this.setRedacteurs(ficheItems, true);
    }

    public void setRedacteurs(FicheItems ficheItems) {
        this.setRedacteurs(ficheItems, false);
    }

    private void setRedacteurs(FicheItems ficheItems, boolean append) {
        if (ficheItems != null && ficheItems.isEmpty()) {
            ficheItems = null;
        }
        if (ficheItems == null) {
            if (!append) {
                this.redacteurs = null;
            }
            return;
        }
        if (this.redacteurs == null) {
            this.redacteurs = new FicheItemsImpl();
        } else if (!append) {
            this.redacteurs.clear();
        }
        for (FicheItem ficheItem : ficheItems) {
            if (!(ficheItem instanceof Item) && !(ficheItem instanceof Personne)) continue;
            this.redacteurs.add(ficheItem);
        }
        if (this.redacteurs.isEmpty()) {
            this.redacteurs = null;
        }
    }

    @Override
    public Information getInformation(FieldKey fieldKey) {
        if (!fieldKey.isInformation()) {
            throw new IllegalArgumentException("fieldKey is not an InformationFieldKey");
        }
        return (Information)this.getField(fieldKey);
    }

    @Override
    public Propriete getPropriete(FieldKey fieldKey) {
        if (!fieldKey.isPropriete()) {
            throw new IllegalArgumentException("fieldKey is not an ProprieteFieldKey");
        }
        return (Propriete)this.getField(fieldKey);
    }

    @Override
    public Section getSection(FieldKey fieldKey) {
        if (!fieldKey.isSection()) {
            throw new IllegalArgumentException("fieldKey is not an SectionFieldKey");
        }
        return (Section)this.getField(fieldKey);
    }

    public void appendInformation(FieldKey fieldKey, FicheItems ficheItems) {
        this.setInformation(fieldKey, ficheItems, true);
    }

    public void setInformation(FieldKey fieldKey, FicheItems ficheItems) {
        this.setInformation(fieldKey, ficheItems, false);
    }

    private void setInformation(FieldKey fieldKey, FicheItems ficheItems, boolean append) {
        InternalInformation current;
        if (!fieldKey.isInformation()) {
            throw new IllegalArgumentException("Not a Information FieldKey");
        }
        if (ficheItems != null && ficheItems.isEmpty()) {
            ficheItems = null;
        }
        if ((current = (InternalInformation)this.getField(fieldKey)) == null) {
            if (ficheItems == null) {
                return;
            }
            if (this.informationList == null) {
                this.informationList = new ArrayList();
            }
            InternalInformation information = new InternalInformation(fieldKey);
            information.addFicheItems(ficheItems);
            this.putField(fieldKey, information);
            this.informationList.add(information);
        } else if (ficheItems == null) {
            if (!append) {
                this.removeField(fieldKey);
                this.informationList.remove(current);
            }
        } else {
            if (!append) {
                current.clear();
            }
            current.addFicheItems(ficheItems);
        }
    }

    public void appendSection(FieldKey fieldKey, FicheBlocks ficheBlocks) {
        this.setSection(fieldKey, ficheBlocks, true);
    }

    public void setSection(FieldKey fieldKey, FicheBlocks ficheBlocks) {
        this.setSection(fieldKey, ficheBlocks, false);
    }

    private void setSection(FieldKey fieldKey, FicheBlocks ficheBlocks, boolean append) {
        InternalSection current;
        if (!fieldKey.isSection()) {
            throw new IllegalArgumentException("Not a Section FieldKey");
        }
        if (ficheBlocks != null && ficheBlocks.isEmpty()) {
            ficheBlocks = null;
        }
        if ((current = (InternalSection)this.getField(fieldKey)) == null) {
            if (ficheBlocks == null) {
                return;
            }
            if (this.sectionList == null) {
                this.sectionList = new ArrayList();
            }
            InternalSection section = new InternalSection(fieldKey);
            section.addAll(ficheBlocks);
            this.putField(fieldKey, section);
            this.sectionList.add(section);
        } else if (ficheBlocks == null) {
            if (!append) {
                this.removeField(fieldKey);
                this.sectionList.remove(current);
            }
        } else {
            if (!append) {
                current.clear();
            }
            current.addAll(ficheBlocks);
        }
    }

    public void setPropriete(FieldKey fieldKey, FicheItem ficheItem) {
        if (!fieldKey.isPropriete()) {
            throw new IllegalArgumentException("Not a Propriete FieldKey");
        }
        InternalPropriete current = (InternalPropriete)this.getField(fieldKey);
        if (current == null) {
            if (ficheItem == null) {
                return;
            }
            if (this.proprieteList == null) {
                this.proprieteList = new ArrayList();
            }
            InternalPropriete propriete = new InternalPropriete(fieldKey);
            propriete.setFicheItem(ficheItem);
            this.putField(fieldKey, propriete);
            this.proprieteList.add(propriete);
        } else if (ficheItem == null) {
            this.removeField(fieldKey);
            this.proprieteList.remove(current);
        } else {
            current.setFicheItem(ficheItem);
        }
    }

    public void clear() {
        this.titre = "";
        this.soustitre = null;
        this.redacteurs = null;
        if (this.informationList != null) {
            this.informationList.clear();
            this.informationList = null;
        }
        if (this.proprieteList != null) {
            this.proprieteList.clear();
            this.proprieteList = null;
        }
        if (this.sectionList != null) {
            this.sectionList.clear();
            this.sectionList = null;
        }
        this.clearFieldMap();
    }

    private Object getField(FieldKey fieldKey) {
        return this.fieldMap.get(fieldKey.getKeyString());
    }

    private void putField(FieldKey fieldKey, Object obj) {
        this.fieldMap.put(fieldKey.getKeyString(), obj);
    }

    private void removeField(FieldKey fieldKey) {
        this.fieldMap.remove(fieldKey.getKeyString());
    }

    private void clearFieldMap() {
        this.fieldMap.clear();
    }

    private static class InternalInformation
    extends FicheItemsImpl
    implements Information,
    Serializable {
        private final FieldKey fieldKey;

        private InternalInformation(FieldKey fieldKey) {
            this.fieldKey = fieldKey;
        }

        @Override
        public FieldKey getFieldKey() {
            return this.fieldKey;
        }
    }

    private static class InternalSection
    extends FicheBlocksImpl
    implements Section,
    Serializable {
        private final FieldKey fieldKey;

        private InternalSection(FieldKey fieldKey) {
            this.fieldKey = fieldKey;
        }

        @Override
        public FieldKey getFieldKey() {
            return this.fieldKey;
        }
    }

    private static class InternalPropriete
    implements Propriete,
    Serializable {
        private final FieldKey fieldKey;
        private FicheItem item;

        private InternalPropriete(FieldKey fieldKey) {
            this.fieldKey = fieldKey;
        }

        @Override
        public FieldKey getFieldKey() {
            return this.fieldKey;
        }

        @Override
        public FicheItem getFicheItem() {
            return this.item;
        }

        private void setFicheItem(FicheItem ficheitem) {
            this.item = ficheitem;
        }
    }
}

