/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.xml;

import java.io.IOException;
import java.io.InputStream;
import net.mapeadores.util.base64.Base64;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.xml.DefaultXMLWriter;

public class DocStreamXMLPackWriter
extends DefaultXMLWriter {
    public void appendDocStream(DocStream docStream, String path) throws IOException {
        String charset = docStream.getCharset();
        this.startOpenTag("xml-pack");
        if (charset == null) {
            this.addAttribute("type", "base64");
        } else {
            this.addAttribute("type", "cdata");
        }
        this.addAttribute("path", path);
        this.addAttribute("mime-type", docStream.getMimeType());
        this.endOpenTag();
        if (charset == null) {
            try (InputStream is = docStream.getInputStream();){
                byte[] byteArray = IOUtils.toByteArray(is);
                this.append(Base64.encodeBase64String(byteArray));
            }
        }
        try (InputStream is = docStream.getInputStream();){
            String text = IOUtils.toString(is, charset);
            this.addCData(text);
        }
        this.closeTag("xml-pack", false);
    }
}

