/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ui;

import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UiComponentsBuilder {
    private final List<UiComponent> uiComponentList = new ArrayList<UiComponent>();
    private final Map<String, UiComponent> componentUiMap = new HashMap<String, UiComponent>();

    public UiComponentsBuilder addUiComponent(UiComponent componentUi) {
        String name = componentUi.getName();
        UiComponent currentComponentUi = this.componentUiMap.get(name);
        if (currentComponentUi != null) {
            if (currentComponentUi instanceof CommentUi) {
                this.uiComponentList.add(currentComponentUi);
            }
        } else {
            this.uiComponentList.add(componentUi);
            this.componentUiMap.put(name, componentUi);
        }
        return this;
    }

    public UiComponents toUiComponents() {
        List<UiComponent> finalUiComponentList = UiUtils.wrap(this.uiComponentList.toArray(new UiComponent[this.uiComponentList.size()]));
        HashMap<String, UiComponent> cloneComponentUiMap = new HashMap<String, UiComponent>(this.componentUiMap);
        return new InternalUiComponents(finalUiComponentList, cloneComponentUiMap);
    }

    public static UiComponentsBuilder init() {
        return new UiComponentsBuilder();
    }

    private static final class InternalUiComponents
    implements UiComponents {
        private final List<UiComponent> uiComponentList;
        private final Map<String, UiComponent> componentUiMap;

        private InternalUiComponents(List<UiComponent> uiComponentList, Map<String, UiComponent> componentUiMap) {
            this.uiComponentList = uiComponentList;
            this.componentUiMap = componentUiMap;
        }

        @Override
        public List<UiComponent> getUiComponentList() {
            return this.uiComponentList;
        }

        @Override
        public UiComponent getUiComponent(String keyString) {
            return this.componentUiMap.get(keyString);
        }
    }
}

