/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.subsettree;

import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.tools.subsettree.NodeListBuilder;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.util.Collection;
import java.util.List;

public class SubsetTreeBuilder
extends NodeListBuilder {
    private final boolean ignoreEmptyGroupNode;

    public SubsetTreeBuilder(boolean ignoreEmptyGroupNode) {
        this.ignoreEmptyGroupNode = ignoreEmptyGroupNode;
    }

    public boolean ignoreEmptyGroupNode() {
        return this.ignoreEmptyGroupNode;
    }

    public SubsetTree toSubsetTree() {
        return new InternalSubsetTree(this.toNodeList(this.ignoreEmptyGroupNode));
    }

    public static SubsetTreeBuilder init(boolean ignoreEmptyGroupNode) {
        return new SubsetTreeBuilder(ignoreEmptyGroupNode);
    }

    public static SubsetTree build(Collection<SubsetTree.Node> nodes) {
        int size = nodes.size();
        SubsetTree.Node[] array = nodes.toArray(new SubsetTree.Node[size]);
        return new InternalSubsetTree(TreeUtils.wrap(array));
    }

    private static class InternalSubsetTree
    implements SubsetTree {
        private final List<SubsetTree.Node> list;

        private InternalSubsetTree(List<SubsetTree.Node> list) {
            this.list = list;
        }

        @Override
        public List<SubsetTree.Node> getNodeList() {
            return this.list;
        }
    }
}

