/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.subsettree;

import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import net.fichotheque.SubsetKey;

public class SubsetNodeBuilder {
    private final SubsetKey subsetKey;

    public SubsetNodeBuilder(SubsetKey subsetKey) {
        if (subsetKey == null) {
            throw new IllegalArgumentException("subsetKey is null");
        }
        this.subsetKey = subsetKey;
    }

    public SubsetNode toSubsetNode() {
        return new InternalSubsetNode(this.subsetKey);
    }

    public static SubsetNodeBuilder init(SubsetKey subsetKey) {
        return new SubsetNodeBuilder(subsetKey);
    }

    public static SubsetNode build(SubsetKey subsetKey) {
        if (subsetKey == null) {
            throw new IllegalArgumentException("subsetKey is null");
        }
        return new InternalSubsetNode(subsetKey);
    }

    private static class InternalSubsetNode
    implements SubsetNode {
        private final SubsetKey subsetKey;

        private InternalSubsetNode(SubsetKey subsetKey) {
            this.subsetKey = subsetKey;
        }

        @Override
        public SubsetKey getSubsetKey() {
            return this.subsetKey;
        }
    }
}

